/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.async;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.pms.network.HttpServletHelper;
import net.pms.network.UmsAsyncListener;
import net.pms.network.mediaserver.jupnp.transport.async.JakartaAsyncServletUpnpStream;
import net.pms.network.mediaserver.jupnp.transport.impl.JakartaServletStreamServerConfigurationImpl;
import org.jupnp.transport.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaAsyncServlet
extends HttpServletHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JakartaAsyncServlet.class);
    private final Router router;
    private int mCounter = 0;
    private final JakartaServletStreamServerConfigurationImpl configuration;

    public JakartaAsyncServlet(Router router, JakartaServletStreamServerConfigurationImpl configuration) {
        this.router = router;
        this.configuration = configuration;
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (JakartaAsyncServlet.deny(req)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        int counter = this.mCounter++;
        LOGGER.trace("HttpServlet {}", (Object)String.format("HttpServlet.service(): id: %3d, request URI: %s", counter, req.getRequestURI()));
        LOGGER.trace("Handling Servlet request asynchronously: {}", (Object)req);
        AsyncContext async = req.startAsync();
        async.setTimeout(this.configuration.getAsyncTimeoutSeconds() * 1000);
        async.addListener(new UmsAsyncListener(startTime, counter));
        JakartaAsyncServletUpnpStream stream = new JakartaAsyncServletUpnpStream(this.router.getProtocolFactory(), async, req);
        this.router.received(stream);
    }
}

