/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item;

import java.net.URI;
import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.DayOfWeekValue;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;

public class VideoItem
extends Item {
    private static final UPNP.Class CLASS = new UPNP.Class("object.item.videoItem");

    public VideoItem() {
        this.setUpnpClass(CLASS);
    }

    public VideoItem(Item other) {
        super(other);
    }

    public VideoItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public VideoItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.setResources(resource);
        }
    }

    public String getFirstGenre() {
        return (String)this.properties.getValue(UPNP.Genre.class);
    }

    public String[] getGenres() {
        List list = this.properties.getValues(UPNP.Genre.class);
        return (String[])list.toArray(String[]::new);
    }

    public VideoItem setGenres(String[] genres) {
        this.properties.remove(UPNP.Genre.class);
        for (String genre : genres) {
            this.properties.add(new UPNP.Genre(genre));
        }
        return this;
    }

    public VideoItem addGenre(String genre) {
        this.properties.add(new UPNP.Genre(genre));
        return this;
    }

    public VideoItem addGenre(String genre, String id) {
        this.properties.add(new UPNP.Genre(genre, id, null));
        return this;
    }

    public String getLongDescription() {
        return (String)this.properties.getValue(UPNP.LongDescription.class);
    }

    public VideoItem setLongDescription(String description) {
        this.properties.set(new UPNP.LongDescription(description));
        return this;
    }

    public String getFirstProducer() {
        return (String)this.properties.getValue(UPNP.Producer.class);
    }

    public String[] getProducers() {
        List list = this.properties.getValues(UPNP.Producer.class);
        return (String[])list.toArray(String[]::new);
    }

    public VideoItem setProducers(String[] producers) {
        this.properties.remove(UPNP.Producer.class);
        for (String producer : producers) {
            this.properties.add(new UPNP.Producer(producer));
        }
        return this;
    }

    public String getRating() {
        return (String)this.properties.getValue(UPNP.Rating.class);
    }

    public VideoItem setRating(String rating) {
        this.properties.set(new UPNP.Rating(rating));
        return this;
    }

    public UPNP.Actor getFirstActor() {
        return this.properties.get(UPNP.Actor.class);
    }

    public UPNP.Actor[] getActors() {
        List<UPNP.Actor> list = this.properties.getAll(UPNP.Actor.class);
        return (UPNP.Actor[])list.toArray(UPNP.Actor[]::new);
    }

    public VideoItem setActors(UPNP.Actor[] actors) {
        this.properties.remove(UPNP.Actor.class);
        for (UPNP.Actor actor : actors) {
            this.properties.add(actor);
        }
        return this;
    }

    public String getFirstDirector() {
        return (String)this.properties.getValue(UPNP.Director.class);
    }

    public String[] getDirectors() {
        List list = this.properties.getValues(UPNP.Director.class);
        return (String[])list.toArray(String[]::new);
    }

    public VideoItem setDirectors(String[] directors) {
        this.properties.remove(UPNP.Director.class);
        for (String director : directors) {
            this.properties.add(new UPNP.Director(director));
        }
        return this;
    }

    public String getDescription() {
        return (String)this.properties.getValue(DC.Description.class);
    }

    public VideoItem setDescription(String description) {
        this.properties.set(new DC.Description(description));
        return this;
    }

    public String getFirstPublisher() {
        return (String)this.properties.getValue(DC.Publisher.class);
    }

    public String[] getPublishers() {
        List list = this.properties.getValues(DC.Publisher.class);
        return (String[])list.toArray(String[]::new);
    }

    public VideoItem setPublishers(String[] publishers) {
        this.properties.remove(DC.Publisher.class);
        for (String publisher : publishers) {
            this.properties.add(new DC.Publisher(publisher));
        }
        return this;
    }

    public String getLanguage() {
        return (String)this.properties.getValue(DC.Language.class);
    }

    public VideoItem setLanguage(String language) {
        this.properties.set(new DC.Language(language));
        return this;
    }

    public URI getFirstRelation() {
        return (URI)this.properties.getValue(DC.Relation.class);
    }

    public URI[] getRelations() {
        List list = this.properties.getValues(DC.Relation.class);
        return (URI[])list.toArray(URI[]::new);
    }

    public VideoItem setRelations(URI[] relations) {
        this.properties.remove(DC.Relation.class);
        for (URI relation : relations) {
            this.properties.add(new DC.Relation(relation));
        }
        return this;
    }

    public Integer getPlaybackCount() {
        return (Integer)this.properties.getValue(UPNP.PlaybackCount.class);
    }

    public VideoItem setPlaybackCount(Integer playbackCount) {
        this.properties.set(new UPNP.PlaybackCount(playbackCount));
        return this;
    }

    public String getLastPlaybackTime() {
        return (String)this.properties.getValue(UPNP.LastPlaybackTime.class);
    }

    public VideoItem setLastPlaybackTime(String lastPlaybackTime) {
        this.properties.set(new UPNP.LastPlaybackTime(lastPlaybackTime));
        return this;
    }

    public String getLastPlaybackPosition() {
        return (String)this.properties.getValue(UPNP.LastPlaybackPosition.class);
    }

    public VideoItem setLastPlaybackPosition(String lastPlaybackPosition) {
        this.properties.set(new UPNP.LastPlaybackPosition(lastPlaybackPosition));
        return this;
    }

    public String getRecordedDayOfWeek() {
        return (String)this.properties.getValue(UPNP.RecordedDayOfWeek.class);
    }

    public VideoItem setRecordedDayOfWeek(DayOfWeekValue recordedDayOfWeek) {
        this.properties.set(new UPNP.RecordedDayOfWeek(recordedDayOfWeek));
        return this;
    }

    public String getSrsRecordScheduleID() {
        return (String)this.properties.getValue(UPNP.SrsRecordScheduleID.class);
    }

    public VideoItem setSrsRecordScheduleID(String srsRecordScheduleID) {
        this.properties.set(new UPNP.SrsRecordScheduleID(srsRecordScheduleID));
        return this;
    }
}

