/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item;

import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.VideoItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.StorageMediumValue;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;

public class Movie
extends VideoItem {
    private static final UPNP.Class CLASS = new UPNP.Class("object.item.videoItem.movie");

    public Movie() {
        this.setUpnpClass(CLASS);
    }

    public Movie(Item other) {
        super(other);
    }

    public Movie(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public Movie(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, resource);
        this.setUpnpClass(CLASS);
    }

    public String getStorageMedium() {
        return (String)this.properties.getValue(UPNP.StorageMedium.class);
    }

    public Movie setStorageMedium(String storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public Movie setStorageMedium(StorageMediumValue storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public Integer getDVDRegionCode() {
        return (Integer)this.properties.getValue(UPNP.DVDRegionCode.class);
    }

    public Movie setDVDRegionCode(Integer dvdRegionCode) {
        this.properties.set(new UPNP.DVDRegionCode(dvdRegionCode));
        return this;
    }

    public String getChannelName() {
        return (String)this.properties.getValue(UPNP.ChannelName.class);
    }

    public Movie setChannelName(String channelName) {
        this.properties.set(new UPNP.ChannelName(channelName));
        return this;
    }

    public String getFirstScheduledStartTime() {
        return (String)this.properties.getValue(UPNP.ScheduledStartTime.class);
    }

    public String[] getScheduledStartTimes() {
        List list = this.properties.getValues(UPNP.ScheduledStartTime.class);
        return (String[])list.toArray(String[]::new);
    }

    public Movie setScheduledStartTimes(String[] strings) {
        this.properties.remove(UPNP.ScheduledStartTime.class);
        for (String s : strings) {
            this.properties.add(new UPNP.ScheduledStartTime(s));
        }
        return this;
    }

    public String getFirstScheduledEndTime() {
        return (String)this.properties.getValue(UPNP.ScheduledEndTime.class);
    }

    public String[] getScheduledEndTimes() {
        List list = this.properties.getValues(UPNP.ScheduledEndTime.class);
        return (String[])list.toArray(String[]::new);
    }

    public Movie setScheduledEndTimes(String[] strings) {
        this.properties.remove(UPNP.ScheduledEndTime.class);
        for (String s : strings) {
            this.properties.add(new UPNP.ScheduledEndTime(s));
        }
        return this;
    }

    public String getProgramTitle() {
        return (String)this.properties.getValue(UPNP.ProgramTitle.class);
    }

    public VideoItem setProgramTitle(String programTitle) {
        this.properties.set(new UPNP.ProgramTitle(programTitle));
        return this;
    }

    public String getSeriesTitle() {
        return (String)this.properties.getValue(UPNP.SeriesTitle.class);
    }

    public VideoItem setSeriesTitle(String seriesTitle) {
        this.properties.set(new UPNP.SeriesTitle(seriesTitle));
        return this;
    }

    public UnsignedInteger getEpisodeCount() {
        return (UnsignedInteger)this.properties.getValue(UPNP.EpisodeCount.class);
    }

    public VideoItem setEpisodeCount(UnsignedInteger episodeCount) {
        this.properties.set(new UPNP.EpisodeCount(episodeCount));
        return this;
    }

    public VideoItem setEpisodeCount(int episodeCount) {
        return this.setEpisodeCount(UnsignedInteger.fromIntBits(episodeCount));
    }

    public UnsignedInteger getEpisodeNumber() {
        return (UnsignedInteger)this.properties.getValue(UPNP.EpisodeNumber.class);
    }

    public VideoItem setEpisodeNumber(UnsignedInteger episodeNumber) {
        this.properties.set(new UPNP.EpisodeNumber(episodeNumber));
        return this;
    }

    public VideoItem setEpisodeNumber(int episodeNumber) {
        return this.setEpisodeNumber(UnsignedInteger.fromIntBits(episodeNumber));
    }

    public UnsignedInteger getEpisodeSeason() {
        return (UnsignedInteger)this.properties.getValue(UPNP.EpisodeSeason.class);
    }

    public VideoItem setEpisodeSeason(UnsignedInteger episodeSeason) {
        this.properties.set(new UPNP.EpisodeSeason(episodeSeason));
        return this;
    }

    public VideoItem setEpisodeSeason(int episodeSeason) {
        return this.setEpisodeSeason(UnsignedInteger.fromIntBits(episodeSeason));
    }
}

