/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item;

import java.net.URI;
import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;

public class AudioItem
extends Item {
    private static final UPNP.Class CLASS = new UPNP.Class("object.item.audioItem");

    public AudioItem() {
        this.setUpnpClass(CLASS);
    }

    public AudioItem(Item other) {
        super(other);
    }

    public AudioItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public AudioItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.setResources(resource);
        }
    }

    public String getFirstGenre() {
        return (String)this.properties.getValue(UPNP.Genre.class);
    }

    public String[] getGenres() {
        List list = this.properties.getValues(UPNP.Genre.class);
        return (String[])list.toArray(String[]::new);
    }

    public AudioItem setGenres(String[] genres) {
        this.properties.remove(UPNP.Genre.class);
        for (String genre : genres) {
            this.properties.add(new UPNP.Genre(genre));
        }
        return this;
    }

    public String getDescription() {
        return (String)this.properties.getValue(DC.Description.class);
    }

    public AudioItem setDescription(String description) {
        this.properties.set(new DC.Description(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.properties.getValue(UPNP.LongDescription.class);
    }

    public AudioItem setLongDescription(String description) {
        this.properties.set(new UPNP.LongDescription(description));
        return this;
    }

    public String getFirstPublisher() {
        return (String)this.properties.getValue(DC.Publisher.class);
    }

    public String[] getPublishers() {
        List list = this.properties.getValues(DC.Publisher.class);
        return (String[])list.toArray(String[]::new);
    }

    public AudioItem setPublishers(String[] publishers) {
        this.properties.remove(DC.Publisher.class);
        for (String publisher : publishers) {
            this.properties.add(new DC.Publisher(publisher));
        }
        return this;
    }

    public String getLanguage() {
        return (String)this.properties.getValue(DC.Language.class);
    }

    public AudioItem setLanguage(String language) {
        this.properties.set(new DC.Language(language));
        return this;
    }

    public URI getFirstRelation() {
        return (URI)this.properties.getValue(DC.Relation.class);
    }

    public URI[] getRelations() {
        List list = this.properties.getValues(DC.Relation.class);
        return (URI[])list.toArray(URI[]::new);
    }

    public AudioItem setRelations(URI[] relations) {
        this.properties.remove(DC.Relation.class);
        for (URI relation : relations) {
            this.properties.add(new DC.Relation(relation));
        }
        return this;
    }

    public String getFirstRights() {
        return (String)this.properties.getValue(DC.Rights.class);
    }

    public String[] getRights() {
        List list = this.properties.getValues(DC.Rights.class);
        return (String[])list.toArray(String[]::new);
    }

    public AudioItem setRights(String[] rights) {
        this.properties.remove(DC.Rights.class);
        for (String right : rights) {
            this.properties.add(new DC.Rights(right));
        }
        return this;
    }
}

