/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container;

import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.StorageMediumValue;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;

public class PlaylistContainer
extends Container {
    private static final UPNP.Class CLASS = new UPNP.Class("object.container.playlistContainer");

    public PlaylistContainer() {
        this.setUpnpClass(CLASS);
    }

    public PlaylistContainer(Container other) {
        super(other);
        this.setUpnpClass(CLASS);
    }

    public PlaylistContainer(String id, Container parent, String title, String creator, Long childCount) {
        this(id, parent.getId(), title, creator, childCount);
    }

    public PlaylistContainer(String id, String parentID, String title, String creator, Long childCount) {
        super(id, parentID, title, creator, CLASS, childCount);
    }

    public UPNP.Artist getFirstArtist() {
        return this.properties.get(UPNP.Artist.class);
    }

    public List<UPNP.Artist> getArtists() {
        return this.properties.getAll(UPNP.Artist.class);
    }

    public PlaylistContainer setArtists(UPNP.Artist[] artists) {
        this.properties.remove(UPNP.Artist.class);
        for (UPNP.Artist artist : artists) {
            this.properties.add(artist);
        }
        return this;
    }

    public String getFirstGenre() {
        return (String)this.properties.getValue(UPNP.Genre.class);
    }

    public String[] getGenres() {
        List list = this.properties.getValues(UPNP.Genre.class);
        return (String[])list.toArray(String[]::new);
    }

    public PlaylistContainer setGenres(String[] genres) {
        this.properties.remove(UPNP.Genre.class);
        for (String genre : genres) {
            this.properties.add(new UPNP.Genre(genre));
        }
        return this;
    }

    public String getLongDescription() {
        return (String)this.properties.getValue(UPNP.LongDescription.class);
    }

    public PlaylistContainer setLongDescription(String description) {
        this.properties.set(new UPNP.LongDescription(description));
        return this;
    }

    public String getFirstProducer() {
        return (String)this.properties.getValue(UPNP.Producer.class);
    }

    public String[] getProducers() {
        List list = this.properties.getValues(UPNP.Producer.class);
        return (String[])list.toArray(String[]::new);
    }

    public PlaylistContainer setProducers(String[] producers) {
        this.properties.remove(UPNP.Producer.class);
        for (String producer : producers) {
            this.properties.add(new UPNP.Producer(producer));
        }
        return this;
    }

    public String getStorageMedium() {
        return (String)this.properties.getValue(UPNP.StorageMedium.class);
    }

    public PlaylistContainer setStorageMedium(String storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public PlaylistContainer setStorageMedium(StorageMediumValue storageMedium) {
        this.properties.set(new UPNP.StorageMedium(storageMedium));
        return this;
    }

    public String getDescription() {
        return (String)this.properties.getValue(DC.Description.class);
    }

    public PlaylistContainer setDescription(String description) {
        this.properties.set(new DC.Description(description));
        return this;
    }

    public String getFirstContributor() {
        return (String)this.properties.getValue(DC.Contributor.class);
    }

    public String[] getContributors() {
        List list = this.properties.getValues(DC.Contributor.class);
        return (String[])list.toArray(String[]::new);
    }

    public PlaylistContainer setContributors(String[] contributors) {
        this.properties.remove(DC.Contributor.class);
        for (String contributor : contributors) {
            this.properties.add(new DC.Contributor(contributor));
        }
        return this;
    }

    public String getDate() {
        return (String)this.properties.getValue(DC.Date.class);
    }

    public PlaylistContainer setDate(String date) {
        this.properties.set(new DC.Date(date));
        return this;
    }

    public String getLanguage() {
        return (String)this.properties.getValue(DC.Language.class);
    }

    public PlaylistContainer setLanguage(String language) {
        this.properties.set(new DC.Language(language));
        return this;
    }

    public String getFirstRights() {
        return (String)this.properties.getValue(DC.Rights.class);
    }

    public String[] getRights() {
        List list = this.properties.getValues(DC.Rights.class);
        return (String[])list.toArray(String[]::new);
    }

    public PlaylistContainer setRights(String[] rights) {
        this.properties.remove(DC.Rights.class);
        for (String right : rights) {
            this.properties.add(new DC.Rights(right));
        }
        return this;
    }
}

