/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.handlers;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.database.MediaDatabase;
import net.pms.dlna.DidlHelper;
import net.pms.media.audio.metadata.MusicBrainzAlbum;
import net.pms.network.mediaserver.handlers.message.SearchRequest;
import net.pms.renderers.Renderer;
import net.pms.store.DbIdLibrary;
import net.pms.store.DbIdMediaType;
import net.pms.store.DbIdResourceLocator;
import net.pms.store.DbIdTypeAndIdent;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreResource;
import net.pms.store.container.MusicBrainzAlbumFolder;
import net.pms.store.container.MusicBrainzPersonFolder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.support.model.SortCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchRequestHandler.class);
    private static final String CRLF = "\r\n";
    private static final Pattern CLASS_PATTERN = Pattern.compile("upnp:class\\s(\\bderivedfrom\\b|=)\\s+\"(?<val>.*?)\"", 2);
    private static final Pattern ARTIST_ROLE = Pattern.compile("upnp:class.*role\\s*=\\s*\"(?<val>.*?)\".*", 2);
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("(?<property>((\\bdc\\b)|(\\bupnp\\b)):[A-Za-z@\\[\\]\"=]+)\\s+(?<op>[A-Za-z=!<>]+)\\s+\"(?<val>.*?)\"", 2);

    public static DbIdMediaType getRequestType(String searchCriteria) {
        LOGGER.debug("search criteria : {}", (Object)searchCriteria);
        Matcher matcher = CLASS_PATTERN.matcher(searchCriteria);
        if (matcher.find()) {
            String propertyValue = matcher.group("val");
            LOGGER.trace("upnp:class is {}", (Object)propertyValue);
            if (propertyValue != null) {
                if ((propertyValue = propertyValue.toLowerCase()).startsWith("object.item.audioitem")) {
                    return DbIdMediaType.TYPE_AUDIO;
                }
                if (propertyValue.startsWith("object.item.videoitem")) {
                    return DbIdMediaType.TYPE_VIDEO;
                }
                if (propertyValue.startsWith("object.item.imageitem")) {
                    return DbIdMediaType.TYPE_IMAGE;
                }
                if (propertyValue.startsWith("object.container.person")) {
                    return SearchRequestHandler.resolveRolePerson(searchCriteria);
                }
                if (propertyValue.startsWith("object.container.album")) {
                    return DbIdMediaType.TYPE_ALBUM;
                }
                if (propertyValue.startsWith("object.container.playlistcontainer")) {
                    return DbIdMediaType.TYPE_PLAYLIST;
                }
                if (propertyValue.startsWith("object.container")) {
                    return DbIdMediaType.TYPE_FOLDER;
                }
            }
        }
        throw new RuntimeException("Unknown type : " + (searchCriteria != null ? searchCriteria : "NULL"));
    }

    private static DbIdMediaType resolveRolePerson(String searchCriteria) {
        Matcher matcher = ARTIST_ROLE.matcher(searchCriteria);
        if (matcher.find()) {
            String roleValue = matcher.group("val");
            if ("composer".equalsIgnoreCase(roleValue)) {
                LOGGER.debug("looking up artist composer");
                return DbIdMediaType.TYPE_PERSON_COMPOSER;
            }
            if ("conductor".equalsIgnoreCase(roleValue)) {
                LOGGER.debug("looking up artist conductor");
                return DbIdMediaType.TYPE_PERSON_CONDUCTOR;
            }
            if ("AlbumArtist".equalsIgnoreCase(roleValue)) {
                LOGGER.debug("looking up artist AlbumArtist");
                return DbIdMediaType.TYPE_PERSON_ALBUMARTIST;
            }
            LOGGER.warn("unknown artist role {}. Fallback to artist search ... ", (Object)roleValue);
            return DbIdMediaType.TYPE_PERSON;
        }
        LOGGER.trace("artist without role. Regular artist search.");
        return DbIdMediaType.TYPE_PERSON;
    }

    public StringBuilder createSearchResponse(SearchRequest requestMessage, Renderer renderer) {
        int numberReturned = 0;
        StringBuilder dlnaItems = new StringBuilder();
        DbIdMediaType requestType = SearchRequestHandler.getRequestType(requestMessage.getSearchCriteria());
        int totalMatches = SearchRequestHandler.getLibraryResourceCountFromSQL(SearchRequestHandler.convertToCountSql(requestMessage.getSearchCriteria(), requestType));
        String sqlFiles = SearchRequestHandler.convertToFilesSql(requestMessage, requestType);
        for (StoreResource resource : SearchRequestHandler.getLibraryResourceFromSQL(renderer, sqlFiles, requestType)) {
            ++numberReturned;
            dlnaItems.append(DidlHelper.getDidlString(resource));
        }
        StringBuilder response = SearchRequestHandler.buildEnvelope(numberReturned, totalMatches, MediaStoreIds.getSystemUpdateId().getValue(), dlnaItems);
        return SearchRequestHandler.createResponse(response.toString());
    }

    private static String addSqlSelectByType(DbIdMediaType requestType) {
        switch (requestType) {
            case TYPE_AUDIO: {
                return "select A.RATING, A.GENRE, FILENAME, MODIFIED, F.ID as FID, F.ID as oid from FILES as F left outer join AUDIO_METADATA as A on F.ID = A.FILEID where ";
            }
            case TYPE_PERSON: {
                return "select DISTINCT ON (FILENAME) A.ARTIST as FILENAME, A.AUDIOTRACK_ID as oid from AUDIO_METADATA as A where ";
            }
            case TYPE_PERSON_CONDUCTOR: {
                return "select DISTINCT ON (FILENAME) A.CONDUCTOR as FILENAME, A.A.AUDIOTRACK_ID as oid from AUDIO_METADATA as A where ";
            }
            case TYPE_PERSON_COMPOSER: {
                return "select DISTINCT ON (FILENAME) A.COMPOSER as FILENAME, A.AUDIOTRACK_ID as oid from AUDIO_METADATA as A where ";
            }
            case TYPE_PERSON_ALBUMARTIST: {
                return "select DISTINCT ON (FILENAME) A.ALBUMARTIST as FILENAME, A.AUDIOTRACK_ID as oid from AUDIO_METADATA as A where ";
            }
            case TYPE_ALBUM: {
                return "select DISTINCT ON (album) mbid_release as liked, MBID_RECORD, album, artist, media_year, genre, ALBUM as FILENAME, A.AUDIOTRACK_ID as oid, A.MBID_RECORD from MUSIC_BRAINZ_RELEASE_LIKE as m right outer join AUDIO_METADATA as a on m.mbid_release = A.mbid_record where ";
            }
            case TYPE_PLAYLIST: {
                return "select DISTINCT ON (FILENAME) FILENAME, MODIFIED, F.ID as FID, F.ID as oid from FILES as F where ";
            }
            case TYPE_FOLDER: {
                return "select DISTINCT ON (child.NAME) child.NAME, child.ID as FID, child.ID as oid, parent.ID as parent_id from STORE_IDS child, STORE_IDS parent where ";
            }
            case TYPE_VIDEO: 
            case TYPE_IMAGE: {
                return "select FILENAME, MODIFIED, F.ID as FID, F.ID as oid from FILES as F where ";
            }
        }
        throw new RuntimeException("not implemented request type : " + String.valueOf(requestType != null ? requestType : "NULL"));
    }

    private static String addSqlSelectCountByType(DbIdMediaType requestType) {
        switch (requestType) {
            case TYPE_AUDIO: {
                return "select count(DISTINCT F.id) from FILES as F left outer join AUDIO_METADATA as A on F.ID = A.FILEID where ";
            }
            case TYPE_PERSON: {
                return "select count (DISTINCT A.ARTIST) from AUDIO_METADATA as A where ";
            }
            case TYPE_PERSON_CONDUCTOR: {
                return "select count (DISTINCT A.CONDUCTOR) from AUDIO_METADATA as A where ";
            }
            case TYPE_PERSON_COMPOSER: {
                return "select count (DISTINCT A.COMPOSER) from AUDIO_METADATA as A where ";
            }
            case TYPE_PERSON_ALBUMARTIST: {
                return "select count (DISTINCT A.ALBUMARTIST) from AUDIO_METADATA as A where ";
            }
            case TYPE_ALBUM: {
                return "select count(DISTINCT A.AUDIOTRACK_ID) from AUDIO_METADATA as A where ";
            }
            case TYPE_PLAYLIST: {
                return "select count(DISTINCT F.id) from FILES as F where ";
            }
            case TYPE_VIDEO: 
            case TYPE_IMAGE: {
                return "select count(DISTINCT F.id) from FILES as F where ";
            }
            case TYPE_FOLDER: {
                return "select count(DISTINCT child.NAME) from STORE_IDS child, STORE_IDS parent where ";
            }
        }
        throw new RuntimeException("not implemented request type : " + String.valueOf(requestType != null ? requestType : "NULL"));
    }

    public static String convertToFilesSql(SearchRequest requestMessage, DbIdMediaType requestType) {
        StringBuilder sb = new StringBuilder();
        sb.append(SearchRequestHandler.addSqlSelectByType(requestType));
        SearchRequestHandler.addSqlWherePart(requestMessage.getSearchCriteria(), requestType, sb);
        SearchRequestHandler.addOrderBy(requestMessage.getSortCriteria(), requestType, sb);
        SearchRequestHandler.addLimit(requestMessage.getStartingIndex().intValue(), requestMessage.getRequestedCount().intValue(), sb);
        LOGGER.debug(sb.toString());
        return sb.toString();
    }

    public static String convertToFilesSql(String searchCriteria, long startingIndex, long requestedCount, SortCriterion[] orderBy, DbIdMediaType requestType) {
        StringBuilder sb = new StringBuilder();
        sb.append(SearchRequestHandler.addSqlSelectByType(requestType));
        SearchRequestHandler.addSqlWherePart(searchCriteria, requestType, sb);
        SearchRequestHandler.addOrderBy(orderBy, requestType, sb);
        SearchRequestHandler.addLimit(startingIndex, requestedCount, sb);
        LOGGER.trace(sb.toString());
        return sb.toString();
    }

    private static void addOrderBy(SortCriterion[] orderBy, DbIdMediaType requestType, StringBuilder sb) {
        sb.append(" ORDER BY ");
        try {
            for (SortCriterion sort : orderBy) {
                String field;
                if (StringUtils.isAllBlank(sort.getPropertyName()) || StringUtils.isAllBlank(field = SearchRequestHandler.getField(sort.getPropertyName(), requestType))) continue;
                sb.append(field);
                sb.append(sort.isAscending() ? " ASC " : " DESC ");
                sb.append(", ");
            }
        }
        catch (Exception e) {
            LOGGER.trace("ERROR while processing 'addOrderBy'");
        }
        sb.append(String.format(" oid ", new Object[0]));
    }

    private static void addOrderBy(String sortCriteria, DbIdMediaType requestType, StringBuilder sb) {
        sb.append(" ORDER BY ");
        if (!StringUtils.isAllBlank(sortCriteria)) {
            String[] sortElements = sortCriteria.split("[;, ]");
            try {
                for (String sort : sortElements) {
                    if (StringUtils.isAllBlank(sort)) continue;
                    String field = SearchRequestHandler.getField(sort.substring(1), requestType);
                    if (StringUtils.isAllBlank(field)) continue;
                    sb.append(field);
                    sb.append(SearchRequestHandler.sortOrder(sort.substring(0, 1)));
                    sb.append(", ");
                }
            }
            catch (Exception e) {
                LOGGER.trace("ERROR while processing 'addOrderBy'");
            }
        }
        sb.append(String.format(" oid ", new Object[0]));
    }

    private static String sortOrder(String order) {
        if ("+".equals(order)) {
            return " ASC ";
        }
        if ("-".equals(order)) {
            return " DESC ";
        }
        return "";
    }

    private static void addLimit(long startingIndex, long requestedCount, StringBuilder sb) {
        long limit = requestedCount;
        if (limit == 0L) {
            limit = 999L;
        }
        sb.append(String.format(" LIMIT %d OFFSET %d ", limit, startingIndex));
    }

    public static String convertToCountSql(String upnpSearch, DbIdMediaType requestType) {
        StringBuilder sb = new StringBuilder();
        sb.append(SearchRequestHandler.addSqlSelectCountByType(requestType));
        SearchRequestHandler.addSqlWherePart(upnpSearch, requestType, sb);
        return sb.toString();
    }

    private static void addSqlWherePart(String searchCriteria, DbIdMediaType requestType, StringBuilder sb) {
        int lastIndex = 0;
        Matcher matcher = TOKENIZER_PATTERN.matcher(searchCriteria);
        while (matcher.find()) {
            sb.append(searchCriteria, lastIndex, matcher.start());
            if ("upnp:class".equalsIgnoreCase(matcher.group("property"))) {
                SearchRequestHandler.acquireDatabaseType(sb, matcher.group("op"), matcher.group("val"), requestType);
            } else if (matcher.group("property").startsWith("upnp:") || matcher.group("property").startsWith("dc:")) {
                SearchRequestHandler.appendProperty(sb, matcher.group("property"), matcher.group("op"), matcher.group("val"), requestType);
            }
            sb.append("");
            lastIndex = matcher.end();
        }
        if (lastIndex < searchCriteria.length()) {
            sb.append(searchCriteria, lastIndex, searchCriteria.length());
        }
        if (requestType.equals((Object)DbIdMediaType.TYPE_FOLDER)) {
            sb.append(" AND child.parent_id = parent.id and child.object_type = 'RealFolder' and parent.object_type = 'RealFolder'");
        }
    }

    private static void appendProperty(StringBuilder sb, String property, String op, String val, DbIdMediaType requestType) {
        if ("=".equals(op)) {
            sb.append(String.format(" %s = '%s' ", SearchRequestHandler.getField(property, requestType), val));
        } else if ("contains".equals(op)) {
            sb.append(String.format("LOWER(%s) LIKE '%%%s%%'", SearchRequestHandler.getField(property, requestType), SearchRequestHandler.escapeH2dbSql(val).toLowerCase()));
        } else {
            throw new RuntimeException("unknown or unimplemented operator : " + op);
        }
        sb.append("");
    }

    private static String escapeH2dbSql(String val) {
        val = val.replaceAll("'", "''");
        val = val.replaceAll("\u2018", "''");
        return val;
    }

    private static String getField(String prop, DbIdMediaType requestType) {
        String property = prop.toLowerCase();
        if ("dc:title".equalsIgnoreCase(property)) {
            return SearchRequestHandler.getTitlePropertyMapping(requestType);
        }
        if (property.startsWith("upnp:artist")) {
            if (property.contains("albumartist")) {
                return " A.ALBUMARTIST ";
            }
            if (property.contains("composer")) {
                return " A.COMPOSER ";
            }
            if (property.contains("conductor")) {
                return " A.CONDUCTOR ";
            }
            return " A.ARTIST ";
        }
        if ("upnp:genre".equals(property)) {
            return " A.GENRE ";
        }
        if ("dc:creator".equals(property)) {
            return " A.ALBUMARTIST ";
        }
        if ("upnp:album".equals(property)) {
            return " A.ALBUM ";
        }
        if ("upnp:rating".equals(property)) {
            return " rating ";
        }
        if ("ums:likedalbum".equals(property)) {
            return " liked ";
        }
        throw new RuntimeException("unknown or unimplemented property: >" + property + "<");
    }

    private static String getTitlePropertyMapping(DbIdMediaType requestType) {
        switch (requestType) {
            case TYPE_AUDIO: {
                return " A.SONGNAME ";
            }
            case TYPE_ALBUM: {
                return " A.ALBUM ";
            }
            case TYPE_PERSON: {
                return " A.ARTIST ";
            }
            case TYPE_PERSON_COMPOSER: {
                return " A.COMPOSER ";
            }
            case TYPE_PERSON_ALBUMARTIST: {
                return " A.ALBUMARTIST ";
            }
            case TYPE_PERSON_CONDUCTOR: {
                return " A.CONDUCTOR ";
            }
            case TYPE_PLAYLIST: 
            case TYPE_VIDEO: 
            case TYPE_IMAGE: {
                return " F.FILENAME ";
            }
            case TYPE_FOLDER: {
                return " child.name ";
            }
        }
        throw new RuntimeException("Unknown type : " + String.valueOf((Object)requestType));
    }

    private static void acquireDatabaseType(StringBuilder sb, String op, String val, DbIdMediaType requestType) {
        switch (requestType) {
            case TYPE_PERSON: 
            case TYPE_PERSON_CONDUCTOR: 
            case TYPE_PERSON_COMPOSER: 
            case TYPE_PERSON_ALBUMARTIST: 
            case TYPE_ALBUM: 
            case TYPE_FOLDER: {
                sb.append(" 1=1 ");
                return;
            }
            case TYPE_AUDIO: 
            case TYPE_PLAYLIST: 
            case TYPE_VIDEO: 
            case TYPE_IMAGE: {
                if ("=".equals(op) || "derivedfrom".equalsIgnoreCase(op)) {
                    sb.append(String.format(" F.FORMAT_TYPE = %d ", SearchRequestHandler.getFileType(requestType)));
                }
                return;
            }
        }
        throw new RuntimeException("Unknown type : " + String.valueOf((Object)requestType));
    }

    private static int getFileType(DbIdMediaType mediaFolderType) {
        switch (mediaFolderType) {
            case TYPE_AUDIO: 
            case TYPE_PERSON: 
            case TYPE_PERSON_CONDUCTOR: 
            case TYPE_PERSON_COMPOSER: 
            case TYPE_PERSON_ALBUMARTIST: 
            case TYPE_ALBUM: {
                return 1;
            }
            case TYPE_VIDEO: {
                return 4;
            }
            case TYPE_IMAGE: {
                return 2;
            }
            case TYPE_PLAYLIST: {
                return 16;
            }
            case TYPE_FOLDER: {
                break;
            }
        }
        throw new RuntimeException("unknown or unimplemented mediafolder type : >" + String.valueOf((Object)mediaFolderType) + "<");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getLibraryResourceCountFromSQL(String query) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("SQL count : %s", query));
        }
        Connection connection = null;
        try {
            ResultSet resultSet;
            block18: {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) return 0;
                try {
                    int n;
                    Statement statement;
                    block19: {
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery(query);
                        try {
                            if (!resultSet.next()) break block18;
                            n = resultSet.getInt(1);
                            if (resultSet == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (resultSet == null) throw throwable;
                            try {
                                resultSet.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (statement == null) return n;
                    statement.close();
                    return n;
                }
                catch (SQLException e) {
                    LOGGER.trace("getLibraryResourceCountFromSQL", e);
                    return 0;
                }
            }
            if (resultSet == null) return 0;
            resultSet.close();
            return 0;
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StoreResource> getLibraryResourceFromSQL(Renderer renderer, String query, DbIdMediaType type) {
        ArrayList<StoreResource> result;
        block28: {
            result = new ArrayList<StoreResource>();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("SQL %s : %s", type.dbidPrefix, query));
            }
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) break block28;
                try (Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(query);){
                    HashSet<String> foundMbidAlbums = new HashSet<String>();
                    block21: while (resultSet.next()) {
                        String filenameField = SearchRequestHandler.extractDisplayName(resultSet, type);
                        switch (type) {
                            case TYPE_ALBUM: {
                                String mbid = resultSet.getString("MBID_RECORD");
                                if (StringUtils.isAllBlank(mbid)) {
                                    StoreResource sr = DbIdResourceLocator.getAlbumFromMediaLibrary(renderer, filenameField);
                                    if (sr == null) continue block21;
                                    result.add(sr);
                                    break;
                                }
                                if (foundMbidAlbums.contains(mbid)) continue block21;
                                MusicBrainzAlbumFolder folder = DbIdResourceLocator.getLibraryResourceMusicBrainzFolder(renderer, new DbIdTypeAndIdent(DbIdMediaType.TYPE_MUSICBRAINZ_RECORDID, mbid));
                                if (folder == null) {
                                    MusicBrainzAlbum album = new MusicBrainzAlbum(mbid, resultSet.getString("album"), resultSet.getString("artist"), Integer.toString(resultSet.getInt("media_year")), resultSet.getString("genre"));
                                    folder = DbIdLibrary.addLibraryResourceMusicBrainzAlbum(renderer, album);
                                }
                                result.add(folder);
                                foundMbidAlbums.add(mbid);
                                break;
                            }
                            case TYPE_PERSON: 
                            case TYPE_PERSON_CONDUCTOR: 
                            case TYPE_PERSON_COMPOSER: 
                            case TYPE_PERSON_ALBUMARTIST: {
                                DbIdTypeAndIdent ti = new DbIdTypeAndIdent(type, filenameField);
                                MusicBrainzPersonFolder personFolder = DbIdResourceLocator.getLibraryResourcePersonFolder(renderer, ti);
                                if (personFolder == null) {
                                    personFolder = DbIdLibrary.addLibraryResourcePerson(renderer, ti);
                                }
                                result.add(personFolder);
                                break;
                            }
                            case TYPE_PLAYLIST: {
                                StoreResource res;
                                String realFileName = resultSet.getString("FILENAME");
                                if (realFileName == null || (res = DbIdResourceLocator.getLibraryResourcePlaylist(renderer, realFileName)) == null) continue block21;
                                result.add(res);
                                break;
                            }
                            case TYPE_FOLDER: {
                                StoreResource res;
                                if (filenameField == null || (res = DbIdResourceLocator.getLibraryResourceFolder(renderer, filenameField)) == null) continue block21;
                                result.add(res);
                                break;
                            }
                            default: {
                                StoreResource res;
                                String realFileName = resultSet.getString("FILENAME");
                                if (realFileName == null || (res = DbIdResourceLocator.getLibraryResourceRealFile(renderer, realFileName)) == null) continue block21;
                                res.resolve();
                                result.add(res);
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.trace("getLibraryResourceFromSQL", e);
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return result;
    }

    private static String extractDisplayName(ResultSet resultSet, DbIdMediaType type) throws SQLException {
        switch (type) {
            case TYPE_AUDIO: 
            case TYPE_PLAYLIST: 
            case TYPE_VIDEO: 
            case TYPE_IMAGE: {
                return FilenameUtils.getBaseName(resultSet.getString("FILENAME"));
            }
            case TYPE_FOLDER: {
                return resultSet.getString("name");
            }
        }
        return resultSet.getString("FILENAME");
    }

    private static StringBuilder createResponse(String payload) {
        StringBuilder response = new StringBuilder();
        response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>").append(CRLF);
        response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>").append(CRLF);
        response.append(payload).append(CRLF);
        response.append("</s:Body>\r\n</s:Envelope>").append(CRLF);
        return response;
    }

    private static StringBuilder buildEnvelope(int foundNumberReturned, int totalMatches, long updateID, StringBuilder dlnaItems) {
        StringBuilder response = new StringBuilder();
        response.append("<u:SearchResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">");
        response.append(CRLF);
        response.append("<Result>");
        response.append("&lt;DIDL-Lite xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" xmlns:sec=\"http://www.sec.co.kr/\" xmlns:pv=\"http://www.pv.com/pvns/\"&gt;");
        response.append(dlnaItems.toString());
        response.append("&lt;/DIDL-Lite&gt;");
        response.append("</Result>");
        response.append(CRLF);
        response.append("<NumberReturned>").append(foundNumberReturned).append("</NumberReturned>");
        response.append(CRLF);
        response.append("<TotalMatches>").append(totalMatches).append("</TotalMatches>");
        response.append(CRLF);
        response.append("<UpdateID>");
        response.append(updateID);
        response.append("</UpdateID>");
        response.append(CRLF);
        response.append("</u:SearchResponse>");
        return response;
    }
}

