/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.mediaserver.MediaServerRequestType;

public class MediaServerRequest {
    public static final String PATH_SEPARATOR = "/";
    public static final String UMS = "ums";
    public static final String UMS_PATH = "ums/";
    public static final String BASE_PATH = "/ums/";
    public static final String MEDIA = "media";
    public static final String MEDIA_PATH = "media/";
    public static final String THUMBNAIL = "thumbnail";
    public static final String THUMBNAIL_PATH = "thumbnail/";
    public static final String SUBTITLES = "subtitles";
    public static final String SUBTITLES_PATH = "subtitles/";
    private final MediaServerRequestType requestType;
    private final String uuid;
    private final String resourceId;
    private final String optionalPath;

    public MediaServerRequest(String path) {
        int pos = path.indexOf(BASE_PATH);
        if (pos != -1) {
            path = path.substring(pos + BASE_PATH.length());
        } else if (path.startsWith(UMS_PATH)) {
            path = path.substring(UMS_PATH.length());
        } else if (path.startsWith(PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        String[] requestData = path.split(PATH_SEPARATOR, 4);
        if (requestData.length < 3) {
            this.uuid = null;
            this.requestType = MediaServerRequestType.BAD_REQUEST;
            this.resourceId = null;
            this.optionalPath = null;
        } else {
            this.requestType = switch (requestData[0]) {
                case MEDIA -> MediaServerRequestType.MEDIA;
                case THUMBNAIL -> MediaServerRequestType.THUMBNAIL;
                case SUBTITLES -> MediaServerRequestType.SUBTITLES;
                default -> MediaServerRequestType.BAD_REQUEST;
            };
            this.uuid = requestData[1];
            this.resourceId = URLDecoder.decode(requestData[2], StandardCharsets.UTF_8);
            this.optionalPath = requestData[3];
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public MediaServerRequestType getRequestType() {
        return this.requestType;
    }

    public boolean isBadRequest() {
        return this.requestType == MediaServerRequestType.BAD_REQUEST;
    }

    public boolean isMediaRequest() {
        return this.requestType == MediaServerRequestType.MEDIA;
    }

    public boolean isThumbnailRequest() {
        return this.requestType == MediaServerRequestType.THUMBNAIL;
    }

    public boolean isSubtitlesRequest() {
        return this.requestType == MediaServerRequestType.SUBTITLES;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getOptionalPath() {
        return this.optionalPath;
    }

    private static StringBuilder getMediaServerURL() {
        return new StringBuilder(MediaServer.getURL());
    }

    public static StringBuilder getServerMediaURL(String uuid, String id) {
        return MediaServerRequest.getMediaServerURL().append((CharSequence)MediaServerRequest.getMediaURL(uuid, id));
    }

    public static StringBuilder getServerSubtitlesURL(String uuid, String id) {
        return MediaServerRequest.getMediaServerURL().append((CharSequence)MediaServerRequest.getSubtitlesURL(uuid, id));
    }

    public static StringBuilder getServerThumbnailURL(String uuid, String id) {
        return MediaServerRequest.getMediaServerURL().append((CharSequence)MediaServerRequest.getThumbnailURL(uuid, id));
    }

    private static StringBuilder getBaseURL() {
        return new StringBuilder(BASE_PATH);
    }

    private static StringBuilder getBaseURL(String endpoint) {
        return MediaServerRequest.getBaseURL().append(endpoint);
    }

    private static StringBuilder getBaseURL(String endpoint, String uuid) {
        return MediaServerRequest.getBaseURL(endpoint).append(uuid).append(PATH_SEPARATOR);
    }

    private static StringBuilder getBaseURL(String endpoint, String uuid, String id) {
        return MediaServerRequest.getBaseURL(endpoint, uuid).append(id).append(PATH_SEPARATOR);
    }

    public static StringBuilder getMediaURL() {
        return MediaServerRequest.getBaseURL(MEDIA_PATH);
    }

    public static StringBuilder getMediaURL(String uuid) {
        return MediaServerRequest.getBaseURL(MEDIA_PATH, uuid);
    }

    private static StringBuilder getMediaURL(String uuid, String id) {
        return MediaServerRequest.getBaseURL(MEDIA_PATH, uuid, id);
    }

    private static StringBuilder getSubtitlesURL(String uuid, String id) {
        return MediaServerRequest.getBaseURL(SUBTITLES_PATH, uuid, id);
    }

    private static StringBuilder getThumbnailURL(String uuid, String id) {
        return MediaServerRequest.getBaseURL(THUMBNAIL_PATH, uuid, id);
    }
}

