/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.video.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaTableVideoMetadataLocalized;
import net.pms.media.video.metadata.ApiCountryArray;
import net.pms.media.video.metadata.ApiCredits;
import net.pms.media.video.metadata.ApiExternalIDs;
import net.pms.media.video.metadata.ApiImages;
import net.pms.media.video.metadata.ApiLanguageArray;
import net.pms.media.video.metadata.ApiNetworkArray;
import net.pms.media.video.metadata.ApiPersonCreditedArray;
import net.pms.media.video.metadata.ApiProductionCompanyArray;
import net.pms.media.video.metadata.ApiRatingSourceArray;
import net.pms.media.video.metadata.ApiSeason;
import net.pms.media.video.metadata.ApiSeasonArray;
import net.pms.media.video.metadata.ApiStringArray;
import net.pms.media.video.metadata.TvSeasonMetadata;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import net.pms.store.ThumbnailSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TvSeriesMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvSeriesMetadata.class);
    private static final Gson GSON = new Gson();
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private ApiStringArray actors;
    private String awards;
    private ApiStringArray countries;
    private ApiPersonCreditedArray createdBy;
    private ApiCredits credits;
    private ApiStringArray directors;
    private Integer endYear;
    private ApiExternalIDs externalIDs;
    private LocalDate firstAirDate;
    private ApiStringArray genres;
    private String homepage;
    private ApiImages images;
    private String imdbID;
    private Boolean inProduction;
    private ApiStringArray languages;
    private LocalDate lastAirDate;
    private ApiNetworkArray networks;
    private Double numberOfEpisodes;
    private Double numberOfSeasons;
    private String originalLanguage;
    private String originalTitle;
    private ApiStringArray originCountry;
    private String overview;
    private String poster;
    private ApiProductionCompanyArray productionCompanies;
    private ApiCountryArray productionCountries;
    private String rated;
    private Double rating;
    private ApiRatingSourceArray ratings;
    private LocalDate released;
    private ApiSeasonArray seasons;
    private String seriesType;
    private ApiLanguageArray spokenLanguages;
    private Integer startYear;
    private String status;
    private String tagline;
    private String title;
    private Long tmdbId;
    private Double totalSeasons;
    private String apiVersion;
    private String votes;
    private Long thumbnailId;
    private ThumbnailSource thumbnailSource = ThumbnailSource.UNKNOWN;
    private Long tvSeriesId;
    private Map<String, VideoMetadataLocalized> translations;

    public Long getTvSeriesId() {
        return this.tvSeriesId;
    }

    public void setTvSeriesId(Long value) {
        this.tvSeriesId = value;
    }

    public ApiStringArray getActors() {
        return this.actors;
    }

    public void setActors(ApiStringArray value) {
        this.actors = value;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String value) {
        this.apiVersion = value;
    }

    public String getAwards() {
        return this.awards;
    }

    public void setAwards(String value) {
        this.awards = value;
    }

    public ApiStringArray getCountries() {
        return this.countries;
    }

    public void setCountries(ApiStringArray value) {
        this.countries = value;
    }

    public ApiPersonCreditedArray getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(ApiPersonCreditedArray value) {
        this.createdBy = value;
    }

    public void setCreatedBy(String value) {
        try {
            this.createdBy = GSON.fromJson(value, ApiPersonCreditedArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing created by: {}", (Object)e.getMessage());
            this.createdBy = null;
        }
    }

    public ApiCredits getCredits() {
        return this.credits;
    }

    public void setCredits(ApiCredits value) {
        this.credits = value;
    }

    public void setCredits(String value) {
        try {
            this.credits = GSON.fromJson(value, ApiCredits.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing credits: {}", (Object)e.getMessage());
            this.credits = null;
        }
    }

    public ApiStringArray getDirectors() {
        return this.directors;
    }

    public void setDirectors(ApiStringArray value) {
        this.directors = value;
    }

    public Integer getEndYear() {
        return this.endYear;
    }

    public void setEndYear(Integer value) {
        this.endYear = value;
    }

    public ApiExternalIDs getExternalIDs() {
        return this.externalIDs;
    }

    public void setExternalIDs(ApiExternalIDs value) {
        this.externalIDs = value;
    }

    public void setExternalIDs(String value) {
        try {
            this.externalIDs = GSON.fromJson(value, ApiExternalIDs.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing ExternalIDs: {}", (Object)e.getMessage());
            this.externalIDs = null;
        }
    }

    public LocalDate getFirstAirDate() {
        return this.firstAirDate;
    }

    public void setFirstAirDate(LocalDate value) {
        this.firstAirDate = value;
    }

    public void setFirstAirDate(String value) {
        LocalDate localDate = null;
        if (value != null) {
            try {
                localDate = LocalDate.parse(value.length() > 10 ? value.substring(0, 10) : value);
            }
            catch (IllegalArgumentException | NullPointerException | DateTimeParseException e) {
                LOGGER.trace("String \"{}\" cannot converts to LocalDate", (Object)value);
            }
        }
        this.firstAirDate = localDate;
    }

    public ApiStringArray getGenres() {
        return this.genres;
    }

    public void setGenres(ApiStringArray value) {
        this.genres = value;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String value) {
        this.homepage = value;
    }

    public ApiImages getImages() {
        return this.images;
    }

    public void setImages(ApiImages value) {
        this.images = value;
    }

    public void setImages(String value) {
        try {
            this.images = GSON.fromJson(value, ApiImages.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing Images: {}", (Object)e.getMessage());
            this.images = null;
        }
    }

    public String getIMDbID() {
        return this.imdbID;
    }

    public void setIMDbID(String value) {
        this.imdbID = value;
    }

    public Boolean isInProduction() {
        return this.inProduction;
    }

    public void setInProduction(Boolean value) {
        this.inProduction = value;
    }

    public ApiStringArray getLanguages() {
        return this.languages;
    }

    public void setLanguages(ApiStringArray value) {
        this.languages = value;
    }

    public void setLanguages(String value) {
        try {
            this.languages = GSON.fromJson(value, ApiStringArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing languages: {}", (Object)e.getMessage());
            this.languages = null;
        }
    }

    public LocalDate getLastAirDate() {
        return this.lastAirDate;
    }

    public void setLastAirDate(LocalDate value) {
        this.lastAirDate = value;
    }

    public void setLastAirDate(String value) {
        LocalDate localDate = null;
        if (value != null) {
            try {
                localDate = LocalDate.parse(value.length() > 10 ? value.substring(0, 10) : value);
            }
            catch (IllegalArgumentException | NullPointerException | DateTimeParseException e) {
                LOGGER.trace("String \"{}\" cannot converts to LocalDate", (Object)value);
            }
        }
        this.lastAirDate = localDate;
    }

    public ApiNetworkArray getNetworks() {
        return this.networks;
    }

    public void setNetworks(ApiNetworkArray value) {
        this.networks = value;
    }

    public void setNetworks(String value) {
        try {
            this.networks = GSON.fromJson(value, ApiNetworkArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing networks: {}", (Object)e.getMessage());
            this.networks = null;
        }
    }

    public Double getNumberOfEpisodes() {
        return this.numberOfEpisodes;
    }

    public void setNumberOfEpisodes(Double value) {
        this.numberOfEpisodes = value;
    }

    public Double getNumberOfSeasons() {
        return this.numberOfSeasons;
    }

    public void setNumberOfSeasons(Double value) {
        this.numberOfSeasons = value;
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public void setOriginalLanguage(String value) {
        this.originalLanguage = value;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String value) {
        this.originalTitle = value;
    }

    public ApiStringArray getOriginCountry() {
        return this.originCountry;
    }

    public void setOriginCountry(ApiStringArray value) {
        this.originCountry = value;
    }

    public void setOriginCountry(String value) {
        try {
            this.originCountry = GSON.fromJson(value, ApiStringArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing origin country: {}", (Object)e.getMessage());
            this.originCountry = null;
        }
    }

    public String getOverview() {
        return this.overview;
    }

    public void setOverview(String value) {
        this.overview = value;
    }

    public String getPoster() {
        return this.poster;
    }

    public void setPoster(String value) {
        this.poster = value;
    }

    public ApiProductionCompanyArray getProductionCompanies() {
        return this.productionCompanies;
    }

    public void setProductionCompanies(ApiProductionCompanyArray value) {
        this.productionCompanies = value;
    }

    public void setProductionCompanies(String value) {
        try {
            this.productionCompanies = GSON.fromJson(value, ApiProductionCompanyArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing production companies: {}", (Object)e.getMessage());
            this.productionCompanies = null;
        }
    }

    public ApiCountryArray getProductionCountries() {
        return this.productionCountries;
    }

    public void setProductionCountries(ApiCountryArray value) {
        this.productionCountries = value;
    }

    public void setProductionCountries(String value) {
        try {
            this.productionCountries = GSON.fromJson(value, ApiCountryArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing production countries: {}", (Object)e.getMessage());
            this.productionCountries = null;
        }
    }

    public String getRated() {
        return this.rated;
    }

    public void setRated(String value) {
        this.rated = value;
    }

    public Double getRating() {
        return this.rating;
    }

    public void setRating(Double value) {
        this.rating = value;
    }

    public ApiRatingSourceArray getRatings() {
        return this.ratings;
    }

    public void setRatings(ApiRatingSourceArray value) {
        this.ratings = value;
    }

    public void setRatings(String value) {
        try {
            this.ratings = GSON.fromJson(value, ApiRatingSourceArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing ratings: {}", (Object)e.getMessage());
            this.ratings = null;
        }
    }

    public ApiSeasonArray getSeasons() {
        return this.seasons;
    }

    public void setSeasons(ApiSeasonArray value) {
        this.seasons = value;
    }

    public void setSeasons(String value) {
        try {
            this.seasons = GSON.fromJson(value, ApiSeasonArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing seasons: {}", (Object)e.getMessage());
            this.seasons = null;
        }
    }

    public String getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(String value) {
        this.seriesType = value;
    }

    public ApiLanguageArray getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public void setSpokenLanguages(ApiLanguageArray value) {
        this.spokenLanguages = value;
    }

    public void setSpokenLanguages(String value) {
        try {
            this.spokenLanguages = GSON.fromJson(value, ApiLanguageArray.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Error in parsing spoken languages: {}", (Object)e.getMessage());
            this.spokenLanguages = null;
        }
    }

    public Integer getStartYear() {
        return this.startYear;
    }

    public void setStartYear(Integer value) {
        this.startYear = value;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String value) {
        this.status = value;
    }

    public String getTagline() {
        return this.tagline;
    }

    public void setTagline(String value) {
        this.tagline = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public Long getTmdbId() {
        return this.tmdbId;
    }

    public void setTmdbId(Long value) {
        this.tmdbId = value;
    }

    public Double getTotalSeasons() {
        return this.totalSeasons;
    }

    public void setTotalSeasons(Double value) {
        this.totalSeasons = value;
    }

    public Long getThumbnailId() {
        return this.thumbnailId;
    }

    public void setThumbnailId(Long value) {
        this.thumbnailId = value;
    }

    public ThumbnailSource getThumbnailSource() {
        return this.thumbnailSource;
    }

    public void setThumbnailSource(ThumbnailSource value) {
        this.thumbnailSource = value;
    }

    public void setThumbnailSource(String value) {
        this.thumbnailSource = ThumbnailSource.valueOfName(value);
    }

    public String getVotes() {
        return this.votes;
    }

    public void setVotes(String value) {
        this.votes = value;
    }

    public void setTranslations(Map<String, VideoMetadataLocalized> value) {
        this.translations = value;
    }

    public void ensureHavingTranslation(String lang) {
        VideoMetadataLocalized loc;
        if ((lang = CONFIGURATION.getTranslationLanguage(lang)) != null && !"en-us".equals(lang) && !this.hasTranslation(lang) && this.tvSeriesId != null && this.tvSeriesId > -1L && (loc = MediaTableVideoMetadataLocalized.getVideoMetadataLocalized(this.tvSeriesId, true, lang, this.imdbID, "tv", this.tmdbId, null, null)) != null) {
            this.addTranslation(lang, loc);
        }
    }

    private void addTranslation(String lang, VideoMetadataLocalized value) {
        if (lang == null || value == null) {
            return;
        }
        if (this.translations == null) {
            this.translations = new HashMap<String, VideoMetadataLocalized>();
        }
        this.translations.put(lang.toLowerCase(), value);
    }

    private boolean hasTranslation(String lang) {
        return this.translations != null && this.translations.containsKey(lang.toLowerCase());
    }

    private VideoMetadataLocalized getTranslation(String lang) {
        if ((lang = CONFIGURATION.getTranslationLanguage(lang)) != null && this.hasTranslation(lang)) {
            return this.translations.get(lang);
        }
        return null;
    }

    public String getHomepage(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getHomepage())) {
            return translation.getHomepage();
        }
        return this.homepage;
    }

    public String getOverview(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getOverview())) {
            return translation.getOverview();
        }
        return this.overview;
    }

    public String getPoster(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getPoster())) {
            return translation.getPoster();
        }
        return this.poster;
    }

    public String getTagline(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getTagline())) {
            return translation.getTagline();
        }
        return this.tagline;
    }

    public String getTitle(String lang) {
        VideoMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getTitle())) {
            return translation.getTitle();
        }
        return this.title;
    }

    public TvSeasonMetadata getSeasonMetadata(Integer seasonNumber) {
        if (this.seasons != null && seasonNumber != null) {
            for (ApiSeason season : this.seasons) {
                if (season.getSeasonNumber() != seasonNumber.intValue()) continue;
                return new TvSeasonMetadata(this.tvSeriesId, this.tmdbId, season);
            }
        }
        return null;
    }

    public void update(TvSeriesMetadata tvSeriesMetadata) {
        this.setActors(tvSeriesMetadata.getActors());
        this.setApiVersion(tvSeriesMetadata.getApiVersion());
        this.setAwards(tvSeriesMetadata.getAwards());
        this.setCountries(tvSeriesMetadata.getCountries());
        this.setCreatedBy(tvSeriesMetadata.getCreatedBy());
        this.setCredits(tvSeriesMetadata.getCredits());
        this.setDirectors(tvSeriesMetadata.getDirectors());
        this.setEndYear(tvSeriesMetadata.getEndYear());
        this.setExternalIDs(tvSeriesMetadata.getExternalIDs());
        this.setFirstAirDate(tvSeriesMetadata.getFirstAirDate());
        this.setGenres(tvSeriesMetadata.getGenres());
        this.setHomepage(tvSeriesMetadata.getHomepage());
        this.setIMDbID(tvSeriesMetadata.getIMDbID());
        this.setImages(tvSeriesMetadata.getImages());
        this.setLanguages(tvSeriesMetadata.getLanguages());
        this.setLastAirDate(tvSeriesMetadata.getLastAirDate());
        this.setNetworks(tvSeriesMetadata.getNetworks());
        this.setNumberOfEpisodes(tvSeriesMetadata.getNumberOfEpisodes());
        this.setNumberOfSeasons(tvSeriesMetadata.getNumberOfSeasons());
        this.setOriginCountry(tvSeriesMetadata.getOriginCountry());
        this.setOriginalLanguage(tvSeriesMetadata.getOriginalLanguage());
        this.setOriginalTitle(tvSeriesMetadata.getOriginalTitle());
        this.setOverview(tvSeriesMetadata.getOverview());
        this.setPoster(tvSeriesMetadata.getPoster());
        this.setProductionCompanies(tvSeriesMetadata.getProductionCompanies());
        this.setProductionCountries(tvSeriesMetadata.getProductionCountries());
        this.setRated(tvSeriesMetadata.getRated());
        this.setRating(tvSeriesMetadata.getRating());
        this.setRatings(tvSeriesMetadata.getRatings());
        this.setSeasons(tvSeriesMetadata.getSeasons());
        this.setSeriesType(tvSeriesMetadata.getSeriesType());
        this.setSpokenLanguages(tvSeriesMetadata.getSpokenLanguages());
        this.setStartYear(tvSeriesMetadata.getStartYear());
        this.setStatus(tvSeriesMetadata.getStatus());
        this.setTagline(tvSeriesMetadata.getTagline());
        this.setThumbnailId(tvSeriesMetadata.getThumbnailId());
        this.setThumbnailSource(tvSeriesMetadata.getThumbnailSource());
        this.setTitle(tvSeriesMetadata.getTitle());
        this.setTmdbId(tvSeriesMetadata.getTmdbId());
        this.setTotalSeasons(tvSeriesMetadata.getTotalSeasons());
        this.setTranslations(null);
        this.setVotes(tvSeriesMetadata.getVotes());
    }

    public JsonObject asJsonObject(String lang) {
        lang = CONFIGURATION.getTranslationLanguage(lang);
        this.ensureHavingTranslation(lang);
        JsonObject result = new JsonObject();
        result.add("actors", GSON.toJsonTree(this.actors));
        result.addProperty("awards", this.awards);
        result.add("countries", GSON.toJsonTree(this.countries));
        result.add("directors", GSON.toJsonTree(this.directors));
        result.addProperty("endYear", this.endYear);
        result.add("externalIDs", GSON.toJsonTree(this.externalIDs));
        if (this.firstAirDate != null) {
            result.addProperty("firstAirDate", this.firstAirDate.toString());
        }
        result.add("genres", GSON.toJsonTree(this.genres));
        result.addProperty("homepage", this.getHomepage(lang));
        result.add("images", GSON.toJsonTree(this.images));
        result.addProperty("imdbID", this.imdbID);
        result.addProperty("inProduction", this.inProduction);
        result.add("languages", GSON.toJsonTree(this.languages));
        if (this.lastAirDate != null) {
            result.addProperty("lastAirDate", this.lastAirDate.toString());
        }
        result.addProperty("mediaType", "tv");
        result.addProperty("numberOfEpisodes", this.numberOfEpisodes);
        result.addProperty("numberOfSeasons", this.numberOfSeasons);
        result.add("originCountry", GSON.toJsonTree(this.originCountry));
        if (this.originalTitle != null && !this.originalTitle.equals(this.getTitle(lang))) {
            result.addProperty("originalLanguage", this.originalLanguage);
            result.addProperty("originalTitle", this.originalTitle);
        }
        result.addProperty("overview", this.getOverview(lang));
        result.addProperty("poster", this.getPoster(lang));
        result.addProperty("rated", this.rated);
        result.addProperty("rating", this.rating);
        result.add("ratings", GSON.toJsonTree(this.ratings));
        if (this.released != null) {
            result.addProperty("released", this.released.toString());
        }
        result.add("seasons", GSON.toJsonTree(this.seasons));
        result.addProperty("seriesType", this.seriesType);
        result.add("spokenLanguages", GSON.toJsonTree(this.spokenLanguages));
        result.addProperty("startYear", this.startYear);
        result.addProperty("status", this.status);
        result.addProperty("tagline", this.getTagline(lang));
        result.addProperty("tmdbID", this.tmdbId);
        result.addProperty("title", this.getTitle(lang));
        result.addProperty("totalSeasons", this.totalSeasons);
        result.addProperty("votes", this.votes);
        return result;
    }
}

