/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.video;

import com.google.gson.JsonObject;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.media.MediaLang;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaVideo
extends MediaLang
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaVideo.class);
    private Integer streamOrder;
    private Long optionalId;
    private boolean defaultFlag;
    private boolean forcedFlag;
    private int width;
    private int height;
    private Double durationSec;
    private int bitRate;
    private Double frameRate;
    private String frameRateModeOriginal;
    private String frameRateMode;
    private String codec;
    private String formatProfile = null;
    private String formatLevel = null;
    private String formatTier = null;
    private String frameRateModeRaw;
    private final ReentrantReadWriteLock referenceFrameCountLock = new ReentrantReadWriteLock();
    private byte referenceFrameCount = (byte)-1;
    private int bitDepth = 8;
    private String matrixCoefficients;
    private Double pixelAspectRatio;
    private String multiViewLayout;
    private ScanType scanType;
    private ScanOrder scanOrder;
    private String displayAspectRatio;
    private String originalDisplayAspectRatio;
    private String title;
    private String muxingMode;
    private Map<String, String> extras;
    private boolean encrypted;
    private String videoHDRFormat;
    private String videoHDRFormatCompatibility;

    public Integer getStreamOrder() {
        return this.streamOrder;
    }

    public void setStreamOrder(Integer streamIndex) {
        this.streamOrder = streamIndex;
    }

    public Long getOptionalId() {
        return this.optionalId;
    }

    public void setOptionalId(Long optionalId) {
        this.optionalId = optionalId;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public void setDefault(boolean defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    public boolean isForced() {
        return this.forcedFlag;
    }

    public void setForced(boolean forcedFlag) {
        this.forcedFlag = forcedFlag;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getResolution() {
        if (this.width > 0 && this.height > 0) {
            return this.width + "x" + this.height;
        }
        return null;
    }

    public void setDuration(Double d) {
        this.durationSec = d;
    }

    public Double getDuration() {
        return this.durationSec;
    }

    public double getDurationInSeconds() {
        return Optional.ofNullable(this.durationSec).orElse(0.0);
    }

    public String getDurationString() {
        return this.durationSec != null ? StringUtil.formatDLNADuration(this.durationSec) : null;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec != null ? codec.toLowerCase(Locale.ROOT) : null;
    }

    public String getMatrixCoefficients() {
        return this.matrixCoefficients;
    }

    public void setMatrixCoefficients(String matrixCoefficients) {
        this.matrixCoefficients = matrixCoefficients;
    }

    public String getMultiViewLayout() {
        return this.multiViewLayout;
    }

    public void setMultiViewLayout(String stereoscopy) {
        this.multiViewLayout = stereoscopy;
    }

    public Double getPixelAspectRatio() {
        return this.pixelAspectRatio;
    }

    public void setPixelAspectRatio(Double pixelAspectRatio) {
        this.pixelAspectRatio = pixelAspectRatio;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(int value) {
        this.bitDepth = value;
    }

    @Nullable
    public ScanType getScanType() {
        return this.scanType;
    }

    public void setScanType(@Nullable ScanType scanType) {
        this.scanType = scanType;
    }

    public void setScanType(@Nullable String scanType) {
        this.scanType = ScanType.typeOf(scanType);
    }

    @Nullable
    public ScanOrder getScanOrder() {
        return this.scanOrder;
    }

    public void setScanOrder(@Nullable ScanOrder scanOrder) {
        this.scanOrder = scanOrder;
    }

    public void setScanOrder(@Nullable String scanOrder) {
        this.scanOrder = ScanOrder.typeOf(scanOrder);
    }

    public String getDisplayAspectRatio() {
        return this.displayAspectRatio;
    }

    public void setDisplayAspectRatio(String aspectRatio) {
        this.displayAspectRatio = MediaVideo.getFormattedAspectRatio(aspectRatio);
    }

    public String getOriginalDisplayAspectRatio() {
        return this.originalDisplayAspectRatio;
    }

    public void setOriginalDisplayAspectRatio(String aspectRatio) {
        this.originalDisplayAspectRatio = MediaVideo.getFormattedAspectRatio(aspectRatio);
    }

    public Double getFrameRate() {
        return this.frameRate;
    }

    public String getFrameRateDLNA() {
        int framerateDLNA = (int)Math.round(this.frameRate);
        Object framerateDLNAString = String.valueOf(framerateDLNA);
        framerateDLNAString = this.scanType != null && this.scanType == ScanType.INTERLACED ? (String)framerateDLNAString + "i" : (String)framerateDLNAString + "p";
        return framerateDLNAString;
    }

    public void setFrameRate(Double frameRate) {
        this.frameRate = frameRate;
    }

    public String getFrameRateModeOriginal() {
        return this.frameRateModeOriginal;
    }

    public void setFrameRateModeOriginal(String frameRateModeOriginal) {
        this.frameRateModeOriginal = frameRateModeOriginal;
    }

    public String getFrameRateMode() {
        return this.frameRateMode;
    }

    public void setFrameRateMode(String frameRateMode) {
        this.frameRateMode = frameRateMode;
    }

    public String getFrameRateModeRaw() {
        return this.frameRateModeRaw;
    }

    public void setFrameRateModeRaw(String frameRateModeRaw) {
        this.frameRateModeRaw = frameRateModeRaw;
    }

    public void setReferenceFrameCount(byte referenceFrameCount) {
        if (referenceFrameCount < -1) {
            throw new IllegalArgumentException("referenceFrameCount must be >= -1.");
        }
        this.referenceFrameCountLock.writeLock().lock();
        try {
            this.referenceFrameCount = referenceFrameCount;
        }
        finally {
            this.referenceFrameCountLock.writeLock().unlock();
        }
    }

    public byte getReferenceFrameCount() {
        this.referenceFrameCountLock.readLock().lock();
        try {
            byte by = this.referenceFrameCount;
            return by;
        }
        finally {
            this.referenceFrameCountLock.readLock().unlock();
        }
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public String getMuxingMode() {
        return this.muxingMode;
    }

    public void setMuxingMode(String muxingMode) {
        this.muxingMode = muxingMode;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(int bitRate) {
        this.bitRate = bitRate;
    }

    public String getHDRFormat() {
        return this.videoHDRFormat;
    }

    public void setHDRFormat(String value) {
        this.videoHDRFormat = value;
    }

    public String getHDRFormatCompatibility() {
        return this.videoHDRFormatCompatibility;
    }

    public void setHDRFormatCompatibility(String value) {
        this.videoHDRFormatCompatibility = value;
    }

    public String getFormatProfile() {
        return this.formatProfile;
    }

    public void setFormatProfile(String formatProfile) {
        this.formatProfile = formatProfile;
    }

    public String getFormatLevel() {
        return this.formatLevel;
    }

    public double getFormatLevelAsDouble(double def) {
        if (this.formatLevel == null) {
            return def;
        }
        try {
            return Double.parseDouble(this.formatLevel);
        }
        catch (NumberFormatException e) {
            LOGGER.trace("Could not convert {} to double: {}", (Object)this.formatLevel, (Object)e.getMessage());
            return def;
        }
    }

    public void setFormatLevel(String formatLevel) {
        this.formatLevel = formatLevel;
    }

    public String getFormatTier() {
        return this.formatTier;
    }

    public void setFormatTier(String formatTier) {
        this.formatTier = formatTier;
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public void putExtra(String key, String value) {
        if (this.extras == null) {
            this.extras = new HashMap<String, String>();
        }
        this.extras.put(key, value);
    }

    public boolean isH264() {
        return this.codec != null && this.codec.startsWith("h264");
    }

    public boolean isH265() {
        return this.codec != null && this.codec.startsWith("h265");
    }

    public boolean isMpeg2() {
        return this.codec != null && this.codec.startsWith("mpeg2");
    }

    public boolean isHDVideo() {
        return this.width > 864 || this.height > 576;
    }

    public boolean isMod4() {
        return this.height % 4 == 0 && this.width % 4 == 0;
    }

    public String getHDRFormatCompatibilityForRenderer() {
        if (StringUtils.isBlank(this.videoHDRFormatCompatibility)) {
            return null;
        }
        String hdrFormatCompatibilityInRendererFormat = null;
        if (StringUtils.isNotBlank(this.videoHDRFormatCompatibility)) {
            if (this.videoHDRFormatCompatibility.startsWith("Dolby Vision")) {
                hdrFormatCompatibilityInRendererFormat = "dolbyvision";
            } else if (this.videoHDRFormatCompatibility.startsWith("HDR10") && !this.videoHDRFormatCompatibility.startsWith("HDR10+") || this.videoHDRFormatCompatibility.endsWith("HDR10")) {
                hdrFormatCompatibilityInRendererFormat = "hdr10";
            } else if (this.videoHDRFormatCompatibility.startsWith("HDR10+")) {
                hdrFormatCompatibilityInRendererFormat = "hdr10+";
            } else if (this.videoHDRFormatCompatibility.startsWith("HLG")) {
                hdrFormatCompatibilityInRendererFormat = "hlg";
            }
        }
        return hdrFormatCompatibilityInRendererFormat;
    }

    public String getHDRFormatForRenderer() {
        if (StringUtils.isBlank(this.videoHDRFormat)) {
            return null;
        }
        String hdrFormatInRendererFormat = null;
        if (StringUtils.isNotBlank(this.videoHDRFormat)) {
            if (this.videoHDRFormat.startsWith("Dolby Vision")) {
                hdrFormatInRendererFormat = "dolbyvision";
            } else if (this.videoHDRFormat.startsWith("HDR10+")) {
                hdrFormatInRendererFormat = "hdr10+";
            } else if (this.videoHDRFormat.startsWith("HDR10")) {
                hdrFormatInRendererFormat = "hdr10";
            } else if (this.videoHDRFormat.startsWith("HLG")) {
                hdrFormatInRendererFormat = "hlg";
            }
        }
        return hdrFormatInRendererFormat;
    }

    public boolean isDisplayAspectRatioFromCodec() {
        return this.originalDisplayAspectRatio == null || this.displayAspectRatio == null || this.displayAspectRatio.equals(this.originalDisplayAspectRatio);
    }

    public boolean is3d() {
        return StringUtils.isNotBlank(this.multiViewLayout);
    }

    public boolean is3dFullSbsOrOu() {
        if (!this.is3d()) {
            return false;
        }
        return switch (this.multiViewLayout.toLowerCase()) {
            case "overunderrt", "oulf", "ourf", "sbslf", "sbsrf", "top-bottom (left eye first)", "top-bottom (right eye first)", "side by side (left eye first)", "side by side (right eye first)" -> true;
            default -> false;
        };
    }

    public boolean multiViewIsAnaglyph() {
        if (!this.is3d()) {
            return false;
        }
        return switch (this.multiViewLayout.toLowerCase()) {
            case "overunderrt", "oulf", "ourf", "sbslf", "sbsrf", "top-bottom (left eye first)", "top-bottom (right eye first)", "side by side (left eye first)", "side by side (right eye first)", "half top-bottom (left eye first)", "half side by side (left eye first)" -> false;
            default -> true;
        };
    }

    public Mode3D get3DLayout() {
        if (!this.is3d()) {
            return null;
        }
        switch (this.multiViewLayout.toLowerCase()) {
            case "overunderrt": 
            case "oulf": 
            case "top-bottom (left eye first)": {
                return Mode3D.ABL;
            }
            case "ourf": 
            case "top-bottom (right eye first)": {
                return Mode3D.ABR;
            }
            case "sbslf": 
            case "side by side (left eye first)": {
                return Mode3D.SBSL;
            }
            case "sbsrf": 
            case "side by side (right eye first)": {
                return Mode3D.SBSR;
            }
            case "half top-bottom (left eye first)": {
                return Mode3D.AB2L;
            }
            case "half side by side (left eye first)": {
                return Mode3D.SBS2L;
            }
            case "arcg": {
                return Mode3D.ARCG;
            }
            case "arch": {
                return Mode3D.ARCH;
            }
            case "arcc": {
                return Mode3D.ARCC;
            }
            case "arcd": {
                return Mode3D.ARCD;
            }
            case "agmg": {
                return Mode3D.AGMG;
            }
            case "agmh": {
                return Mode3D.AGMH;
            }
            case "agmc": {
                return Mode3D.AGMC;
            }
            case "agmd": {
                return Mode3D.AGMD;
            }
            case "aybg": {
                return Mode3D.AYBG;
            }
            case "aybh": {
                return Mode3D.AYBH;
            }
            case "aybc": {
                return Mode3D.AYBC;
            }
            case "aybd": {
                return Mode3D.AYBD;
            }
        }
        return null;
    }

    public JsonObject toJson() {
        ScanOrder scanOrderTemp;
        ScanType scanTypeTemp;
        JsonObject result = new JsonObject();
        result.addProperty("id", this.getId());
        result.addProperty("default", this.isDefault());
        result.addProperty("forced", this.isForced());
        result.addProperty("codec", this.getCodec());
        result.addProperty("stream", this.getStreamOrder());
        result.addProperty("bitDepth", this.getBitDepth());
        result.addProperty("resolution", this.getWidth() + "x" + this.getHeight());
        if (StringUtils.isNotBlank(this.getTitle())) {
            result.addProperty("title", this.getTitle());
        }
        if (StringUtils.isNotBlank(this.getLang()) && !"und".equals(this.getLang())) {
            result.addProperty("lang", this.getLang());
        }
        if (StringUtils.isNotBlank(this.getFormatProfile())) {
            result.addProperty("formatProfile", this.getFormatProfile());
        }
        if (StringUtils.isNotBlank(this.getFormatLevel())) {
            result.addProperty("formatLevel", this.getFormatLevel());
        }
        if (StringUtils.isNotBlank(this.getFormatTier())) {
            result.addProperty("formatTier", this.getFormatTier());
        }
        if (this.getDuration() != null) {
            result.addProperty("duration", this.getDurationString());
        }
        if (this.getDisplayAspectRatio() != null) {
            result.addProperty("displayaspectratio", this.getDisplayAspectRatio());
        }
        if (this.getPixelAspectRatio() != null && this.getPixelAspectRatio() != 1.0) {
            result.addProperty("pixelaspectratio", this.getPixelAspectRatio());
        }
        if ((scanTypeTemp = this.getScanType()) != null) {
            result.addProperty("scantype", scanTypeTemp.toString());
        }
        if ((scanOrderTemp = this.getScanOrder()) != null) {
            result.addProperty("scanOrder", scanOrderTemp.toString());
        }
        if (this.getFrameRate() != null) {
            result.addProperty("framerate", this.getFrameRate());
        }
        if (StringUtils.isNotBlank(this.getFrameRateMode())) {
            result.addProperty("framerateMode", this.getFrameRateMode());
        }
        if (StringUtils.isNotBlank(this.getFrameRateModeRaw())) {
            result.addProperty("framerateModeRaw", this.getFrameRateModeRaw());
        }
        if (StringUtils.isNotBlank(this.getMuxingMode())) {
            result.addProperty("muxingMode", this.getMuxingMode());
        }
        if (StringUtils.isNotBlank(this.getMatrixCoefficients())) {
            result.addProperty("matrixCoefficients", this.getMatrixCoefficients());
        }
        if (this.getReferenceFrameCount() > -1) {
            result.addProperty("referenceFrameCount", this.getReferenceFrameCount());
        }
        if (StringUtils.isNotBlank(this.getHDRFormat())) {
            result.addProperty("hdrFormat", this.getHDRFormat());
        }
        if (StringUtils.isNotBlank(this.getHDRFormatForRenderer())) {
            result.addProperty("hdrFormatRenderer", this.getHDRFormatForRenderer());
        }
        if (StringUtils.isNotBlank(this.getHDRFormatCompatibility())) {
            result.addProperty("hdrFormatCompatibility", this.getHDRFormatCompatibility());
        }
        if (StringUtils.isNotBlank(this.getHDRFormatCompatibilityForRenderer())) {
            result.addProperty("hdrFormatCompatibilityRenderer", this.getHDRFormatCompatibilityForRenderer());
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Video Id: ").append(this.getId());
        if (this.isDefault()) {
            result.append(", Default");
        }
        if (this.isForced()) {
            result.append(", Forced");
        }
        if (StringUtils.isNotBlank(this.getLang()) && !"und".equals(this.getLang())) {
            result.append(", Language Code: ").append(this.getLang());
        }
        if (StringUtils.isNotBlank(this.getTitle())) {
            result.append(", Title: ").append(this.getTitle());
        }
        result.append(", Codec: ").append(this.getCodec());
        if (StringUtils.isNotBlank(this.getFormatProfile())) {
            result.append(", Format Profile: ").append(this.getFormatProfile());
        }
        if (StringUtils.isNotBlank(this.getFormatLevel())) {
            result.append(", Format Level: ").append(this.getFormatLevel());
        }
        if (StringUtils.isNotBlank(this.getFormatTier())) {
            result.append(", Format Tier: ").append(this.getFormatTier());
        }
        if (this.getStreamOrder() != null) {
            result.append(", Stream Order: ").append(this.getStreamOrder());
        }
        if (this.durationSec != null) {
            result.append(", Duration: ").append(this.getDurationString());
        }
        result.append(", Resolution: ").append(this.getWidth()).append(" x ").append(this.getHeight());
        if (this.displayAspectRatio != null) {
            result.append(", Display Aspect Ratio: ").append(this.getDisplayAspectRatio());
        }
        if (this.pixelAspectRatio != null && this.pixelAspectRatio != 1.0) {
            result.append(", Pixel Aspect Ratio: ").append(this.getPixelAspectRatio());
        }
        if (this.scanType != null) {
            result.append(", Scan Type: ").append((Object)this.getScanType());
        }
        if (this.scanOrder != null) {
            result.append(", Scan Order: ").append((Object)this.getScanOrder());
        }
        if (this.frameRate != null) {
            result.append(", Frame Rate: ").append(this.getFrameRate());
        }
        if (StringUtils.isNotBlank(this.getFrameRateMode())) {
            result.append(", Frame Rate Mode: ");
            result.append(this.getFrameRateMode());
            if (StringUtils.isNotBlank(this.getFrameRateModeRaw())) {
                result.append(" (").append(this.getFrameRateModeRaw()).append(")");
            }
        } else if (StringUtils.isNotBlank(this.getFrameRateModeRaw())) {
            result.append(", Frame Rate Mode Raw: ");
            result.append(this.getFrameRateModeRaw());
        }
        if (StringUtils.isNotBlank(this.getMuxingMode())) {
            result.append(", Muxing Mode: ").append(this.getMuxingMode());
        }
        if (StringUtils.isNotBlank(this.getMatrixCoefficients())) {
            result.append(", Matrix Coefficients: ").append(this.getMatrixCoefficients());
        }
        if (this.getReferenceFrameCount() > -1) {
            result.append(", Reference Frame Count: ").append(this.getReferenceFrameCount());
        }
        if (this.getBitDepth() != 8) {
            result.append(", Bit Depth: ").append(this.getBitDepth());
        }
        if (StringUtils.isNotBlank(this.getHDRFormat())) {
            result.append(", HDR Format: ").append(this.getHDRFormat());
        }
        if (StringUtils.isNotBlank(this.getHDRFormatForRenderer())) {
            result.append(" (").append(this.getHDRFormatForRenderer()).append(")");
        }
        if (StringUtils.isNotBlank(this.getHDRFormatCompatibility())) {
            result.append(", HDR Format Compatibility: ").append(this.getHDRFormatCompatibility());
        }
        if (StringUtils.isNotBlank(this.getHDRFormatCompatibilityForRenderer())) {
            result.append(" (").append(this.getHDRFormatCompatibilityForRenderer()).append(")");
        }
        return result.toString();
    }

    public MediaVideo clone() throws CloneNotSupportedException {
        return (MediaVideo)super.clone();
    }

    private static String getFormattedAspectRatio(String aspect) {
        if (StringUtils.isBlank(aspect)) {
            return null;
        }
        if (aspect.contains(":")) {
            return aspect;
        }
        double exactAspectRatio = Double.parseDouble(aspect);
        if (exactAspectRatio >= 11.9 && exactAspectRatio <= 12.1) {
            return "12.00:1";
        }
        if (exactAspectRatio >= 3.9 && exactAspectRatio <= 4.1) {
            return "4.00:1";
        }
        if (exactAspectRatio >= 2.75 && exactAspectRatio <= 2.77) {
            return "2.76:1";
        }
        if (exactAspectRatio >= 2.65 && exactAspectRatio <= 2.67) {
            return "24:9";
        }
        if (exactAspectRatio >= 2.58 && exactAspectRatio <= 2.6) {
            return "2.59:1";
        }
        if (exactAspectRatio >= 2.54 && exactAspectRatio <= 2.56) {
            return "2.55:1";
        }
        if (exactAspectRatio >= 2.38 && exactAspectRatio <= 2.41) {
            return "2.39:1";
        }
        if (exactAspectRatio > 2.36 && exactAspectRatio < 2.38) {
            return "2.37:1";
        }
        if (exactAspectRatio >= 2.34 && exactAspectRatio <= 2.36) {
            return "2.35:1";
        }
        if (exactAspectRatio >= 2.33 && exactAspectRatio < 2.34) {
            return "21:9";
        }
        if (exactAspectRatio > 2.1 && exactAspectRatio < 2.3) {
            return "11:5";
        }
        if (exactAspectRatio > 1.9 && exactAspectRatio < 2.1) {
            return "2.00:1";
        }
        if (exactAspectRatio > 1.87 && exactAspectRatio <= 1.9) {
            return "1.896:1";
        }
        if (exactAspectRatio >= 1.83 && exactAspectRatio <= 1.87) {
            return "1.85:1";
        }
        if (exactAspectRatio >= 1.7 && exactAspectRatio <= 1.8) {
            return "16:9";
        }
        if (exactAspectRatio >= 1.65 && exactAspectRatio <= 1.67) {
            return "15:9";
        }
        if (exactAspectRatio >= 1.59 && exactAspectRatio <= 1.61) {
            return "16:10";
        }
        if (exactAspectRatio >= 1.54 && exactAspectRatio <= 1.56) {
            return "14:9";
        }
        if (exactAspectRatio >= 1.49 && exactAspectRatio <= 1.51) {
            return "3:2";
        }
        if (exactAspectRatio > 1.42 && exactAspectRatio < 1.44) {
            return "1.43:1";
        }
        if (exactAspectRatio > 1.372 && exactAspectRatio < 1.4) {
            return "11:8";
        }
        if (exactAspectRatio > 1.35 && exactAspectRatio <= 1.372) {
            return "1.37:1";
        }
        if (exactAspectRatio >= 1.3 && exactAspectRatio <= 1.35) {
            return "4:3";
        }
        if (exactAspectRatio > 1.2 && exactAspectRatio < 1.3) {
            return "5:4";
        }
        if (exactAspectRatio >= 1.18 && exactAspectRatio <= 1.195) {
            return "19:16";
        }
        if (exactAspectRatio > 0.99 && exactAspectRatio < 1.1) {
            return "1:1";
        }
        if (exactAspectRatio > 0.7 && exactAspectRatio < 0.9) {
            return "4:5";
        }
        if (exactAspectRatio > 0.6 && exactAspectRatio < 0.7) {
            return "2:3";
        }
        if (exactAspectRatio > 0.5 && exactAspectRatio < 0.6) {
            return "9:16";
        }
        return aspect;
    }

    public static enum ScanType {
        INTERLACED,
        MIXED,
        PROGRESSIVE;


        public String toString() {
            return switch (this) {
                case INTERLACED -> "Interlaced";
                case MIXED -> "Mixed";
                case PROGRESSIVE -> "Progressive";
                default -> this.name();
            };
        }

        public static ScanType typeOf(String scanType) {
            if (StringUtils.isBlank(scanType)) {
                return null;
            }
            switch (scanType = scanType.trim().toLowerCase(Locale.ROOT)) {
                case "interlaced": {
                    return INTERLACED;
                }
                case "mixed": {
                    return MIXED;
                }
                case "progressive": {
                    return PROGRESSIVE;
                }
            }
            LOGGER.debug("Warning: Unrecognized ScanType \"{}\"", (Object)scanType);
            return null;
        }
    }

    public static enum ScanOrder {
        BFF,
        BFO,
        PULLDOWN,
        PULLDOWN_2_2_2_2_2_2_2_2_2_2_2_3,
        PULLDOWN_2_3,
        TFF,
        TFO;


        public String toString() {
            return switch (this) {
                case BFF -> "Bottom Field First";
                case BFO -> "Bottom Field Only";
                case PULLDOWN -> "Pulldown";
                case PULLDOWN_2_2_2_2_2_2_2_2_2_2_2_3 -> "2:2:2:2:2:2:2:2:2:2:2:3 Pulldown";
                case PULLDOWN_2_3 -> "2:3 Pulldown";
                case TFF -> "Top Field First";
                case TFO -> "Top Field Only";
                default -> this.name();
            };
        }

        public static ScanOrder typeOf(String scanOrder) {
            if (StringUtils.isBlank(scanOrder)) {
                return null;
            }
            switch (scanOrder = scanOrder.trim().toLowerCase(Locale.ROOT)) {
                case "bff": 
                case "bottom field first": {
                    return BFF;
                }
                case "bfo": 
                case "bottom field only": {
                    return BFO;
                }
                case "pulldown": {
                    return PULLDOWN;
                }
                case "2:2:2:2:2:2:2:2:2:2:2:3 pulldown": {
                    return PULLDOWN_2_2_2_2_2_2_2_2_2_2_2_3;
                }
                case "2:3 pulldown": {
                    return PULLDOWN_2_3;
                }
                case "tff": 
                case "top field first": {
                    return TFF;
                }
                case "tfo": 
                case "top field only": {
                    return TFO;
                }
            }
            LOGGER.debug("Warning: Unrecognized ScanOrder \"{}\"", (Object)scanOrder);
            if (scanOrder.contains("pulldown")) {
                return PULLDOWN;
            }
            return null;
        }
    }

    public static enum Mode3D {
        ML,
        MR,
        SBSL,
        SBSR,
        SBS2L,
        SBS2R,
        ABL,
        ABR,
        AB2L,
        AB2R,
        ARCG,
        ARCH,
        ARCC,
        ARCD,
        AGMG,
        AGMH,
        AGMC,
        AGMD,
        AYBG,
        AYBH,
        AYBC,
        AYBD;

    }
}

