/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.Iterator;
import java.util.LinkedList;
import net.pms.logging.CacheAppender;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheLogger.class);
    private static final LinkedList<Appender<ILoggingEvent>> APPENDER_LIST = new LinkedList();
    private static volatile CacheAppender<ILoggingEvent> cacheAppender = null;
    private static LoggerContext loggerContext = null;
    private static ch.qos.logback.classic.Logger rootLogger;

    private CacheLogger() {
    }

    private static void detachRootAppenders() {
        Iterator<Appender<ILoggingEvent>> it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender<ILoggingEvent> appender = it.next();
            if (appender == cacheAppender) continue;
            APPENDER_LIST.add(appender);
            rootLogger.detachAppender(appender);
        }
    }

    private static void attachRootAppenders() {
        while (!APPENDER_LIST.isEmpty()) {
            Appender<ILoggingEvent> appender = APPENDER_LIST.poll();
            rootLogger.addAppender(appender);
        }
    }

    private static void disposeOfAppenders() {
        APPENDER_LIST.clear();
    }

    public static boolean isActive() {
        return cacheAppender != null;
    }

    public static synchronized void initContext() {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (!(iLoggerFactory instanceof LoggerContext)) {
            LOGGER.debug("Not using LogBack, aborting CacheLogger");
            loggerContext = null;
            return;
        }
        if (!CacheLogger.isActive()) {
            LOGGER.error("initContext() cannot be called while isActive() is false");
            return;
        }
        loggerContext = (LoggerContext)iLoggerFactory;
        rootLogger = loggerContext.getLogger("ROOT");
        CacheLogger.disposeOfAppenders();
        CacheLogger.detachRootAppenders();
        if (!rootLogger.isAttached((Appender<ILoggingEvent>)cacheAppender)) {
            rootLogger.addAppender((Appender<ILoggingEvent>)cacheAppender);
        }
        cacheAppender.setContext(loggerContext);
        cacheAppender.setName("CacheAppender");
        cacheAppender.start();
    }

    public static synchronized void startCaching() {
        if (CacheLogger.isActive()) {
            LOGGER.debug("StartCaching() failed: Caching already started");
        } else {
            cacheAppender = new CacheAppender();
            CacheLogger.initContext();
        }
    }

    public static synchronized void stopAndFlush() {
        if (loggerContext == null) {
            LOGGER.debug("Not using LogBack, aborting CacheLogger.stopAndFlush()");
            return;
        }
        if (!CacheLogger.isActive()) {
            LOGGER.error("stopAndFlush() cannot be called while isActive() is false");
            return;
        }
        cacheAppender.stop();
        rootLogger.detachAppender((Appender<ILoggingEvent>)cacheAppender);
        CacheLogger.attachRootAppenders();
        cacheAppender.flush(rootLogger);
        cacheAppender = null;
    }

    public static synchronized Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return APPENDER_LIST.iterator();
    }

    public static synchronized void addAppender(Appender<ILoggingEvent> newAppender) {
        APPENDER_LIST.add(newAppender);
    }

    public static synchronized boolean removeAppender(Appender<ILoggingEvent> appender) {
        return APPENDER_LIST.remove(appender);
    }
}

