/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.pms.io.IPipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.StreamModifier;
import net.pms.platform.PlatformUtils;
import net.pms.util.DTSAudioOutputStream;
import net.pms.util.H264AnnexBInputStream;
import net.pms.util.IEC61937AudioOutputStream;
import net.pms.util.PCMAudioOutputStream;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeIPCProcess
extends Thread
implements ProcessWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeIPCProcess.class);
    private final IPipeProcess mkin;
    private final IPipeProcess mkout;
    private StreamModifier modifier;

    public StreamModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(StreamModifier modifier) {
        this.modifier = modifier;
    }

    public PipeIPCProcess(String inPipeName, String outPipeName, boolean inForceReconnect, boolean outForcereconnect) {
        this.mkin = PlatformUtils.INSTANCE.getPipeProcess(inPipeName, inForceReconnect ? "reconnect" : "dummy");
        this.mkout = PlatformUtils.INSTANCE.getPipeProcess(outPipeName, "out", outForcereconnect ? "reconnect" : "dummy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] b = new byte[524288];
        InputStream in = null;
        OutputStream out = null;
        OutputStream debug = null;
        try {
            int n;
            in = this.mkin.getInputStream();
            out = this.mkout.getOutputStream();
            if (this.modifier != null && this.modifier.isH264AnnexB()) {
                in = new H264AnnexBInputStream(in, this.modifier.getHeader());
            } else if (this.modifier != null && this.modifier.isEncodedAudioPassthrough()) {
                out = new IEC61937AudioOutputStream(new PCMAudioOutputStream(out, this.modifier.getNbChannels(), this.modifier.getSampleFrequency(), this.modifier.getBitsPerSample()));
            } else if (this.modifier != null && this.modifier.isDtsEmbed()) {
                out = new DTSAudioOutputStream(new PCMAudioOutputStream(out, this.modifier.getNbChannels(), this.modifier.getSampleFrequency(), this.modifier.getBitsPerSample()));
            } else if (this.modifier != null && this.modifier.isPcm()) {
                out = new PCMAudioOutputStream(out, this.modifier.getNbChannels(), this.modifier.getSampleFrequency(), this.modifier.getBitsPerSample());
            }
            if (this.modifier != null && this.modifier.getHeader() != null && !this.modifier.isH264AnnexB()) {
                out.write(this.modifier.getHeader());
            }
            while ((n = in.read(b)) > -1) {
                out.write(b, 0, n);
                if (debug == null) continue;
                debug.write(b, 0, n);
            }
        }
        catch (InterruptedIOException e) {
            if (LOGGER.isDebugEnabled()) {
                if (StringUtils.isNotBlank(e.getMessage())) {
                    LOGGER.debug("IPC pipe interrupted after writing {} bytes, shutting down: {}", (Object)e.bytesTransferred, (Object)e.getMessage());
                } else {
                    LOGGER.debug("IPC pipe interrupted after writing {} bytes, shutting down...", (Object)e.bytesTransferred);
                }
                LOGGER.trace("", e);
            }
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred during IPC piping: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (debug != null) {
                    debug.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug("Error closing IPC pipe streams: {}" + e.getMessage());
                LOGGER.trace("", e);
            }
        }
    }

    public String getInputPipe() {
        return this.mkin.getInputPipe();
    }

    public String getOutputPipe() {
        return this.mkout.getOutputPipe();
    }

    public ProcessWrapper getPipeProcess() {
        return this;
    }

    public void deleteLater() {
        this.mkin.deleteLater();
        this.mkout.deleteLater();
    }

    public InputStream getInputStream() throws IOException {
        return this.mkin.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mkout.getOutputStream();
    }

    @Override
    public InputStream getInputStream(long seek) throws IOException {
        return null;
    }

    public ArrayList<String> getResults() {
        return null;
    }

    @Override
    public boolean isDestroyed() {
        return this.isAlive();
    }

    @Override
    public void runInNewThread() {
        if (!Platform.isWindows()) {
            this.mkin.getPipeProcess().runInNewThread();
            this.mkout.getPipeProcess().runInNewThread();
            UMSUtils.sleep(150);
        }
        this.start();
    }

    @Override
    public void runInSameThread() {
        if (!Platform.isWindows()) {
            this.mkin.getPipeProcess().runInNewThread();
            this.mkout.getPipeProcess().runInNewThread();
            UMSUtils.sleep(150);
        }
        this.run();
    }

    @Override
    public boolean isReadyToStop() {
        return false;
    }

    @Override
    public void setReadyToStop(boolean nullable) {
    }

    @Override
    public void stopProcess() {
        this.interrupt();
        this.mkin.getPipeProcess().stopProcess();
        this.mkout.getPipeProcess().stopProcess();
    }
}

