/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputTextLogger
extends OutputConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputTextLogger.class);

    public OutputTextLogger(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public void run() {
        try (LineIterator it = IOUtils.lineIterator(this.inputStream, StandardCharsets.UTF_8);){
            while (it.hasNext()) {
                String line = it.next();
                LOGGER.debug(line);
                if (!this.filtered) continue;
                this.filtered = this.filter(line);
            }
        }
        catch (IOException ioe) {
            LOGGER.debug("Error consuming input stream: {}", (Object)ioe.getMessage());
        }
        catch (IllegalStateException ise) {
            LOGGER.debug("Error reading from closed input stream: {}", (Object)ise.getMessage());
        }
    }

    @Override
    public BufferedOutputFile getBuffer() {
        return null;
    }

    @Override
    public List<String> getResults() {
        return null;
    }
}

