/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputTextConsumer
extends OutputConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputTextConsumer.class);
    private final List<String> lines = new ArrayList<String>();
    private final Object linesLock = new Object();
    private final boolean log;

    public OutputTextConsumer(InputStream inputStream, boolean log) {
        super(inputStream);
        this.log = log;
    }

    @Override
    public void run() {
        try (LineIterator it = IOUtils.lineIterator(this.inputStream, Charset.defaultCharset());){
            while (it.hasNext()) {
                String line = it.next();
                if (line.length() > 0) {
                    this.addLine(line);
                }
                if (this.log) {
                    LOGGER.debug(line);
                }
                if (!this.filtered) continue;
                this.filtered = this.filter(line);
            }
        }
        catch (IOException ioe) {
            LOGGER.debug("Error consuming input stream: {}", (Object)ioe.getMessage());
        }
        catch (IllegalStateException ise) {
            LOGGER.debug("Error reading from closed input stream: {}", (Object)ise.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLine(String line) {
        Object object = this.linesLock;
        synchronized (object) {
            this.lines.add(line);
        }
    }

    @Override
    public BufferedOutputFile getBuffer() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getResults() {
        ArrayList<String> clonedResults = new ArrayList<String>();
        Object object = this.linesLock;
        synchronized (object) {
            clonedResults.addAll(this.lines);
        }
        return clonedResults;
    }
}

