/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.HlsHelper;
import net.pms.io.IPipeProcess;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.renderers.Renderer;
import net.pms.util.IPushOutput;

public final class OutputParams {
    private File workDir;
    private Map<String, String> env;
    private double minFileSize;
    private double minBufferSize;
    private double maxBufferSize;
    private double timeseek;
    private double timeend;
    private int fromFrame;
    private int toFrame;
    private int waitbeforestart;
    private IPipeProcess[] inputpipes = new IPipeProcess[2];
    private IPipeProcess[] outputpipes = new IPipeProcess[2];
    private MediaAudio aid;
    private MediaSubtitle sid;
    private int secondReadMinSize;
    private int outputByteArrayStreamBufferSize;
    private boolean noexitcheck;
    private boolean log;
    private boolean lossyaudio;
    private boolean losslessaudio;
    private boolean noVideoEncode;
    private String forceFps;
    private String forceType;
    private Renderer mediaRenderer;
    private boolean hidebuffer;
    private byte[] header;
    private IPushOutput stdin;
    private boolean avidemux;
    private boolean shiftScr;
    private boolean cleanup;
    private HlsHelper.HlsConfiguration hlsConfiguration;

    public OutputParams(UmsConfiguration configuration) {
        if (configuration != null) {
            this.setWaitBeforeStart(configuration.getVideoTranscodeStartDelay() * 1000);
        } else {
            this.setWaitBeforeStart(6000);
        }
        this.setFromFrame(-1);
        this.setToFrame(-1);
        this.setSecondReadMinSize(1000000);
        if (configuration != null) {
            this.setMinFileSize(configuration.getMinStreamBuffer());
            this.setMinBufferSize(configuration.getMinMemoryBufferSize());
            this.setMaxBufferSize(configuration.getMaxMemoryBufferSize());
        }
        if (this.getMaxBufferSize() < 100.0) {
            this.setMaxBufferSize(100.0);
        }
        this.setTimeSeek(0.0);
        this.setEnv(null);
        this.setHlsConfiguration(null);
    }

    public void manageFastStart() {
        if (this.getMediaRenderer() != null && this.getMediaRenderer().isTranscodeFastStart()) {
            this.setWaitBeforeStart(0);
            this.setMinBufferSize(1.0);
        }
    }

    public String toString() {
        return "OutputParams [aid=" + String.valueOf(this.getAid()) + ", avidemux=" + this.isAvidemux() + ", cleanup=" + this.isCleanup() + ", forceFps=" + this.getForceFps() + ", forceType=" + this.getForceType() + ", fromFrame=" + this.getFromFrame() + ", header=" + Arrays.toString(this.getHeader()) + ", hidebuffer=" + this.isHideBuffer() + ", input_pipes=" + Arrays.toString(this.getInputPipes()) + ", log=" + this.isLog() + ", losslessaudio=" + this.isLosslessAudio() + ", lossyaudio=" + this.isLossyAudio() + ", maxBufferSize=" + this.getMaxBufferSize() + ", mediaRenderer=" + String.valueOf(this.getMediaRenderer()) + ", minBufferSize=" + this.getMinBufferSize() + ", minFileSize=" + this.getMinFileSize() + ", no_videoencode=" + this.isNoVideoEncode() + ", outputByteArrayStreamBufferSize= " + this.getOutputByteArrayStreamBufferSize() + ", noexitcheck=" + this.isNoExitCheck() + ", output_pipes=" + Arrays.toString(this.getOutputPipes()) + ", secondread_minsize=" + this.getSecondReadMinSize() + ", shift_scr=" + this.isShiftSscr() + ", sid=" + String.valueOf(this.getSid()) + ", stdin=" + String.valueOf(this.getStdIn()) + ", timeend=" + this.getTimeEnd() + ", timeseek=" + this.getTimeSeek() + ", toFrame=" + this.getToFrame() + ", waitbeforestart=" + this.getWaitBeforeStart() + ", workDir=" + String.valueOf(this.getWorkDir()) + ", env=" + String.valueOf(this.getEnv()) + "]";
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public double getMinBufferSize() {
        return this.minBufferSize;
    }

    public void setMinBufferSize(double minBufferSize) {
        this.minBufferSize = minBufferSize;
    }

    public double getMinFileSize() {
        return this.minFileSize;
    }

    public void setMinFileSize(double minFileSize) {
        this.minFileSize = minFileSize;
    }

    public double getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(double maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public double getTimeSeek() {
        return this.timeseek;
    }

    public void setTimeSeek(double timeseek) {
        this.timeseek = timeseek;
    }

    public double getTimeEnd() {
        return this.timeend;
    }

    public void setTimeEnd(double timeend) {
        this.timeend = timeend;
    }

    public int getFromFrame() {
        return this.fromFrame;
    }

    public void setFromFrame(int fromFrame) {
        this.fromFrame = fromFrame;
    }

    public int getWaitBeforeStart() {
        return this.waitbeforestart;
    }

    public void setWaitBeforeStart(int waitbeforestart) {
        this.waitbeforestart = waitbeforestart;
    }

    public int getToFrame() {
        return this.toFrame;
    }

    public void setToFrame(int toFrame) {
        this.toFrame = toFrame;
    }

    public IPipeProcess[] getOutputPipes() {
        return this.outputpipes;
    }

    public void setOutputPipes(IPipeProcess[] outputpipes) {
        this.outputpipes = outputpipes;
    }

    public IPipeProcess[] getInputPipes() {
        return this.inputpipes;
    }

    public void setInputPipes(IPipeProcess[] inputpipes) {
        this.inputpipes = inputpipes;
    }

    public MediaAudio getAid() {
        return this.aid;
    }

    public void setAid(MediaAudio aid) {
        this.aid = aid;
    }

    public MediaSubtitle getSid() {
        return this.sid;
    }

    public void setSid(MediaSubtitle sid) {
        this.sid = sid;
    }

    public int getOutputByteArrayStreamBufferSize() {
        return this.outputByteArrayStreamBufferSize;
    }

    public void setOutputByteArrayStreamBufferSize(int outputByteArrayStreamBufferSize) {
        this.outputByteArrayStreamBufferSize = outputByteArrayStreamBufferSize;
    }

    public int getSecondReadMinSize() {
        return this.secondReadMinSize;
    }

    public void setSecondReadMinSize(int secondReadMinSize) {
        this.secondReadMinSize = secondReadMinSize;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isNoExitCheck() {
        return this.noexitcheck;
    }

    public void setNoExitCheck(boolean noexitcheck) {
        this.noexitcheck = noexitcheck;
    }

    public boolean isLosslessAudio() {
        return this.losslessaudio;
    }

    public void setLosslessAudio(boolean losslessaudio) {
        this.losslessaudio = losslessaudio;
    }

    public boolean isLossyAudio() {
        return this.lossyaudio;
    }

    public void setLossyAudio(boolean lossyaudio) {
        this.lossyaudio = lossyaudio;
    }

    public boolean isNoVideoEncode() {
        return this.noVideoEncode;
    }

    public void setNoVideoEncode(boolean noVideoEncode) {
        this.noVideoEncode = noVideoEncode;
    }

    public String getForceFps() {
        return this.forceFps;
    }

    public void setForceFps(String forceFps) {
        this.forceFps = forceFps;
    }

    public String getForceType() {
        return this.forceType;
    }

    public void setForceType(String forceType) {
        this.forceType = forceType;
    }

    public Renderer getMediaRenderer() {
        return this.mediaRenderer;
    }

    public void setMediaRenderer(Renderer mediaRenderer) {
        this.mediaRenderer = mediaRenderer;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public boolean isHideBuffer() {
        return this.hidebuffer;
    }

    public void setHideBuffer(boolean hidebuffer) {
        this.hidebuffer = hidebuffer;
    }

    public IPushOutput getStdIn() {
        return this.stdin;
    }

    public void setStdIn(IPushOutput stdin) {
        this.stdin = stdin;
    }

    public boolean isAvidemux() {
        return this.avidemux;
    }

    public void setAvidemux(boolean avidemux) {
        this.avidemux = avidemux;
    }

    public boolean isShiftSscr() {
        return this.shiftScr;
    }

    public void setShiftScr(boolean shiftScr) {
        this.shiftScr = shiftScr;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public boolean isHlsConfigured() {
        return this.hlsConfiguration != null;
    }

    public HlsHelper.HlsConfiguration getHlsConfiguration() {
        return this.hlsConfiguration;
    }

    public void setHlsConfiguration(HlsHelper.HlsConfiguration hlsConfiguration) {
        this.hlsConfiguration = hlsConfiguration;
    }
}

