/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import net.pms.io.ByteProcessWrapperResult;
import net.pms.io.ProcessWrapperConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteProcessWrapperConsumer
implements ProcessWrapperConsumer<ByteProcessWrapperResult, byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteProcessWrapperConsumer.class);

    @Override
    @Nullable
    public FutureTask<byte[]> consume(InputStream inputStream) {
        return this.consume(inputStream, null);
    }

    @Override
    @Nullable
    public FutureTask<byte[]> consume(@Nullable InputStream inputStream, @Nullable String threadName) {
        if (inputStream == null) {
            return null;
        }
        Callable<byte[]> callable = () -> {
            byte[] result = IOUtils.toByteArray(inputStream);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Captured {} bytes of process output", (Object)result.length);
            }
            return result;
        };
        FutureTask<byte[]> result = new FutureTask<byte[]>(callable);
        Thread runner = StringUtils.isBlank(threadName) ? new Thread(result) : new Thread(result, threadName);
        runner.start();
        return result;
    }

    @Override
    public ByteProcessWrapperResult createResult(@Nullable byte[] output, int exitCode, @Nullable Throwable throwable) {
        return new ByteProcessWrapperResult(output, exitCode, throwable);
    }
}

