/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.gui.GuiManager;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.WaitBufferedInputStream;
import net.pms.renderers.Renderer;
import net.pms.util.UMSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedOutputFileImpl
extends OutputStream
implements BufferedOutputFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferedOutputFileImpl.class);
    private static final NumberFormat FORMATTER = NumberFormat.getInstance(Locale.US);
    private static final int INITIAL_BUFFER_SIZE = 0x3200000;
    private static final int MARGIN_LARGE = 20000000;
    private static final int MARGIN_MEDIUM = 2000000;
    private static final int MARGIN_SMALL = 600000;
    private static final int CHECK_INTERVAL = 500;
    private static final int CHECK_END_OF_PROCESS = 2500;
    private final UmsConfiguration configuration;
    private final Renderer renderer;
    private final int minMemorySize;
    private final int maxMemorySize;
    private final boolean forcefirst;
    private final double timeseek;
    private final double timeend;
    private final boolean hidebuffer;
    private final boolean cleanup;
    private final boolean shiftScr;
    private final int secondReadMinSize;
    private final FileOutputStream debugOutput = null;
    private int bufferOverflowWarning;
    private boolean eof;
    private long writeCount;
    private byte[] buffer;
    private ArrayList<WaitBufferedInputStream> inputStreams;
    private ProcessWrapper attachedThread;
    private Timer timer;
    private boolean buffered = false;
    private long packetpos = 0L;

    private byte[] growBuffer(byte[] buffer, int newSize) {
        byte[] copy;
        if (buffer == null) {
            buffer = new byte[]{};
        }
        if (newSize <= buffer.length) {
            return buffer;
        }
        try {
            copy = new byte[newSize];
        }
        catch (OutOfMemoryError e) {
            if (buffer.length == 0) {
                LOGGER.trace("Cannot initialize buffer to " + FORMATTER.format(newSize) + " bytes.");
            } else {
                LOGGER.debug("Cannot grow buffer size from " + FORMATTER.format(buffer.length) + " bytes to " + FORMATTER.format(newSize) + " bytes.");
                LOGGER.debug("Error given: " + String.valueOf(e));
            }
            long realisticSize = Runtime.getRuntime().maxMemory() * 3L / 10L;
            if (realisticSize < (long)buffer.length) {
                return buffer;
            }
            try {
                copy = new byte[(int)realisticSize];
            }
            catch (OutOfMemoryError e2) {
                LOGGER.debug("Cannot grow buffer size from " + FORMATTER.format(buffer.length) + " bytes to " + FORMATTER.format(realisticSize) + " bytes either.");
                LOGGER.trace("freeMemory: " + FORMATTER.format(Runtime.getRuntime().freeMemory()));
                LOGGER.trace("totalMemory: " + FORMATTER.format(Runtime.getRuntime().totalMemory()));
                LOGGER.trace("maxMemory: " + FORMATTER.format(Runtime.getRuntime().maxMemory()));
                LOGGER.debug("Error given: " + String.valueOf(e2));
                return buffer;
            }
        }
        if (buffer.length == 0) {
            LOGGER.trace("Successfully initialized buffer to " + FORMATTER.format(copy.length) + " bytes.");
        } else {
            try {
                System.arraycopy(buffer, 0, copy, 0, buffer.length);
                LOGGER.trace("Successfully grown buffer from " + FORMATTER.format(buffer.length) + " bytes to " + FORMATTER.format(copy.length) + " bytes.");
            }
            catch (NullPointerException npe) {
                LOGGER.trace("Cannot grow buffer size, error copying buffer contents.");
            }
        }
        return copy;
    }

    public BufferedOutputFileImpl(OutputParams params) {
        this.configuration = PMS.getConfiguration(params);
        this.renderer = params.getMediaRenderer();
        this.forcefirst = this.configuration.getTrancodeBlocksMultipleConnections() && this.configuration.getTrancodeKeepFirstConnections();
        this.minMemorySize = (int)(1048576.0 * params.getMinBufferSize());
        this.maxMemorySize = (int)(1048576.0 * params.getMaxBufferSize());
        int margin = 20000000;
        if (this.maxMemorySize < margin && this.maxMemorySize < (margin = 2000000)) {
            margin = 600000;
        }
        this.bufferOverflowWarning = this.maxMemorySize - margin;
        this.secondReadMinSize = params.getSecondReadMinSize();
        this.timeseek = params.getTimeSeek();
        this.timeend = params.getTimeEnd();
        this.shiftScr = params.isShiftSscr();
        this.hidebuffer = params.isHideBuffer();
        this.cleanup = params.isCleanup();
        this.buffer = this.maxMemorySize > 0x3200000 ? this.growBuffer(null, 0x3200000) : this.growBuffer(null, this.maxMemorySize);
        if (this.buffer.length == 0) {
            LOGGER.info("FATAL ERROR: OutOfMemory / dumping stats");
            LOGGER.trace("freeMemory: " + Runtime.getRuntime().freeMemory());
            LOGGER.trace("totalMemory: " + Runtime.getRuntime().totalMemory());
            LOGGER.trace("maxMemory: " + Runtime.getRuntime().maxMemory());
            System.exit(1);
        }
        this.inputStreams = new ArrayList();
    }

    @Override
    public void close() throws IOException {
        LOGGER.trace("EOF");
        this.eof = true;
        if (this.cleanup) {
            this.detachInputStream();
        }
    }

    @Override
    public WaitBufferedInputStream getCurrentInputStream() {
        WaitBufferedInputStream wai = null;
        if (!this.inputStreams.isEmpty()) {
            try {
                wai = this.forcefirst ? this.inputStreams.get(0) : this.inputStreams.get(this.inputStreams.size() - 1);
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.error("Unexpected input stream removal", e);
            }
        }
        return wai;
    }

    @Override
    public InputStream getInputStream(long newReadPosition) {
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(false);
        }
        if (this.configuration.getTrancodeBlocksMultipleConnections() && this.getCurrentInputStream() != null) {
            if (this.configuration.getTrancodeKeepFirstConnections()) {
                LOGGER.debug("BufferedOutputFile is already attached to an InputStream: " + String.valueOf(this.getCurrentInputStream()));
            } else {
                while (!this.inputStreams.isEmpty()) {
                    try {
                        this.inputStreams.get(0).close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error: ", e);
                    }
                }
                this.inputStreams.clear();
                WaitBufferedInputStream atominputStream = new WaitBufferedInputStream(this);
                this.inputStreams.add(atominputStream);
                LOGGER.debug("Reassign inputstream: " + String.valueOf(this.getCurrentInputStream()));
            }
            return null;
        }
        WaitBufferedInputStream atominputStream = new WaitBufferedInputStream(this);
        this.inputStreams.add(atominputStream);
        if (newReadPosition > 0L) {
            LOGGER.debug("Setting InputStream new position to: " + FORMATTER.format(newReadPosition));
            atominputStream.setReadCount(newReadPosition);
        }
        return atominputStream;
    }

    @Override
    public long getWriteCount() {
        return this.writeCount;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.debugOutput != null) {
            this.debugOutput.write(b, off, len);
            this.debugOutput.flush();
        }
        WaitBufferedInputStream input = this.getCurrentInputStream();
        while (input != null && this.writeCount - input.getReadCount() > (long)this.bufferOverflowWarning || input == null && this.writeCount > (long)this.bufferOverflowWarning) {
            UMSUtils.sleep(500);
            input = this.getCurrentInputStream();
        }
        if (this.buffer != null) {
            int mb = (int)(this.writeCount % (long)this.maxMemorySize);
            if (mb >= this.buffer.length - (len - off)) {
                if (this.buffer.length == 0x3200000) {
                    this.buffer = this.growBuffer(this.buffer, this.maxMemorySize);
                }
                int s = len - off;
                for (int i = 0; i < s; ++i) {
                    this.buffer[this.modulo((int)(mb + i), (int)this.buffer.length)] = b[off + i];
                }
            } else {
                System.arraycopy(b, off, this.buffer, mb, len - off);
                if (len - off > 0) {
                    this.buffered = true;
                }
            }
            if (this.timeseek > 0.0 && this.writeCount > 10L) {
                for (int i = 0; i < len; ++i) {
                    if (this.buffer == null || !this.shiftScr) continue;
                    this.shiftSCRByTimeSeek(mb + i, (int)this.timeseek);
                }
            }
            this.writeCount += (long)(len - off);
            if (this.timeseek > 0.0 && this.timeend == 0.0) {
                int packetLength = 6;
                while (this.packetpos + (long)packetLength < this.writeCount && this.buffer != null) {
                    int packetposMB = (int)(this.packetpos % (long)this.maxMemorySize);
                    int streamPos = 0;
                    if (this.buffer[this.modulo(packetposMB, this.buffer.length)] == 71) {
                        packetLength = 188;
                        streamPos = 4;
                        if ((this.buffer[this.modulo(packetposMB + 3, this.buffer.length)] & 0x20) == 32) {
                            streamPos += 1 + (this.buffer[this.modulo(packetposMB + 4, this.buffer.length)] + 256) % 256;
                        }
                        if (streamPos == 188) {
                            streamPos = -1;
                        }
                    } else if (this.buffer[this.modulo(packetposMB + 3, this.buffer.length)] == -70) {
                        packetLength = 14;
                        streamPos = -1;
                    } else {
                        packetLength = 6 + (this.buffer[this.modulo(packetposMB + 4, this.buffer.length)] + 256) % 256 * 256 + (this.buffer[this.modulo(packetposMB + 5, this.buffer.length)] + 256) % 256;
                    }
                    if (streamPos != -1 && !this.shiftVideo(mb = packetposMB + streamPos + 18, true)) {
                        this.shiftAudio(mb -= 5, true);
                    }
                    this.packetpos += (long)packetLength;
                }
            }
        }
    }

    private int modulo(int number, int divisor) {
        if (number >= 0) {
            return number % divisor;
        }
        return (number % divisor + divisor) % divisor;
    }

    @Override
    public void write(int b) throws IOException {
        boolean bb = b % 100000 == 0;
        WaitBufferedInputStream input = this.getCurrentInputStream();
        while (bb && (input != null && this.writeCount - input.getReadCount() > (long)this.bufferOverflowWarning || input == null && this.writeCount == (long)this.bufferOverflowWarning)) {
            UMSUtils.sleep(500);
            input = this.getCurrentInputStream();
        }
        int mb = (int)(this.writeCount++ % (long)this.maxMemorySize);
        if (this.buffer != null) {
            this.buffer[mb] = (byte)b;
            this.buffered = true;
            if (this.writeCount == 0x3200000L) {
                this.buffer = this.growBuffer(this.buffer, this.maxMemorySize);
            }
            if (this.timeseek > 0.0 && this.writeCount > 19L) {
                this.shiftByTimeSeek(mb, mb <= 20);
            }
            if (this.timeseek > 0.0 && this.writeCount > 10L) {
                this.shiftSCRByTimeSeek(mb, (int)this.timeseek);
            }
        }
    }

    private void shiftSCRByTimeSeek(int bufferIndex, int offsetSec) {
        int m9 = this.modulo(bufferIndex - 9, this.buffer.length);
        int m8 = this.modulo(bufferIndex - 8, this.buffer.length);
        int m7 = this.modulo(bufferIndex - 7, this.buffer.length);
        int m6 = this.modulo(bufferIndex - 6, this.buffer.length);
        int m5 = this.modulo(bufferIndex - 5, this.buffer.length);
        int m4 = this.modulo(bufferIndex - 4, this.buffer.length);
        int m3 = this.modulo(bufferIndex - 3, this.buffer.length);
        int m2 = this.modulo(bufferIndex - 2, this.buffer.length);
        int m1 = this.modulo(bufferIndex - 1, this.buffer.length);
        int m0 = this.modulo(bufferIndex, this.buffer.length);
        if (this.buffer[m9] == 0 && this.buffer[m8] == 0 && this.buffer[m7] == 1 && this.buffer[m6] == -70 && (this.buffer[m5] & 0x80) != 128 && (this.buffer[m5] & 0x40) == 64 && (this.buffer[m5] & 4) == 4 && (this.buffer[m3] & 4) == 4 && (this.buffer[m1] & 4) == 4 && (this.buffer[m0] & 1) == 1) {
            long scr3230 = (this.buffer[m5] & 0x38) >> 3;
            long scr2915 = ((this.buffer[m5] & 3) << 13) + (this.buffer[m4] << 5) + ((this.buffer[m3] & 0xF8) >> 3);
            long scr1400 = ((this.buffer[m3] & 3) << 13) + (this.buffer[m2] << 5) + ((this.buffer[m1] & 0xF8) >> 3);
            long scr = (scr3230 << 30) + (scr2915 << 15) + scr1400;
            long scrNew = scr + 90000L * (long)offsetSec;
            long scr3230New = (scrNew & 0x1C0000000L) >> 30;
            long scr2915New = (scrNew & 0x3FFF8000L) >> 15;
            long scr1400New = scrNew & 0x7FFFL;
            this.buffer[m5] = (byte)((long)(this.buffer[m5] & 0xC7) + (scr3230New << 3 & 0x38L));
            this.buffer[m5] = (byte)((long)(this.buffer[m5] & 0xFC) + (scr2915New >> 13 & 3L));
            this.buffer[m4] = (byte)(scr2915New >> 5);
            this.buffer[m3] = (byte)((long)(this.buffer[m3] & 7) + (scr2915New << 3 & 0xF8L));
            this.buffer[m3] = (byte)((long)(this.buffer[m3] & 0xFC) + (scr1400New >> 13 & 3L));
            this.buffer[m2] = (byte)(scr1400New >> 5);
            this.buffer[m1] = (byte)((long)(this.buffer[m1] & 7) + (scr1400New << 3 & 0xF8L));
        }
    }

    private void shiftGOPByTimeSeek(int bufferIndex, int offsetSec) {
        int m7 = this.modulo(bufferIndex - 7, this.buffer.length);
        int m6 = this.modulo(bufferIndex - 6, this.buffer.length);
        int m5 = this.modulo(bufferIndex - 5, this.buffer.length);
        int m4 = this.modulo(bufferIndex - 4, this.buffer.length);
        int m3 = this.modulo(bufferIndex - 3, this.buffer.length);
        int m2 = this.modulo(bufferIndex - 2, this.buffer.length);
        int m1 = this.modulo(bufferIndex - 1, this.buffer.length);
        int m0 = this.modulo(bufferIndex, this.buffer.length);
        if (this.buffer[m7] == 0 && this.buffer[m6] == 0 && this.buffer[m5] == 1 && this.buffer[m4] == -72 && (this.buffer[m2] & 8) == 8 && (this.buffer[m0] & 0x1F) == 0 && (this.buffer[m3] & 0x80) != 128 && (this.buffer[m0] & 0x10) != 16) {
            byte h = (byte)((this.buffer[m3] & 0x7C) >> 2);
            byte m = (byte)(((this.buffer[m3] & 3) << 4) + ((this.buffer[m2] & 0xF0) >> 4));
            byte s = (byte)(((this.buffer[m2] & 7) << 3) + ((this.buffer[m1] & 0xE0) >> 5));
            int offset = s + m * 60 + h * 60 + offsetSec;
            byte newh = (byte)(offset / 3600 % 24);
            byte newm = (byte)(offset / 60 % 60);
            byte news = (byte)(offset % 60);
            this.buffer[m3] = (byte)((this.buffer[m3] & 0x83) + (newh << 2));
            this.buffer[m3] = (byte)((this.buffer[m3] & 0xFC) + (newm >> 4));
            this.buffer[m2] = (byte)((this.buffer[m2] & 0xF) + (newm << 4));
            this.buffer[m2] = (byte)((this.buffer[m2] & 0xF8) + (news >> 3));
            this.buffer[m1] = (byte)((this.buffer[m1] & 0x1F) + (news << 5));
        }
    }

    private void shiftByTimeSeek(int mb, boolean mod) {
        this.shiftVideo(mb, mod);
        this.shiftAudio(mb, mod);
    }

    private boolean shiftAudio(int mb, boolean mod) {
        boolean bb;
        boolean bl = bb = !mod && (this.buffer[mb - 10] == -67 || this.buffer[mb - 10] == -64) && this.buffer[mb - 11] == 1 && this.buffer[mb - 12] == 0 && this.buffer[mb - 13] == 0 && (this.buffer[mb - 6] & 0x80) == 128 || mod && (this.buffer[this.modulo(mb - 10, this.buffer.length)] == -67 || this.buffer[this.modulo(mb - 10, this.buffer.length)] == -64) && this.buffer[this.modulo(mb - 11, this.buffer.length)] == 1 && this.buffer[this.modulo(mb - 12, this.buffer.length)] == 0 && this.buffer[this.modulo(mb - 13, this.buffer.length)] == 0 && (this.buffer[this.modulo(mb - 6, this.buffer.length)] & 0x80) == 128;
        if (bb) {
            int pts = (((this.buffer[this.modulo(mb - 3, this.buffer.length)] & 0xFF) << 8) + (this.buffer[this.modulo(mb - 2, this.buffer.length)] & 0xFF) >> 1 << 15) + (((this.buffer[this.modulo(mb - 1, this.buffer.length)] & 0xFF) << 8) + (this.buffer[this.modulo(mb, this.buffer.length)] & 0xFF) >> 1);
            this.setTS(pts += (int)(this.timeseek * 90000.0), mb, mod);
            return true;
        }
        return false;
    }

    private boolean shiftVideo(int mb, boolean mod) {
        boolean bb;
        boolean bl = bb = !mod && (this.buffer[mb - 15] == -32 || this.buffer[mb - 15] == -3) && this.buffer[mb - 16] == 1 && this.buffer[mb - 17] == 0 && this.buffer[mb - 18] == 0 && (this.buffer[mb - 11] & 0x80) == 128 && (this.buffer[mb - 9] & 0x20) == 32 || mod && (this.buffer[this.modulo(mb - 15, this.buffer.length)] == -32 || this.buffer[this.modulo(mb - 15, this.buffer.length)] == -3) && this.buffer[this.modulo(mb - 16, this.buffer.length)] == 1 && this.buffer[this.modulo(mb - 17, this.buffer.length)] == 0 && this.buffer[this.modulo(mb - 18, this.buffer.length)] == 0 && (this.buffer[this.modulo(mb - 11, this.buffer.length)] & 0x80) == 128 && (this.buffer[this.modulo(mb - 9, this.buffer.length)] & 0x20) == 32;
        if (bb) {
            boolean dtsPresent;
            int pts = this.getTS(mb - 5, mod);
            int dts = 0;
            boolean bl2 = dtsPresent = (this.buffer[this.modulo(mb - 11, this.buffer.length)] & 0x40) == 64;
            if (dtsPresent) {
                if ((this.buffer[this.modulo(mb - 4, this.buffer.length)] & 0xF) == 15) {
                    dts = ((255 - (this.buffer[this.modulo(mb - 3, this.buffer.length)] & 0xFF) << 8) + (255 - (this.buffer[this.modulo(mb - 2, this.buffer.length)] & 0xFF)) >> 1 << 15) + ((255 - (this.buffer[this.modulo(mb - 1, this.buffer.length)] & 0xFF) << 8) + (255 - (this.buffer[this.modulo(mb, this.buffer.length)] & 0xFF)) >> 1);
                    dts = -dts;
                } else {
                    dts = this.getTS(mb, mod);
                }
            }
            int ts = (int)(this.timeseek * 90000.0);
            if (mb == 50 && this.writeCount < (long)this.maxMemorySize) {
                --dts;
            }
            this.setTS(pts += ts, mb - 5, mod);
            if (dtsPresent) {
                if (dts < 0) {
                    this.buffer[this.modulo((int)(mb - 4), (int)this.buffer.length)] = 17;
                }
                this.setTS(dts += ts, mb, mod);
            }
            return true;
        }
        return false;
    }

    private int getTS(int mb, boolean modulo) {
        int m3 = mb - 3;
        int m2 = mb - 2;
        int m1 = mb - 1;
        int m0 = mb;
        if (modulo) {
            m3 = this.modulo(m3, this.buffer.length);
            m2 = this.modulo(m2, this.buffer.length);
            m1 = this.modulo(m1, this.buffer.length);
            m0 = this.modulo(m0, this.buffer.length);
        }
        return (((this.buffer[m3] & 0xFF) << 8) + (this.buffer[m2] & 0xFF) >> 1 << 15) + (((this.buffer[m1] & 0xFF) << 8) + (this.buffer[m0] & 0xFF) >> 1);
    }

    private void setTS(int ts, int mb, boolean modulo) {
        int m3 = mb - 3;
        int m2 = mb - 2;
        int m1 = mb - 1;
        int m0 = mb;
        if (modulo) {
            m3 = this.modulo(m3, this.buffer.length);
            m2 = this.modulo(m2, this.buffer.length);
            m1 = this.modulo(m1, this.buffer.length);
            m0 = this.modulo(m0, this.buffer.length);
        }
        int ptsLow = ts & Short.MAX_VALUE;
        int ptsHigh = ts >> 15 & Short.MAX_VALUE;
        int ptsLeftLow = 1 + (ptsLow << 1);
        int ptsLeftHigh = 1 + (ptsHigh << 1);
        this.buffer[m3] = (byte)((ptsLeftHigh & 0xFF00) >> 8);
        this.buffer[m2] = (byte)(ptsLeftHigh & 0xFF);
        this.buffer[m1] = (byte)((ptsLeftLow & 0xFF00) >> 8);
        this.buffer[m0] = (byte)(ptsLeftLow & 0xFF);
    }

    @Override
    public int read(boolean firstRead, long readCount, byte[] buf, int off, int len) {
        int c;
        int minBufferS;
        if (readCount > 0x3200000L && readCount < (long)this.maxMemorySize) {
            int newMargin = this.maxMemorySize - 2000000;
            if (this.bufferOverflowWarning != newMargin) {
                LOGGER.debug("Setting margin to 2Mb");
            }
            this.bufferOverflowWarning = newMargin;
        }
        if (this.eof && readCount >= this.writeCount) {
            return -1;
        }
        int n = minBufferS = firstRead ? this.minMemorySize : this.secondReadMinSize;
        for (c = 0; this.writeCount - readCount <= (long)minBufferS && !this.eof && c < 15; ++c) {
            if (c == 0) {
                LOGGER.trace("Suspend Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
            }
            UMSUtils.sleep(500);
        }
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(false);
        }
        if (c > 0) {
            LOGGER.trace("Resume Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
        }
        if (this.buffer == null || !this.buffered) {
            return -1;
        }
        int mb = (int)(readCount % (long)this.maxMemorySize);
        int endOF = this.buffer.length;
        int cut = 0;
        if (this.eof && this.writeCount - readCount < (long)len && (cut = (int)((long)len - (this.writeCount - readCount))) < 0) {
            cut = 0;
        }
        if (mb >= endOF - len) {
            int length = endOF - mb - cut;
            try {
                System.arraycopy(this.buffer, mb, buf, off, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.trace("Something went wrong with the buffer, error: " + String.valueOf(e));
                LOGGER.trace("buffer: " + Arrays.toString(this.buffer));
                LOGGER.trace("mb: " + mb);
                LOGGER.trace("buf: " + Arrays.toString(buf));
                LOGGER.trace("off: " + off);
                LOGGER.trace("endOF - mb - cut: " + length);
            }
            return length;
        }
        int length = len - cut;
        System.arraycopy(this.buffer, mb, buf, off, length);
        try {
            System.arraycopy(this.buffer, mb, buf, off, length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.trace("Something went wrong with the buffer, error: " + String.valueOf(e));
            LOGGER.trace("buffer: " + Arrays.toString(this.buffer));
            LOGGER.trace("mb: " + mb);
            LOGGER.trace("buf: " + Arrays.toString(buf));
            LOGGER.trace("off: " + off);
            LOGGER.trace("len - cut: " + length);
        }
        return length;
    }

    @Override
    public int read(boolean firstRead, long readCount) {
        int c;
        int minBufferS;
        if (readCount > 0x3200000L && readCount < (long)this.maxMemorySize) {
            int newMargin = this.maxMemorySize - 2000000;
            if (this.bufferOverflowWarning != newMargin) {
                LOGGER.debug("Setting margin to 2Mb");
            }
            this.bufferOverflowWarning = newMargin;
        }
        if (this.eof && readCount >= this.writeCount) {
            return -1;
        }
        int n = minBufferS = firstRead ? this.minMemorySize : this.secondReadMinSize;
        for (c = 0; this.writeCount - readCount <= (long)minBufferS && !this.eof && c < 15; ++c) {
            if (c == 0) {
                LOGGER.trace("Suspend Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
            }
            UMSUtils.sleep(500);
        }
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(false);
        }
        if (c > 0) {
            LOGGER.trace("Resume Read: readCount=" + readCount + " / writeCount=" + this.writeCount);
        }
        if (this.buffer == null || !this.buffered) {
            return -1;
        }
        try {
            return 0xFF & this.buffer[(int)(readCount % (long)this.maxMemorySize)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.info("Buffer read ArrayIndexOutOfBoundsException error:");
            LOGGER.info("readCount: \"" + readCount + "\"");
            LOGGER.info("maxMemorySize: \"" + this.maxMemorySize + "\"");
            return -1;
        }
    }

    @Override
    public synchronized void attachThread(ProcessWrapper thread) {
        if (this.attachedThread != null) {
            throw new RuntimeException("BufferedOutputFile is already attached to a Thread: " + String.valueOf(this.attachedThread));
        }
        LOGGER.debug("Attaching thread: " + String.valueOf(thread));
        this.attachedThread = thread;
        this.startTimer();
    }

    private void startTimer() {
        if (!this.hidebuffer && this.maxMemorySize > 0xF00000) {
            this.timer = new Timer(String.valueOf(this.attachedThread) + "-Timer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    long rc = 0L;
                    if (BufferedOutputFileImpl.this.getCurrentInputStream() != null) {
                        rc = BufferedOutputFileImpl.this.getCurrentInputStream().getReadCount();
                        GuiManager.setReadValue(rc);
                    }
                    long space = BufferedOutputFileImpl.this.writeCount - rc;
                    LOGGER.trace("buffered: " + FORMATTER.format(space) + " bytes / inputs: " + BufferedOutputFileImpl.this.inputStreams.size());
                    long bufferInMBs = space / 0x100000L;
                    if (BufferedOutputFileImpl.this.renderer != null) {
                        BufferedOutputFileImpl.this.renderer.setBuffer(bufferInMBs);
                    }
                    GuiManager.updateBuffer();
                }
            }, 0L, 2000L);
        }
    }

    @Override
    public void removeInputStream(WaitBufferedInputStream inputStream) {
        this.inputStreams.remove(inputStream);
    }

    @Override
    public void detachInputStream() {
        if (!this.hidebuffer) {
            GuiManager.setReadValue(0L);
        }
        if (this.attachedThread != null) {
            this.attachedThread.setReadyToStop(true);
        }
        Runnable checkEnd = () -> {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException e) {
                LOGGER.error(null, e);
            }
            if (this.attachedThread != null && this.attachedThread.isReadyToStop()) {
                if (!this.attachedThread.isDestroyed()) {
                    this.attachedThread.stopProcess();
                }
                this.reset();
            }
        };
        new Thread(checkEnd, String.valueOf(this.attachedThread) + "-Cleanup").start();
    }

    @Override
    public synchronized void reset() {
        if (this.debugOutput != null) {
            try {
                this.debugOutput.close();
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception", e);
            }
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.buffer != null) {
            LOGGER.trace("Destroying buffer");
            this.buffer = null;
        }
        this.buffered = false;
        if (this.renderer != null) {
            this.renderer.setBuffer(0L);
        }
        if (!this.hidebuffer && this.maxMemorySize != 0x100000) {
            GuiManager.updateBuffer();
        }
    }
}

