/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.WaitBufferedInputStream;

public class BufferedOutputByteArrayImpl
extends ByteArrayOutputStream
implements BufferedOutputFile {
    protected BufferedOutputByteArrayImpl(OutputParams params) {
        super(params.getOutputByteArrayStreamBufferSize() > 512 ? params.getOutputByteArrayStreamBufferSize() : 512);
    }

    protected BufferedOutputByteArrayImpl(int size) {
        super(size);
    }

    @Override
    public synchronized InputStream getInputStream(long newReadPosition) {
        if (newReadPosition < 0L) {
            throw new IndexOutOfBoundsException("Can't set new read position to a negative value (" + newReadPosition + ")");
        }
        int length = Math.max(this.count - (int)newReadPosition, 0);
        if (newReadPosition > 0L && newReadPosition >= (long)this.count) {
            throw new IndexOutOfBoundsException("Can't skip to position " + newReadPosition + " since the length is " + this.count);
        }
        byte[] bufferCopy = new byte[length];
        System.arraycopy(this.buf, (int)newReadPosition, bufferCopy, 0, length);
        return new ByteArrayInputStream(bufferCopy);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
    }

    @Override
    public void write(int b) {
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
    }

    @Override
    @Deprecated
    public WaitBufferedInputStream getCurrentInputStream() {
        return null;
    }

    @Override
    @Deprecated
    public long getWriteCount() {
        return 0L;
    }

    @Override
    @Deprecated
    public int read(boolean firstRead, long readCount) {
        return 0;
    }

    @Override
    @Deprecated
    public int read(boolean firstRead, long readCount, byte[] b, int off, int len) {
        return 0;
    }

    @Override
    @Deprecated
    public void attachThread(ProcessWrapper thread) {
    }

    @Override
    @Deprecated
    public void reset() {
    }

    @Override
    @Deprecated
    public void removeInputStream(WaitBufferedInputStream waitBufferedInputStream) {
    }

    @Override
    @Deprecated
    public void detachInputStream() {
    }
}

