/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Arrays;
import net.pms.image.ColorSpaceType;
import net.pms.image.ExifOrientation;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.util.InvalidStateException;
import net.pms.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExifInfo
extends ImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExifInfo.class);
    protected final PhotometricInterpretation photometricInterpretation;
    protected final ExifOrientation exifOrientation;
    protected final ExifOrientation originalExifOrientation;
    protected final Integer exifVersion;
    protected final ExifCompression exifCompression;
    protected final ExifColorSpace exifColorSpace;
    protected final Boolean hasExifThumbnail;

    protected ExifInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
        this.photometricInterpretation = ((ExifParseInfo)this.parsedInfo).photometricInterpretation;
        this.exifOrientation = applyExifOrientation ? ExifOrientation.TOP_LEFT : ((ExifParseInfo)this.parsedInfo).exifOrientation;
        this.originalExifOrientation = ((ExifParseInfo)this.parsedInfo).exifOrientation;
        this.exifVersion = ((ExifParseInfo)this.parsedInfo).exifVersion;
        this.exifCompression = ((ExifParseInfo)this.parsedInfo).exifCompression;
        this.exifColorSpace = ((ExifParseInfo)this.parsedInfo).exifColorSpace;
        this.hasExifThumbnail = ((ExifParseInfo)this.parsedInfo).hasExifThumbnail;
    }

    protected ExifInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
        this.photometricInterpretation = ((ExifParseInfo)this.parsedInfo).photometricInterpretation;
        this.exifOrientation = applyExifOrientation ? ExifOrientation.TOP_LEFT : ((ExifParseInfo)this.parsedInfo).exifOrientation;
        this.originalExifOrientation = ((ExifParseInfo)this.parsedInfo).exifOrientation;
        this.exifVersion = ((ExifParseInfo)this.parsedInfo).exifVersion;
        this.exifCompression = ((ExifParseInfo)this.parsedInfo).exifCompression;
        this.exifColorSpace = ((ExifParseInfo)this.parsedInfo).exifColorSpace;
        this.hasExifThumbnail = ((ExifParseInfo)this.parsedInfo).hasExifThumbnail;
    }

    protected ExifInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
        this.photometricInterpretation = ((ExifParseInfo)this.parsedInfo).photometricInterpretation;
        this.exifOrientation = applyExifOrientation ? ExifOrientation.TOP_LEFT : ((ExifParseInfo)this.parsedInfo).exifOrientation;
        this.originalExifOrientation = ((ExifParseInfo)this.parsedInfo).exifOrientation;
        this.exifVersion = ((ExifParseInfo)this.parsedInfo).exifVersion;
        this.exifCompression = ((ExifParseInfo)this.parsedInfo).exifCompression;
        this.exifColorSpace = ((ExifParseInfo)this.parsedInfo).exifColorSpace;
        this.hasExifThumbnail = ((ExifParseInfo)this.parsedInfo).hasExifThumbnail;
    }

    protected ExifInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport, PhotometricInterpretation photometricInterpretation, ExifOrientation exifOrientation, ExifOrientation originalExifOrientation, Integer exifVersion, ExifCompression exifCompression, ExifColorSpace exifColorSpace, Boolean hasExifThumbnail) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport);
        this.photometricInterpretation = photometricInterpretation;
        this.exifOrientation = exifOrientation;
        this.originalExifOrientation = originalExifOrientation;
        this.exifVersion = exifVersion;
        this.exifCompression = exifCompression;
        this.exifColorSpace = exifColorSpace;
        this.hasExifThumbnail = hasExifThumbnail;
    }

    @Override
    protected void parseMetadata(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        ((ExifParseInfo)this.parsedInfo).hasExifThumbnail = false;
        for (Directory directory : metadata.getDirectories()) {
            Integer i;
            if (directory instanceof ExifIFD0Directory || directory instanceof ExifSubIFDDirectory) {
                byte[] bytes;
                if (directory instanceof ExifSubIFDDirectory && ((ExifSubIFDDirectory)directory).containsTag(40962) && ((ExifSubIFDDirectory)directory).containsTag(40963)) {
                    this.parsedInfo.width = ((ExifSubIFDDirectory)directory).getInteger(40962);
                    this.parsedInfo.height = ((ExifSubIFDDirectory)directory).getInteger(40963);
                } else if ((this.parsedInfo.width == null || this.parsedInfo.height == null || this.parsedInfo.width < 1 || this.parsedInfo.height < 1) && ((ExifDirectoryBase)directory).containsTag(256) && ((ExifDirectoryBase)directory).containsTag(257)) {
                    this.parsedInfo.width = ((ExifDirectoryBase)directory).getInteger(256);
                    this.parsedInfo.height = ((ExifDirectoryBase)directory).getInteger(257);
                }
                if (((ExifDirectoryBase)directory).containsTag(274) && (i = ((ExifDirectoryBase)directory).getInteger(274)) != null) {
                    ((ExifParseInfo)this.parsedInfo).exifOrientation = ExifOrientation.typeOf(i);
                }
                if (((ExifDirectoryBase)directory).containsTag(259) && ((ExifParseInfo)this.parsedInfo).exifCompression == null && (i = ((ExifDirectoryBase)directory).getInteger(259)) != null) {
                    ((ExifParseInfo)this.parsedInfo).exifCompression = ExifCompression.typeOf(i);
                }
                if (((ExifDirectoryBase)directory).containsTag(258) && ((ExifParseInfo)this.parsedInfo).exifCompression == ExifCompression.UNCOMPRESSED && (bytes = ((ExifDirectoryBase)directory).getByteArray(258)) != null && bytes.length > 0) {
                    Integer i2;
                    try {
                        i2 = ImagesUtil.getBitDepthFromArray(bytes);
                    }
                    catch (InvalidStateException e) {
                        i2 = null;
                        LOGGER.trace("Unexpected bit depth array retrieved from Exif tag: {}", (Object)Arrays.toString(bytes));
                    }
                    if (i2 != null && i2 > 0) {
                        this.parsedInfo.bitDepth = i2;
                    }
                }
                if (((ExifDirectoryBase)directory).containsTag(277) && this.parsedInfo.numComponents == null && (i = ((ExifDirectoryBase)directory).getInteger(277)) != null) {
                    this.parsedInfo.numComponents = i;
                }
                if (((ExifDirectoryBase)directory).containsTag(262) && (i = ((ExifDirectoryBase)directory).getInteger(262)) != null) {
                    ((ExifParseInfo)this.parsedInfo).photometricInterpretation = PhotometricInterpretation.typeOf(i);
                    if (((ExifParseInfo)this.parsedInfo).photometricInterpretation != null) {
                        switch (((ExifParseInfo)this.parsedInfo).photometricInterpretation) {
                            case RGB: 
                            case RGB_PALETTE: {
                                this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                                break;
                            }
                            case Y_CB_CR: {
                                this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_YCbCr;
                                break;
                            }
                            case CMYK: {
                                this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_CMYK;
                                break;
                            }
                            case CIE_LAB: 
                            case ICC_LAB: 
                            case ITU_LAB: {
                                this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_Lab;
                                break;
                            }
                            case PIXAR_LOG_LUV: {
                                this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_Luv;
                                break;
                            }
                        }
                    }
                }
                if (((ExifDirectoryBase)directory).containsTag(36864) && (bytes = ((ExifDirectoryBase)directory).getByteArray(36864)) != null) {
                    ((ExifParseInfo)this.parsedInfo).exifVersion = ImagesUtil.parseExifVersion(bytes);
                }
                if (!(directory instanceof ExifIFD0Directory) || !((ExifDirectoryBase)directory).containsTag(40961) || (i = ((ExifDirectoryBase)directory).getInteger(40961)) == null) continue;
                ((ExifParseInfo)this.parsedInfo).exifColorSpace = ExifColorSpace.typeOf(i);
                continue;
            }
            if (!(directory instanceof ExifThumbnailDirectory)) continue;
            ExifThumbnailDirectory exifThumbnailDirectory = (ExifThumbnailDirectory)directory;
            if (((ExifParseInfo)this.parsedInfo).hasExifThumbnail.booleanValue() || !exifThumbnailDirectory.containsTag(514)) continue;
            i = exifThumbnailDirectory.getInteger(514);
            ((ExifParseInfo)this.parsedInfo).hasExifThumbnail = i != null && i > 0;
        }
    }

    public ExifOrientation getOriginalExifOrientation() {
        return this.originalExifOrientation;
    }

    public PhotometricInterpretation getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public int getExifVersion() {
        return this.exifVersion != null ? this.exifVersion : Integer.MIN_VALUE;
    }

    public ExifCompression getExifCompression() {
        return this.exifCompression;
    }

    public ExifColorSpace getExifColorSpace() {
        return this.exifColorSpace;
    }

    public boolean hasExifThumbnail() {
        return this.hasExifThumbnail != null && this.hasExifThumbnail != false;
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        if (this.photometricInterpretation != null) {
            sb.append(", Photometric Interpretation = ").append((Object)this.photometricInterpretation);
        }
        if (this.exifOrientation != null) {
            sb.append(", Exif Orientation = ").append((Object)this.exifOrientation);
        }
        if (this.originalExifOrientation != null) {
            sb.append(", Original Exif Orientation = ").append((Object)this.originalExifOrientation);
        }
        if (this.exifVersion != null) {
            sb.append(", Exif Version = ").append(this.exifVersion);
        }
        if (this.exifCompression != null) {
            sb.append(", Exif Compression = ").append((Object)this.exifCompression);
        }
        if (this.exifColorSpace != null) {
            sb.append(", Exif Color Space = ").append((Object)this.exifColorSpace);
        }
        if (this.hasExifThumbnail != null) {
            sb.append(", Has Exif Thumbnail = ").append(this.hasExifThumbnail != false ? "True" : "False");
        }
    }

    protected static class ExifParseInfo
    extends ImageInfo.ParseInfo {
        PhotometricInterpretation photometricInterpretation;
        ExifOrientation exifOrientation;
        Integer exifVersion;
        ExifCompression exifCompression;
        ExifColorSpace exifColorSpace;
        Boolean hasExifThumbnail;

        protected ExifParseInfo() {
        }
    }

    public static enum PhotometricInterpretation {
        WHITE_IS_ZERO,
        BLACK_IS_ZERO,
        RGB,
        RGB_PALETTE,
        TRANSPARENCY_MASK,
        CMYK,
        Y_CB_CR,
        CIE_LAB,
        ICC_LAB,
        ITU_LAB,
        COLOR_FILTER_ARRAY,
        PIXAR_LOG_L,
        PIXAR_LOG_LUV,
        LINEAR_RAW;


        public static PhotometricInterpretation typeOf(int value) {
            return switch (value) {
                case 0 -> WHITE_IS_ZERO;
                case 1 -> BLACK_IS_ZERO;
                case 2 -> RGB;
                case 3 -> RGB_PALETTE;
                case 4 -> TRANSPARENCY_MASK;
                case 5 -> CMYK;
                case 6 -> Y_CB_CR;
                case 8 -> CIE_LAB;
                case 9 -> ICC_LAB;
                case 10 -> ITU_LAB;
                case 32803 -> COLOR_FILTER_ARRAY;
                case 32844 -> PIXAR_LOG_L;
                case 32845 -> PIXAR_LOG_LUV;
                case 34892 -> LINEAR_RAW;
                default -> null;
            };
        }
    }

    public static enum ExifCompression {
        ADOBE_DEFLATE,
        CCIRLEW,
        CCITT_1D,
        DCS,
        DEFLATE,
        IT8BL,
        IT8CTPAD,
        IT8LW,
        IT8MP,
        JBIG,
        JBIG2_TIFF_FX,
        JBIG_B_W,
        JBIG_COLOR,
        JPEG,
        JPEG_2000,
        JPEG_OLD_STYLE,
        KODAC_DCR_COMPRESSED,
        KODAK_262,
        KODAK_KDC_COMPRESSED,
        LOSSY_JPEG,
        LZW,
        MDI_BINARY_LEVEL_CODEC,
        MDI_PROGRESSIVE_TRANSFORM_CODEC,
        MDI_VECTOR,
        NEXT,
        NIKON_NEF_COMPRESSED,
        PACKBITS,
        PACKED_RAW,
        PENTAX_PEF_COMPRESSED,
        PIXAR_FILM,
        PIXAR_LOG,
        SAMSUNG_SRW_COMPRESSED,
        SAMSUNG_SRW_COMPRESSED_2,
        SGILOG,
        SGILOG24,
        SONY_ARW_COMPRESSED,
        T4_GROUP_3_FAX,
        T6_GROUP_4_FAX,
        THUNDERSCAN,
        UNCOMPRESSED;


        public static ExifCompression typeOf(int value) {
            return switch (value) {
                case 1 -> UNCOMPRESSED;
                case 2 -> CCITT_1D;
                case 3 -> T4_GROUP_3_FAX;
                case 4 -> T6_GROUP_4_FAX;
                case 5 -> LZW;
                case 6 -> JPEG_OLD_STYLE;
                case 7 -> JPEG;
                case 8 -> ADOBE_DEFLATE;
                case 9 -> JBIG_B_W;
                case 10 -> JBIG_COLOR;
                case 99 -> JPEG;
                case 262 -> KODAK_262;
                case 32766 -> NEXT;
                case Short.MAX_VALUE -> SONY_ARW_COMPRESSED;
                case 32769 -> PACKED_RAW;
                case 32770 -> SAMSUNG_SRW_COMPRESSED;
                case 32771 -> CCIRLEW;
                case 32772 -> SAMSUNG_SRW_COMPRESSED_2;
                case 32773 -> PACKBITS;
                case 32809 -> THUNDERSCAN;
                case 32867 -> KODAK_KDC_COMPRESSED;
                case 32895 -> IT8CTPAD;
                case 32896 -> IT8LW;
                case 32897 -> IT8MP;
                case 32898 -> IT8BL;
                case 32908 -> PIXAR_FILM;
                case 32909 -> PIXAR_LOG;
                case 32946 -> DEFLATE;
                case 32947 -> DCS;
                case 34661 -> JBIG;
                case 34676 -> SGILOG;
                case 34677 -> SGILOG24;
                case 34712 -> JPEG_2000;
                case 34713 -> NIKON_NEF_COMPRESSED;
                case 34715 -> JBIG2_TIFF_FX;
                case 34718 -> MDI_BINARY_LEVEL_CODEC;
                case 34719 -> MDI_PROGRESSIVE_TRANSFORM_CODEC;
                case 34720 -> MDI_VECTOR;
                case 34892 -> LOSSY_JPEG;
                case 65000 -> KODAK_KDC_COMPRESSED;
                case 65535 -> PENTAX_PEF_COMPRESSED;
                default -> null;
            };
        }
    }

    public static enum ExifColorSpace {
        SRGB(1),
        UNCALIBRATED(65535),
        UNKNOWN(0);

        private final int value;

        private ExifColorSpace(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ExifColorSpace typeOf(int value) {
            return switch (value) {
                case 1 -> SRGB;
                case 65535 -> UNCALIBRATED;
                default -> UNKNOWN;
            };
        }
    }
}

