/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.pms.image.BufferedImageFilter;

public class BufferedImageFilterChain
extends ArrayList<BufferedImageFilter> {
    private static final long serialVersionUID = 1L;

    public BufferedImageFilterChain() {
    }

    public BufferedImageFilterChain(BufferedImageFilter ... filters) {
        super(Arrays.asList(filters));
    }

    public BufferedImageFilterChain(int initialCapacity) {
        super(initialCapacity);
    }

    public BufferedImageFilterChain(Collection<? extends BufferedImageFilter> collection) {
        super(collection);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "Empty " + this.getClass().getSimpleName();
        }
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(": [");
        boolean first = true;
        int i = 1;
        for (BufferedImageFilter filter : this) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(i++).append(": ").append(filter);
        }
        sb.append("]");
        return sb.toString();
    }

    public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source) {
        return this.filter(source, null, true);
    }

    public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source, BufferedImage destination, boolean modifySource) {
        if (this.isEmpty()) {
            return new BufferedImageFilter.BufferedImageFilterResult(destination == null ? source : destination, false, destination == null);
        }
        boolean modified = false;
        boolean originalInstance = true;
        BufferedImage outputImage = source;
        for (BufferedImageFilter filter : this) {
            if (filter == null) continue;
            BufferedImageFilter.BufferedImageFilterResult result = filter.filter(outputImage, destination, modifySource);
            modified |= result.isModified();
            originalInstance &= result.isOriginalInstance();
            outputImage = result.getBufferedImage();
        }
        return new BufferedImageFilter.BufferedImageFilterResult(outputImage, modified, originalInstance);
    }
}

