/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.update;

import java.io.IOException;
import net.pms.platform.OperatingSystem;
import net.pms.util.PropertiesWrapper;
import net.pms.util.Version;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class AutoUpdaterServerProperties {
    private static final String KEY_LATEST_VERSION = "LatestVersion2";
    private static final String KEY_LATEST_VERSION_PATREON = "LatestVersionPatreon";
    private static final String KEY_PATREON_DOWNLOAD_URL = "PatreonDownloadUrl";
    private static final String DEFAULT_LATEST_VERSION = "0";
    private static final String DEFAULT_PATREON_URL = "https://www.patreon.com/c/universalmediaserver";
    private static final String KEY_DOWNLOAD_URL = "DownloadUrl2";
    private static final String DEFAULT_DOWNLOAD_URL = "";
    private final PropertiesWrapper properties = new PropertiesWrapper();
    private final OperatingSystem operatingSystem = new OperatingSystem();

    public void loadFrom(byte[] data) throws IOException {
        this.properties.clear();
        this.properties.loadFromByteArray(data);
    }

    public boolean isStateValid() {
        return this.getDownloadUrl().length() > 0 && this.getLatestVersion().isGreaterThan(new Version(DEFAULT_LATEST_VERSION));
    }

    public Version getLatestVersion() {
        return new Version(this.getStringWithDefault(KEY_LATEST_VERSION, DEFAULT_LATEST_VERSION));
    }

    public Version getLatestVersionPatreon() {
        return new Version(this.getStringWithDefault(KEY_LATEST_VERSION_PATREON, DEFAULT_LATEST_VERSION));
    }

    public String getPatreonDownloadUrl() {
        return this.getStringWithDefault(KEY_PATREON_DOWNLOAD_URL, DEFAULT_PATREON_URL);
    }

    public String getDownloadUrl() {
        return this.getStringWithDefault(KEY_DOWNLOAD_URL, DEFAULT_DOWNLOAD_URL);
    }

    private String getStringWithDefault(String key, String defaultValue) {
        String platformSpecificKey = this.getPlatformSpecificKey(key);
        if (this.properties.containsKey(platformSpecificKey)) {
            return this.properties.get(platformSpecificKey);
        }
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return defaultValue;
    }

    private String getPlatformSpecificKey(String key) {
        Object os = this.operatingSystem.toString();
        if (((String)os).startsWith("windows")) {
            os = this.operatingSystem.toString();
        } else if (((String)os).startsWith("mac")) {
            os = this.operatingSystem.getPlatformName();
            String osVersionRaw = System.getProperty("os.version");
            Version osVersion = new Version(osVersionRaw);
            boolean isMacOSPreCatalina = osVersion.isLessThan(new Version("10.15"));
            SystemInfo systemInfo = new SystemInfo();
            HardwareAbstractionLayer hardware = systemInfo.getHardware();
            CentralProcessor processor = hardware.getProcessor();
            CentralProcessor.ProcessorIdentifier processorIdentifier = processor.getProcessorIdentifier();
            String microarchitecture = processorIdentifier.getMicroarchitecture();
            if (isMacOSPreCatalina) {
                os = (String)os + "-pre10.15";
            } else if (microarchitecture.startsWith("ARM64")) {
                os = (String)os + "-arm";
            }
        }
        return key + "." + (String)os;
    }
}

