/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.umsapi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFailedLookups;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableMetadata;
import net.pms.database.MediaTableTVSeries;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.dlna.DLNAThumbnail;
import net.pms.external.JavaHttpClient;
import net.pms.gui.GuiManager;
import net.pms.media.MediaInfo;
import net.pms.media.video.metadata.ApiRatingSource;
import net.pms.media.video.metadata.ApiRatingSourceArray;
import net.pms.media.video.metadata.ApiStringArray;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import net.pms.store.MediaInfoStore;
import net.pms.store.MediaStore;
import net.pms.store.MediaStoreIds;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.FileUtil;
import net.pms.util.ImdbUtil;
import net.pms.util.SimpleThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIUtils.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String VERBOSE_UA = "Universal Media Server " + PMS.getVersion();
    private static final String API_URL = "https://api.universalmediaserver.com";
    private static final ThreadPoolExecutor BACKGROUND_EXECUTOR = new ThreadPoolExecutor(0, 5, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new SimpleThreadFactory("Lookup Metadata background worker", "Lookup Metadata background workers group", 4));
    private static final Gson GSON;
    private static String apiDataVideoVersion;
    private static String apiDataSeriesVersion;
    private static final String API_DATA_VIDEO_VERSION_LOCAL = "1";
    private static final String API_DATA_SERIES_VERSION_LOCAL = "1";
    private static String apiImageBaseURL;
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_DELAY_MS = 5000L;

    private APIUtils() {
    }

    public static String getApiDataVideoVersion() {
        if (apiDataVideoVersion == null) {
            APIUtils.setApiMetadataVersions();
        }
        return apiDataVideoVersion;
    }

    public static String getApiDataSeriesVersion() {
        if (apiDataSeriesVersion == null) {
            APIUtils.setApiMetadataVersions();
        }
        return apiDataSeriesVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApiMetadataVersions() {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            JsonObject jsonData = null;
            if (CONFIGURATION.getExternalNetwork()) {
                URL url = FileUtil.urlFrom(API_URL, "/api/subversions");
                String apiResult = APIUtils.getJson(url);
                try {
                    JsonElement element = GSON.fromJson(apiResult, JsonElement.class);
                    if (element != null && element.isJsonObject()) {
                        jsonData = element.getAsJsonObject();
                    }
                }
                catch (JsonSyntaxException e) {
                    LOGGER.debug("API Result was not JSON. Received: {}, full stack: {}", (Object)apiResult, (Object)e);
                }
            }
            if (jsonData == null || !jsonData.has("series") || !jsonData.has("video") || jsonData.has("statusCode")) {
                if (jsonData != null && jsonData.has("statusCode") && "500".equals(jsonData.get("statusCode").getAsString())) {
                    LOGGER.debug("Got a 500 error while looking for metadata subversions");
                }
                LOGGER.trace("Did not get metadata subversions, will attempt to use the database version");
                if (connection != null) {
                    apiDataSeriesVersion = MediaTableMetadata.getMetadataValue(connection, "SERIES_VERSION") + "-1";
                    apiDataVideoVersion = MediaTableMetadata.getMetadataValue(connection, "VIDEO_VERSION") + "-1";
                }
                if (apiDataSeriesVersion == null) {
                    LOGGER.trace("API versions could not be fetched from the API or the local database");
                }
                return;
            }
            apiDataSeriesVersion = jsonData.get("series").getAsString();
            apiDataVideoVersion = jsonData.get("video").getAsString();
            if (connection != null && apiDataSeriesVersion != null) {
                MediaTableMetadata.setOrUpdateMetadataValue(connection, "SERIES_VERSION", apiDataSeriesVersion);
                MediaTableMetadata.setOrUpdateMetadataValue(connection, "VIDEO_VERSION", apiDataVideoVersion);
            }
            apiDataSeriesVersion = apiDataSeriesVersion + "-1";
            apiDataVideoVersion = apiDataVideoVersion + "-1";
        }
        catch (IOException e) {
            LOGGER.trace("Error while setting API metadata versions", e);
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    public static String getApiImageBaseURL() {
        if (apiImageBaseURL == null) {
            APIUtils.setApiImageBaseURL();
        }
        return apiImageBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApiImageBaseURL() {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            JsonObject jsonData = null;
            if (CONFIGURATION.getExternalNetwork()) {
                URL url = FileUtil.urlFrom(API_URL, "/api/configuration");
                String apiResult = APIUtils.getJson(url);
                try {
                    JsonElement element = GSON.fromJson(apiResult, JsonElement.class);
                    if (element != null && element.isJsonObject()) {
                        jsonData = element.getAsJsonObject();
                    }
                }
                catch (JsonSyntaxException e) {
                    LOGGER.debug("API Result was not JSON. Received: {}, full stack: {}", (Object)apiResult, (Object)e);
                }
            }
            if (jsonData == null || !jsonData.has("imageBaseURL") || jsonData.has("statusCode")) {
                if (jsonData != null && jsonData.has("statusCode") && "500".equals(jsonData.get("statusCode").getAsString())) {
                    LOGGER.debug("Got a 500 error while looking for imageBaseURL");
                }
                LOGGER.trace("Did not get imageBaseURL, will attempt to use the database version");
                if (connection != null) {
                    apiImageBaseURL = MediaTableMetadata.getMetadataValue(connection, "IMAGE_BASE_URL");
                }
                if (apiImageBaseURL == null) {
                    LOGGER.trace("imageBaseURL could not be fetched from the API or the local database");
                }
                return;
            }
            apiImageBaseURL = jsonData.get("imageBaseURL").getAsString();
            if (connection != null && apiImageBaseURL != null) {
                MediaTableMetadata.setOrUpdateMetadataValue(connection, "IMAGE_BASE_URL", apiImageBaseURL);
            }
        }
        catch (IOException e) {
            LOGGER.trace("Error while setting imageBaseURL", e);
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    private static boolean shouldLookupAndAddMetadata() {
        if (BACKGROUND_EXECUTOR.isShutdown()) {
            LOGGER.trace("Not doing background API lookup because background executor is shutdown");
            return false;
        }
        if (!CONFIGURATION.getExternalNetwork()) {
            LOGGER.trace("Not doing background API lookup because external network is disabled");
            return false;
        }
        if (!CONFIGURATION.isUseInfoFromUmsAPI()) {
            LOGGER.trace("Not doing background API lookup because isUseInfoFromUmsAPI is disabled");
            return false;
        }
        if (!MediaDatabase.isAvailable()) {
            LOGGER.trace("Not doing background API lookup because database is closed");
            return false;
        }
        return true;
    }

    public static void backgroundLookupAndAddMetadata(File file, MediaInfo media) {
        if (!APIUtils.shouldLookupAndAddMetadata()) {
            return;
        }
        Runnable r = () -> {
            try {
                MediaStore.waitWorkers();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            if (!APIUtils.shouldLookupAndAddMetadata()) {
                return;
            }
            try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
                Double rating;
                String posterFromApi;
                JsonObject metadataFromAPI;
                boolean isTVEpisode;
                Integer tvSeriesStartYear;
                String tvEpisodeNumberFromFilename;
                Integer tvSeasonFromFilename;
                String titleSimplifiedFromFilename;
                String titleFromFilename;
                Integer year;
                MediaVideoMetadata videoMetadata;
                block48: {
                    int yearIndex;
                    if (connection == null) {
                        return;
                    }
                    if (MediaTableVideoMetadata.doesLatestApiMetadataExist(connection, file.getAbsolutePath(), file.lastModified())) {
                        LOGGER.trace("The latest metadata already exists for {}", (Object)file.getName());
                        return;
                    }
                    if (MediaTableFailedLookups.hasLookupFailedRecently(connection, file.getAbsolutePath(), true)) {
                        LOGGER.trace("Lookup recently failed for {}", (Object)file.getName());
                        return;
                    }
                    GuiManager.setSecondaryStatusLine(Messages.getString("GettingApiInfoFor") + " " + file.getName());
                    connection.setAutoCommit(false);
                    videoMetadata = media.hasVideoMetadata() ? media.getVideoMetadata() : new MediaVideoMetadata();
                    year = videoMetadata.getYear();
                    titleFromFilename = videoMetadata.getMovieOrShowName();
                    titleSimplifiedFromFilename = FileUtil.getSimplifiedShowName(titleFromFilename);
                    tvSeasonFromFilename = videoMetadata.getTvSeason();
                    tvEpisodeNumberFromFilename = videoMetadata.getTvEpisodeNumber();
                    tvSeriesStartYear = videoMetadata.getTvSeriesStartYear();
                    if (tvSeriesStartYear != null && (yearIndex = FileUtil.indexOf(Pattern.compile("\\s\\(" + tvSeriesStartYear + "\\)"), titleFromFilename)) == -1) {
                        tvSeriesStartYear = null;
                    }
                    isTVEpisode = videoMetadata.isTvEpisode();
                    try {
                        metadataFromAPI = isTVEpisode ? APIUtils.getAPIMetadata(file, titleFromFilename, tvSeriesStartYear, tvSeasonFromFilename, videoMetadata.getTvEpisodeNumberUnpadded()) : APIUtils.getAPIMetadata(file, titleFromFilename, year, null, null);
                        if (metadataFromAPI != null && !metadataFromAPI.has("statusCode")) break block48;
                        LOGGER.trace("Failed lookup for " + file.getName());
                        MediaTableFailedLookups.set(connection, file.getAbsolutePath(), metadataFromAPI != null ? metadataFromAPI.get("serverResponse").getAsString() : "", true);
                        if (isTVEpisode) {
                            APIUtils.setTVSeriesInfo(connection, titleFromFilename, tvSeriesStartYear, titleSimplifiedFromFilename, file, videoMetadata, null, null);
                        }
                        APIUtils.exitLookupAndAddMetadata(connection);
                        return;
                    }
                    catch (IOException ex) {
                        LOGGER.debug("Likely transient error", ex);
                        APIUtils.exitLookupAndAddMetadata(connection);
                        if (connection != null) {
                            connection.close();
                        }
                        return;
                    }
                }
                LOGGER.trace("Found an API match for " + file.getName());
                String typeFromAPI = metadataFromAPI.has("type") ? metadataFromAPI.get("type").getAsString() : "";
                String yearFromAPI = metadataFromAPI.has("year") ? metadataFromAPI.get("year").getAsString() : "";
                boolean isTVEpisodeFromAPI = StringUtils.isNotBlank(typeFromAPI) && typeFromAPI.equals("episode");
                String titleFromAPI = APIUtils.getStringOrNull(metadataFromAPI, "title");
                Integer tvSeasonFromAPI = FileUtil.getIntegerFromString(APIUtils.getStringOrNull(metadataFromAPI, "season"));
                Object tvEpisodeNumberFromAPI = APIUtils.getStringOrNull(metadataFromAPI, "episode");
                if (tvEpisodeNumberFromAPI != null && ((String)tvEpisodeNumberFromAPI).length() == 1) {
                    tvEpisodeNumberFromAPI = "0" + (String)tvEpisodeNumberFromAPI;
                }
                String seriesIMDbIDFromAPI = APIUtils.getStringOrNull(metadataFromAPI, "seriesIMDbID");
                Long tmdbTvIDFromAPI = APIUtils.getLongOrNull(metadataFromAPI, "tmdbTvID");
                if (isTVEpisode && !isTVEpisodeFromAPI || !isTVEpisode && isTVEpisodeFromAPI || isTVEpisode && (tvSeasonFromFilename == null || tvSeasonFromAPI == null || !tvSeasonFromFilename.equals(tvSeasonFromAPI) || StringUtils.isBlank(tvEpisodeNumberFromFilename) || StringUtils.isBlank((CharSequence)tvEpisodeNumberFromAPI) || !tvEpisodeNumberFromFilename.startsWith((String)tvEpisodeNumberFromAPI) || StringUtils.isBlank(seriesIMDbIDFromAPI) && tmdbTvIDFromAPI == null) || !isTVEpisode && year != null && StringUtils.isNotBlank(yearFromAPI) && !year.toString().equals(yearFromAPI)) {
                    LOGGER.debug("API data was different to our parsed data, not storing it.");
                    MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "Data mismatch", true);
                    LOGGER.trace("Filename data: " + String.valueOf(media));
                    LOGGER.trace("API data: " + String.valueOf(metadataFromAPI));
                    if (isTVEpisode) {
                        APIUtils.setTVSeriesInfo(connection, titleFromFilename, tvSeriesStartYear, titleSimplifiedFromFilename, file, videoMetadata, null, null);
                    }
                    APIUtils.exitLookupAndAddMetadata(connection);
                    return;
                }
                LOGGER.trace("API data matches filename data for " + file.getName());
                if (isTVEpisode) {
                    Long tvSeriesId = APIUtils.setTVSeriesInfo(connection, titleFromFilename, tvSeriesStartYear, titleSimplifiedFromFilename, file, videoMetadata, seriesIMDbIDFromAPI, tmdbTvIDFromAPI);
                    if (tvSeriesId != null && !tvSeriesId.equals(videoMetadata.getTvSeriesId())) {
                        LOGGER.trace("Replacing TvSeriesId from {} to {}", (Object)videoMetadata.getTvSeriesId(), (Object)videoMetadata);
                        videoMetadata.setTvSeriesId(tvSeriesId);
                    }
                    if (StringUtils.isNotBlank(titleFromAPI)) {
                        LOGGER.trace("Setting episode name from api: " + titleFromAPI);
                        videoMetadata.setTitle(titleFromAPI);
                    }
                    videoMetadata.setTvSeason(tvSeasonFromAPI);
                    videoMetadata.setTvEpisodeNumber((String)tvEpisodeNumberFromAPI);
                    videoMetadata.setIsTvEpisode(true);
                } else {
                    String title = StringUtils.isNotBlank(titleFromAPI) ? titleFromAPI : titleFromFilename;
                    videoMetadata.setTitle(title);
                }
                year = FileUtil.getYearFromYearString(yearFromAPI);
                videoMetadata.setYear(year);
                if (metadataFromAPI.has("tmdbID")) {
                    videoMetadata.setTmdbId(metadataFromAPI.get("tmdbID").getAsLong());
                }
                videoMetadata.setIMDbID(APIUtils.getStringOrNull(metadataFromAPI, "imdbID"));
                if (videoMetadata.getIMDbID() == null && videoMetadata.getTmdbId() == null) {
                    LOGGER.debug("API data does not contain IMDb/tmdb ID, storing the API data but do not retry now.");
                    MediaTableFailedLookups.set(connection, file.getAbsolutePath(), "IMDbID/tmdbId missing", true);
                }
                if ((posterFromApi = APIUtils.getPosterUrlFromApiInfo(APIUtils.getStringOrNull(metadataFromAPI, "poster"), APIUtils.getStringOrNull(metadataFromAPI, "posterRelativePath"))) != null) {
                    videoMetadata.setPoster(posterFromApi);
                    media.waitMediaParsing(5);
                    media.setParsing(true);
                    DLNAThumbnail thumbnail = JavaHttpClient.getThumbnail(posterFromApi);
                    if (thumbnail != null) {
                        Long thumbnailId = ThumbnailStore.getId(thumbnail);
                        media.setThumbnailSource(ThumbnailSource.TMDB);
                        media.setThumbnailId(thumbnailId);
                    }
                    media.setParsing(false);
                }
                if (metadataFromAPI.has("actors")) {
                    videoMetadata.setActors(APIUtils.getApiStringArrayFromJsonElement(metadataFromAPI.get("actors")));
                }
                videoMetadata.setAwards(APIUtils.getStringOrNull(metadataFromAPI, "awards"));
                videoMetadata.setBudget(APIUtils.getLongOrNull(metadataFromAPI, "budget"));
                videoMetadata.setCountries(APIUtils.getCountriesFromJsonElement(metadataFromAPI.get("country")));
                if (metadataFromAPI.has("credits")) {
                    videoMetadata.setCredits(metadataFromAPI.get("credits").toString());
                }
                if (metadataFromAPI.has("directors")) {
                    videoMetadata.setDirectors(metadataFromAPI.get("directors").toString());
                }
                if (metadataFromAPI.has("externalIDs")) {
                    videoMetadata.setExternalIDs(metadataFromAPI.get("externalIDs").toString());
                }
                if (metadataFromAPI.has("genres")) {
                    videoMetadata.setGenres(metadataFromAPI.get("genres").toString());
                }
                videoMetadata.setHomepage(APIUtils.getStringOrNull(metadataFromAPI, "homepage"));
                if (metadataFromAPI.has("images")) {
                    videoMetadata.setImages(metadataFromAPI.get("images").toString());
                }
                if (metadataFromAPI.has("originalLanguage")) {
                    videoMetadata.setOriginalLanguage(metadataFromAPI.get("originalLanguage").toString());
                }
                videoMetadata.setOriginalTitle(APIUtils.getStringOrNull(metadataFromAPI, "originalTitle"));
                videoMetadata.setOverview(APIUtils.getStringOrNull(metadataFromAPI, "plot"));
                if (metadataFromAPI.has("productionCompanies")) {
                    videoMetadata.setProductionCompanies(metadataFromAPI.get("productionCompanies").toString());
                }
                if (metadataFromAPI.has("productionCountries")) {
                    videoMetadata.setProductionCountries(metadataFromAPI.get("productionCountries").toString());
                }
                videoMetadata.setRated(APIUtils.getStringOrNull(metadataFromAPI, "rated"));
                if (metadataFromAPI.has("rating") && metadataFromAPI.get("rating").isJsonPrimitive() && (rating = Double.valueOf(metadataFromAPI.get("rating").getAsDouble())) != 0.0) {
                    videoMetadata.setRating(rating);
                }
                if (metadataFromAPI.get("ratings") != null) {
                    videoMetadata.setRatings(metadataFromAPI.get("ratings").toString());
                }
                videoMetadata.setReleased(APIUtils.getStringOrNull(metadataFromAPI, "released"));
                videoMetadata.setRevenue(APIUtils.getLongOrNull(metadataFromAPI, "revenue"));
                videoMetadata.setTagline(APIUtils.getStringOrNull(metadataFromAPI, "tagline"));
                videoMetadata.setVotes(APIUtils.getStringOrNull(metadataFromAPI, "votes"));
                videoMetadata.setApiVersion(APIUtils.getApiDataVideoVersion());
                media.setVideoMetadata(videoMetadata);
                LOGGER.trace("Setting database metadata for " + file.getName());
                Long fileId = MediaTableFiles.getFileId(connection, file.getAbsolutePath(), file.lastModified());
                MediaTableVideoMetadata.insertOrUpdateVideoMetadata(connection, fileId, media, true);
                MediaStoreIds.incrementUpdateIdForFilename(connection, file.getAbsolutePath());
                APIUtils.exitLookupAndAddMetadata(connection);
            }
            catch (SQLException ex) {
                LOGGER.trace("Error in API parsing:", ex);
            }
        };
        LOGGER.trace("Queuing background API lookup for {}", (Object)file.getName());
        BACKGROUND_EXECUTOR.execute(r);
    }

    private static void exitLookupAndAddMetadata(Connection connection) {
        if (connection != null) {
            try {
                connection.commit();
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOGGER.error("Error in commit in APIUtils.backgroundLookupAndAdd: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        GuiManager.setSecondaryStatusLine(null);
    }

    public static String getStringOrNull(JsonObject jsonObject, String memberName) {
        return jsonObject != null && jsonObject.has(memberName) && !jsonObject.get(memberName).isJsonNull() ? jsonObject.get(memberName).getAsString() : null;
    }

    public static Long getLongOrNull(JsonObject jsonObject, String memberName) {
        return jsonObject != null && jsonObject.has(memberName) && !jsonObject.get(memberName).isJsonNull() ? Long.valueOf(jsonObject.get(memberName).getAsLong()) : null;
    }

    private static Long setTVSeriesInfo(Connection connection, String titleFromFilename, Integer startYear, String titleSimplifiedFromFilename, File file, MediaVideoMetadata videoMetadata, String seriesIMDbIDFromAPI, Long tmdbTvIDFromAPI) {
        try {
            TvSeriesMetadata tvSeriesMetadata = null;
            if (tmdbTvIDFromAPI != null) {
                tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadataFromTmdbId(connection, tmdbTvIDFromAPI);
            }
            if (tvSeriesMetadata == null && seriesIMDbIDFromAPI != null) {
                tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadataFromImdbId(connection, seriesIMDbIDFromAPI);
            }
            if (tvSeriesMetadata != null) {
                LOGGER.trace("TV series with API data already found in database {}", (Object)tvSeriesMetadata.getTitle());
            } else {
                DLNAThumbnail thumbnail;
                Double rating;
                LOGGER.trace("API metadata for TV series {} (IMDb ID: {}, tmdbId: {}) does not already exist in the database", titleFromFilename, seriesIMDbIDFromAPI, tmdbTvIDFromAPI);
                Object failedLookupKey = titleSimplifiedFromFilename;
                if (seriesIMDbIDFromAPI != null) {
                    failedLookupKey = (String)failedLookupKey + seriesIMDbIDFromAPI;
                }
                if (tmdbTvIDFromAPI != null) {
                    failedLookupKey = (String)failedLookupKey + tmdbTvIDFromAPI;
                }
                if (MediaTableFailedLookups.hasLookupFailedRecently(connection, (String)failedLookupKey, false)) {
                    return null;
                }
                JsonObject seriesMetadataFromAPI = APIUtils.getTVSeriesInfo(titleFromFilename, seriesIMDbIDFromAPI, startYear);
                if (seriesMetadataFromAPI == null || seriesMetadataFromAPI.has("statusCode")) {
                    if (seriesMetadataFromAPI != null && seriesMetadataFromAPI.has("statusCode") && "500".equals(seriesMetadataFromAPI.get("statusCode").getAsString())) {
                        LOGGER.debug("Got a 500 error while looking for TV series with title {} and IMDb ID {}", (Object)titleFromFilename, (Object)seriesIMDbIDFromAPI);
                    } else {
                        LOGGER.trace("Did not find matching series for the episode in our API for {}", (Object)file.getName());
                        MediaTableFailedLookups.set(connection, titleSimplifiedFromFilename, "No API result - expected ", false);
                    }
                    return null;
                }
                Object title = APIUtils.getStringOrNull(seriesMetadataFromAPI, "title");
                if (startYear != null) {
                    title = (String)title + " (" + startYear + ")";
                }
                String titleSimplified = FileUtil.getSimplifiedShowName((String)title);
                String typeFromAPI = APIUtils.getStringOrNull(seriesMetadataFromAPI, "type");
                boolean isSeriesFromAPI = StringUtils.isNotBlank(typeFromAPI) && "series".equals(typeFromAPI);
                String validationFailedPrepend = "not storing the series API lookup result because ";
                if (seriesIMDbIDFromAPI == null && !titleSimplified.equalsIgnoreCase(titleSimplifiedFromFilename)) {
                    LOGGER.debug(validationFailedPrepend + "file and API TV series titles do not match. {} vs {}", (Object)titleSimplified, (Object)titleSimplifiedFromFilename);
                    MediaTableFailedLookups.set(connection, titleSimplifiedFromFilename, "Title mismatch - expected " + titleSimplifiedFromFilename + " but got " + titleSimplified, false);
                    return null;
                }
                if (!isSeriesFromAPI) {
                    LOGGER.debug(validationFailedPrepend + "we received a non-series from API");
                    MediaTableFailedLookups.set(connection, titleSimplifiedFromFilename, "Type mismatch - expected series but got " + typeFromAPI, false);
                    return null;
                }
                Long tvSeriesId = MediaTableTVSeries.set(connection, (String)title, startYear);
                if (tvSeriesId == null) {
                    LOGGER.debug("tvSeriesDatabaseId was not set, something went wrong");
                    return null;
                }
                if (startYear != null) {
                    String titleFromAPI = APIUtils.getStringOrNull(seriesMetadataFromAPI, "title") + " (" + startYear + ")";
                    seriesMetadataFromAPI.remove("title");
                    seriesMetadataFromAPI.addProperty("title", titleFromAPI);
                }
                String posterFromApi = APIUtils.getPosterUrlFromApiInfo(APIUtils.getStringOrNull(seriesMetadataFromAPI, "poster"), APIUtils.getStringOrNull(seriesMetadataFromAPI, "posterRelativePath"));
                tvSeriesMetadata = new TvSeriesMetadata();
                tvSeriesMetadata.setActors(APIUtils.getApiStringArrayFromJsonElement(seriesMetadataFromAPI.get("actors")));
                tvSeriesMetadata.setApiVersion(APIUtils.getApiDataSeriesVersion());
                tvSeriesMetadata.setAwards(APIUtils.getStringOrNull(seriesMetadataFromAPI, "awards"));
                tvSeriesMetadata.setCountries(APIUtils.getCountriesFromJsonElement(seriesMetadataFromAPI.get("country")));
                if (seriesMetadataFromAPI.has("createdBy")) {
                    tvSeriesMetadata.setCreatedBy(seriesMetadataFromAPI.get("createdBy").toString());
                }
                if (seriesMetadataFromAPI.has("credits")) {
                    tvSeriesMetadata.setCredits(seriesMetadataFromAPI.get("credits").toString());
                }
                tvSeriesMetadata.setDirectors(APIUtils.getApiStringArrayFromJsonElement(seriesMetadataFromAPI.get("directors")));
                String endYearStr = APIUtils.getStringOrNull(seriesMetadataFromAPI, "endYear");
                Integer endYear = FileUtil.getYearFromYearString(endYearStr);
                tvSeriesMetadata.setEndYear(endYear);
                if (seriesMetadataFromAPI.has("externalIDs")) {
                    tvSeriesMetadata.setExternalIDs(seriesMetadataFromAPI.get("externalIDs").toString());
                }
                tvSeriesMetadata.setFirstAirDate(APIUtils.getStringOrNull(seriesMetadataFromAPI, "firstAirDate"));
                tvSeriesMetadata.setGenres(APIUtils.getApiStringArrayFromJsonElement(seriesMetadataFromAPI.get("genres")));
                tvSeriesMetadata.setHomepage(APIUtils.getStringOrNull(seriesMetadataFromAPI, "homepage"));
                if (seriesMetadataFromAPI.has("images")) {
                    tvSeriesMetadata.setImages(seriesMetadataFromAPI.get("images").toString());
                }
                tvSeriesMetadata.setIMDbID(APIUtils.getStringOrNull(seriesMetadataFromAPI, "imdbID"));
                if (seriesMetadataFromAPI.has("inProduction")) {
                    tvSeriesMetadata.setInProduction(seriesMetadataFromAPI.get("inProduction").getAsBoolean());
                }
                tvSeriesMetadata.setLanguages(APIUtils.getApiStringArrayFromJsonElement(seriesMetadataFromAPI.get("languages")));
                tvSeriesMetadata.setLastAirDate(APIUtils.getStringOrNull(seriesMetadataFromAPI, "lastAirDate"));
                if (seriesMetadataFromAPI.has("networks")) {
                    tvSeriesMetadata.setNetworks(seriesMetadataFromAPI.get("networks").toString());
                }
                if (seriesMetadataFromAPI.has("numberOfEpisodes") && seriesMetadataFromAPI.get("numberOfEpisodes").isJsonPrimitive()) {
                    tvSeriesMetadata.setNumberOfEpisodes(seriesMetadataFromAPI.get("numberOfEpisodes").getAsDouble());
                }
                if (seriesMetadataFromAPI.has("numberOfSeasons") && seriesMetadataFromAPI.get("numberOfSeasons").isJsonPrimitive()) {
                    tvSeriesMetadata.setNumberOfSeasons(seriesMetadataFromAPI.get("numberOfSeasons").getAsDouble());
                }
                tvSeriesMetadata.setOriginCountry(APIUtils.getApiStringArrayFromJsonElement(seriesMetadataFromAPI.get("originCountry")));
                tvSeriesMetadata.setOriginalLanguage(APIUtils.getStringOrNull(seriesMetadataFromAPI, "originalLanguage"));
                tvSeriesMetadata.setOriginalTitle(APIUtils.getStringOrNull(seriesMetadataFromAPI, "originalTitle"));
                tvSeriesMetadata.setOverview(APIUtils.getStringOrNull(seriesMetadataFromAPI, "plot"));
                tvSeriesMetadata.setPoster(posterFromApi);
                if (seriesMetadataFromAPI.has("productionCompanies")) {
                    tvSeriesMetadata.setProductionCompanies(seriesMetadataFromAPI.get("productionCompanies").toString());
                }
                if (seriesMetadataFromAPI.has("productionCountries")) {
                    tvSeriesMetadata.setProductionCountries(seriesMetadataFromAPI.get("productionCountries").toString());
                }
                tvSeriesMetadata.setRated(APIUtils.getStringOrNull(seriesMetadataFromAPI, "rated"));
                if (seriesMetadataFromAPI.has("rating") && seriesMetadataFromAPI.get("rating").isJsonPrimitive() && (rating = Double.valueOf(seriesMetadataFromAPI.get("rating").getAsDouble())) != 0.0) {
                    tvSeriesMetadata.setRating(rating);
                }
                tvSeriesMetadata.setRatings(APIUtils.getApiRatingSourceArrayFromJsonElement(seriesMetadataFromAPI.get("ratings")));
                if (tvSeriesMetadata.getFirstAirDate() == null) {
                    tvSeriesMetadata.setFirstAirDate(APIUtils.getStringOrNull(seriesMetadataFromAPI, "released"));
                }
                if (seriesMetadataFromAPI.has("seasons")) {
                    tvSeriesMetadata.setSeasons(seriesMetadataFromAPI.get("seasons").toString());
                }
                tvSeriesMetadata.setSeriesType(APIUtils.getStringOrNull(seriesMetadataFromAPI, "seriesType"));
                if (seriesMetadataFromAPI.has("spokenLanguages")) {
                    tvSeriesMetadata.setSpokenLanguages(seriesMetadataFromAPI.get("spokenLanguages").toString());
                }
                String startYearStr = APIUtils.getStringOrNull(seriesMetadataFromAPI, "startYear");
                startYear = FileUtil.getYearFromYearString(startYearStr);
                tvSeriesMetadata.setStartYear(startYear);
                tvSeriesMetadata.setStatus(APIUtils.getStringOrNull(seriesMetadataFromAPI, "status"));
                tvSeriesMetadata.setTagline(APIUtils.getStringOrNull(seriesMetadataFromAPI, "tagline"));
                if (seriesMetadataFromAPI.has("tmdbID")) {
                    tvSeriesMetadata.setTmdbId(seriesMetadataFromAPI.get("tmdbID").getAsLong());
                }
                tvSeriesMetadata.setTitle(APIUtils.getStringOrNull(seriesMetadataFromAPI, "title"));
                if (seriesMetadataFromAPI.has("totalSeasons") && seriesMetadataFromAPI.get("totalSeasons").isJsonPrimitive()) {
                    tvSeriesMetadata.setTotalSeasons(seriesMetadataFromAPI.get("totalSeasons").getAsDouble());
                }
                tvSeriesMetadata.setVotes(APIUtils.getStringOrNull(seriesMetadataFromAPI, "votes"));
                if (posterFromApi != null && (thumbnail = JavaHttpClient.getThumbnail(posterFromApi)) != null) {
                    Long thumbnailId = ThumbnailStore.getIdForTvSeries(thumbnail, tvSeriesId, ThumbnailSource.TMDB);
                    tvSeriesMetadata.setThumbnailSource(ThumbnailSource.TMDB);
                    tvSeriesMetadata.setThumbnailId(thumbnailId);
                }
                MediaInfoStore.updateTvSeriesMetadata(tvSeriesMetadata, tvSeriesId);
                tvSeriesMetadata.setTvSeriesId(tvSeriesId);
            }
            if (videoMetadata != null) {
                LOGGER.trace("Setting Episode TvSeriesMetadata {}", (Object)tvSeriesMetadata.getTitle());
                if (tvSeriesMetadata.getTvSeriesId() != null) {
                    videoMetadata.setSeriesMetadata(MediaInfoStore.getTvSeriesMetadata(videoMetadata.getTvSeriesId()));
                    if (!tvSeriesMetadata.getTvSeriesId().equals(videoMetadata.getTvSeriesId())) {
                        LOGGER.trace("Replacing Episode TvSeriesId from {} to {}", (Object)videoMetadata.getTvSeriesId(), (Object)tvSeriesMetadata.getTvSeriesId());
                        videoMetadata.setTvSeriesId(tvSeriesMetadata.getTvSeriesId());
                    }
                } else {
                    videoMetadata.setSeriesMetadata(tvSeriesMetadata);
                }
                if (!tvSeriesMetadata.getTmdbId().equals(videoMetadata.getTmdbTvId())) {
                    LOGGER.trace("Replacing Episode TmdbTvId from {} to {}", (Object)videoMetadata.getTmdbTvId(), (Object)tvSeriesMetadata.getTmdbId());
                    videoMetadata.setTmdbTvId(tvSeriesMetadata.getTmdbId());
                }
            }
            return tvSeriesMetadata.getTvSeriesId();
        }
        catch (IOException e) {
            LOGGER.error("Error getting \"{}\" TV series info from API: {}", (Object)file.getName(), (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    public static JsonObject getAPIMetadata(File file, String movieOrTVSeriesTitle, Integer year, Integer season, String episode) throws IOException {
        int yearIndex;
        String imdbID = null;
        String pathString = "";
        if (file != null) {
            Path path = file.toPath();
            pathString = path.toString();
            imdbID = ImdbUtil.extractImdbId(path, false);
            if (StringUtils.isBlank(movieOrTVSeriesTitle)) {
                movieOrTVSeriesTitle = FileUtil.getFileNameWithoutExtension(file.getName());
            }
        }
        String yearRegex = "(?:19|20)\\d{2}";
        if (year != null) {
            yearRegex = year.toString();
        }
        if ((yearIndex = FileUtil.indexOf(Pattern.compile("\\s\\(" + yearRegex + "\\)"), movieOrTVSeriesTitle)) > -1) {
            movieOrTVSeriesTitle = movieOrTVSeriesTitle.substring(0, yearIndex);
        }
        if (StringUtils.isBlank(imdbID) && StringUtils.isBlank(movieOrTVSeriesTitle)) {
            LOGGER.trace("Title or IMDb ID required, we have: {} {} {} {} {}", movieOrTVSeriesTitle, year, season, episode, imdbID, pathString);
            return null;
        }
        String apiResult = APIUtils.getInfoFromAllExtractedData(movieOrTVSeriesTitle, false, year, season, episode, imdbID);
        String notFoundPartialMessage = "Metadata not found";
        if (apiResult == null || Strings.CS.contains(apiResult, notFoundPartialMessage)) {
            LOGGER.trace("No result for {}, received: {}", (Object)movieOrTVSeriesTitle, (Object)apiResult);
            return null;
        }
        JsonObject data = null;
        try {
            data = GSON.fromJson(apiResult, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.debug("API Result was not JSON. Received: {}, full stack: {}", (Object)apiResult, (Object)e);
        }
        return data;
    }

    public static JsonObject getTVSeriesInfo(String formattedName, String imdbID, Integer startYear) throws IOException {
        int startYearIndex;
        String startYearRegex = "(?:19|20)\\d{2}";
        if (startYear != null) {
            startYearRegex = startYear.toString();
        }
        if ((startYearIndex = FileUtil.indexOf(Pattern.compile("\\s\\(" + startYearRegex + "\\)"), formattedName)) > -1) {
            formattedName = formattedName.substring(0, startYearIndex);
        }
        String apiResult = APIUtils.getInfoFromAllExtractedData(formattedName, true, startYear, null, null, imdbID);
        String notFoundPartialMessage = "Metadata not found";
        if (apiResult == null || Strings.CS.contains(apiResult, notFoundPartialMessage)) {
            LOGGER.trace("No result for {}, received: {}", (Object)formattedName, (Object)apiResult);
            return null;
        }
        JsonObject data = null;
        try {
            data = GSON.fromJson(apiResult, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.debug("API Result was not JSON. Received: {}, full stack: {}", (Object)apiResult, (Object)e);
        }
        return data;
    }

    private static String getInfoFromAllExtractedData(String title, boolean isSeries, Integer year, Integer season, String episode, String imdbID) throws IOException {
        String endpoint = isSeries ? "series/v2" : "video/v2";
        ArrayList<CallSite> getParameters = new ArrayList<CallSite>();
        if (StringUtils.isNotBlank(title)) {
            title = URLEncoder.encode(title, StandardCharsets.UTF_8.toString());
            getParameters.add((CallSite)((Object)("title=" + title)));
        }
        if (year != null) {
            getParameters.add((CallSite)((Object)("year=" + year.toString())));
        }
        if (season != null) {
            getParameters.add((CallSite)((Object)("season=" + season.toString())));
        }
        if (StringUtils.isNotBlank(episode)) {
            getParameters.add((CallSite)((Object)("episode=" + episode)));
        }
        if (StringUtils.isNotBlank(imdbID)) {
            getParameters.add((CallSite)((Object)("imdbID=" + imdbID)));
        }
        if (!"en-US".equals(CONFIGURATION.getLanguageTag())) {
            getParameters.add((CallSite)((Object)("language=" + CONFIGURATION.getLanguageTag())));
        }
        String getParametersJoined = StringUtils.join(getParameters, "&");
        URL url = FileUtil.urlFrom(API_URL, "/api/media/" + endpoint + "?" + getParametersJoined);
        if (isSeries) {
            LOGGER.trace("Getting API data for series from: {}", (Object)url);
        } else {
            LOGGER.trace("Getting API data for video from: {}", (Object)url);
        }
        return APIUtils.getJson(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJson(URL url) throws IOException {
        HttpURLConnection connection = null;
        int retries = 0;
        while (retries < 3) {
            block50: {
                try {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setAllowUserInteraction(false);
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setRequestProperty("Content-length", "0");
                    connection.setRequestProperty("User-Agent", VERBOSE_UA);
                    connection.setConnectTimeout(30000);
                    connection.setReadTimeout(30000);
                    connection.connect();
                    int status = connection.getResponseCode();
                    switch (status) {
                        case 200: 
                        case 201: {
                            StringBuilder sb = new StringBuilder();
                            try (InputStreamReader instream = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
                                 BufferedReader br = new BufferedReader(instream);){
                                String line;
                                while ((line = br.readLine()) != null) {
                                    sb.append(line.trim()).append("\n");
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("API lookup error for {}, {}", (Object)connection.getURL(), (Object)e.getMessage());
                            }
                            String e = sb.toString().trim();
                            return e;
                        }
                    }
                    if (++retries != 3) break block50;
                    StringBuilder errorMessage = new StringBuilder();
                    if (connection.getErrorStream() != null) {
                        try (InputStreamReader instream = new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8);
                             BufferedReader br = new BufferedReader(instream);){
                            String line;
                            while ((line = br.readLine()) != null) {
                                errorMessage.append(line.trim()).append("\n");
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("API lookup error for {}, {}", (Object)connection.getURL(), (Object)e.getMessage());
                        }
                    }
                    LOGGER.debug("API status was {} for {}, {}", status, errorMessage, connection.getURL());
                    String string = "{ statusCode: \"" + status + "\", serverResponse: " + GSON.toJson(errorMessage) + " }";
                    return string;
                }
                catch (IOException e) {
                    LOGGER.debug("Error with HttpURLConnection: {}", e);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.disconnect();
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error while disconnecting connection: {}", ex);
                        }
                    }
                }
            }
            if (retries >= 3) continue;
            try {
                LOGGER.debug("Retrying API request in {} seconds...", (Object)5L);
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOGGER.error("Retry delay interrupted");
                break;
            }
        }
        return null;
    }

    private static String getPosterUrlFromApiInfo(String posterFromApi, String posterRelativePathFromApi) {
        if (posterRelativePathFromApi != null) {
            return APIUtils.getApiImageBaseURL() + "w500" + posterRelativePathFromApi;
        }
        return posterFromApi;
    }

    private static ApiStringArray getCountriesFromJsonElement(JsonElement countries) {
        ApiStringArray result;
        block4: {
            String[] countriesSplitted;
            block3: {
                if (countries == null) {
                    return null;
                }
                result = new ApiStringArray();
                if (!countries.isJsonArray()) break block3;
                Iterator<JsonElement> i = countries.getAsJsonArray().iterator();
                while (i.hasNext()) {
                    String country = i.next().getAsString();
                    result.add(country);
                }
                break block4;
            }
            if (!countries.isJsonPrimitive()) break block4;
            String malformedCountries = countries.getAsString();
            for (String country : countriesSplitted = malformedCountries.split(",")) {
                result.add(country.trim());
            }
        }
        return result;
    }

    private static ApiStringArray getApiStringArrayFromJsonElement(JsonElement element) {
        if (element == null || !element.isJsonArray()) {
            return null;
        }
        ApiStringArray result = new ApiStringArray();
        Iterator<JsonElement> i = element.getAsJsonArray().iterator();
        while (i.hasNext()) {
            String country = i.next().getAsString();
            result.add(country);
        }
        return result;
    }

    private static ApiRatingSourceArray getApiRatingSourceArrayFromJsonElement(JsonElement element) {
        if (element == null || !element.isJsonArray()) {
            return null;
        }
        ApiRatingSourceArray result = new ApiRatingSourceArray();
        Iterator<JsonElement> i = element.getAsJsonArray().iterator();
        while (i.hasNext()) {
            JsonObject rating = i.next().getAsJsonObject();
            if (!rating.has("Source")) continue;
            String source = rating.get("Source").getAsString();
            String value = rating.has("Value") ? rating.get("Value").getAsString() : null;
            ApiRatingSource ratingSource = new ApiRatingSource();
            ratingSource.setSource(source);
            ratingSource.setValue(value);
            result.add(ratingSource);
        }
        return result;
    }

    public static synchronized VideoMetadataLocalized getVideoMetadataLocalizedFromImdb(String language, String mediaType, String imdbId, Long tmdbId, Integer season, String episode) {
        VideoMetadataLocalized metadata = null;
        if (StringUtils.isNotBlank(language) && StringUtils.isNotBlank(mediaType) && (StringUtils.isNotBlank(imdbId) || tmdbId != null && tmdbId > 0L) && CONFIGURATION.getExternalNetwork()) {
            String apiResult = null;
            try {
                ArrayList<CallSite> getParameters = new ArrayList<CallSite>();
                getParameters.add((CallSite)((Object)("language=" + URLEncoder.encode(language, StandardCharsets.UTF_8.toString()))));
                getParameters.add((CallSite)((Object)("mediaType=" + URLEncoder.encode(mediaType, StandardCharsets.UTF_8.toString()))));
                if (StringUtils.isNotBlank(imdbId)) {
                    getParameters.add((CallSite)((Object)("imdbID=" + URLEncoder.encode(imdbId, StandardCharsets.UTF_8.toString()))));
                }
                if (tmdbId != null && tmdbId > 0L) {
                    getParameters.add((CallSite)((Object)("tmdbID=" + tmdbId)));
                }
                if (season != null) {
                    getParameters.add((CallSite)((Object)("season=" + URLEncoder.encode(season.toString(), StandardCharsets.UTF_8.toString()))));
                }
                if (StringUtils.isNotBlank(episode)) {
                    getParameters.add((CallSite)((Object)("episode=" + URLEncoder.encode(episode, StandardCharsets.UTF_8.toString()))));
                }
                String getParametersJoined = StringUtils.join(getParameters, "&");
                URL url = FileUtil.urlFrom(API_URL, "/api/media/localize?" + getParametersJoined);
                LOGGER.trace("Getting API data from: {}", (Object)url);
                apiResult = APIUtils.getJson(url);
                JsonObject localizedMetadataFromAPI = GSON.fromJson(apiResult, JsonObject.class);
                if (localizedMetadataFromAPI == null || localizedMetadataFromAPI.has("statusCode")) {
                    if (localizedMetadataFromAPI != null && localizedMetadataFromAPI.has("statusCode") && "500".equals(localizedMetadataFromAPI.get("statusCode").getAsString())) {
                        LOGGER.debug("Got a 500 error while looking for localized metadata with language {} and url {}", (Object)language, (Object)url);
                    } else {
                        LOGGER.trace("Did not find matching localized metadata with language {} and url {}", (Object)language, (Object)url);
                    }
                    return null;
                }
                metadata = new VideoMetadataLocalized();
                if (localizedMetadataFromAPI.has("homepage") && localizedMetadataFromAPI.get("homepage").isJsonPrimitive()) {
                    metadata.setHomepage(localizedMetadataFromAPI.get("homepage").getAsString());
                }
                if (localizedMetadataFromAPI.has("overview") && localizedMetadataFromAPI.get("overview").isJsonPrimitive()) {
                    metadata.setOverview(localizedMetadataFromAPI.get("overview").getAsString());
                }
                if (localizedMetadataFromAPI.has("posterRelativePath") && localizedMetadataFromAPI.get("posterRelativePath").isJsonPrimitive()) {
                    metadata.setPoster(APIUtils.getPosterUrlFromApiInfo(null, localizedMetadataFromAPI.get("posterRelativePath").getAsString()));
                }
                if (localizedMetadataFromAPI.has("tagline") && localizedMetadataFromAPI.get("tagline").isJsonPrimitive()) {
                    metadata.setTagline(localizedMetadataFromAPI.get("tagline").getAsString());
                }
                if (localizedMetadataFromAPI.has("title") && localizedMetadataFromAPI.get("title").isJsonPrimitive()) {
                    metadata.setTitle(localizedMetadataFromAPI.get("title").getAsString());
                }
                if (localizedMetadataFromAPI.has("tmdbID") && localizedMetadataFromAPI.get("tmdbID").isJsonPrimitive()) {
                    metadata.setTmdbID(localizedMetadataFromAPI.get("tmdbID").getAsLong());
                }
            }
            catch (JsonSyntaxException ex) {
                LOGGER.debug("API Result was not JSON. Received: {}, full stack: {}", (Object)apiResult, (Object)ex);
            }
            catch (IOException ex) {
                LOGGER.trace("Error while getting Localized metadata with language {}", (Object)language);
            }
        }
        return metadata;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("Api Utils Executor Shutdown Hook"){

            @Override
            public void run() {
                BACKGROUND_EXECUTOR.shutdownNow();
            }
        });
        GSON = new Gson();
        apiDataVideoVersion = null;
        apiDataSeriesVersion = null;
        apiImageBaseURL = null;
    }
}

