/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.musicbrainz.api;

import net.pms.external.musicbrainz.api.MusicBrainzUtil;
import org.apache.commons.lang3.StringUtils;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;

public class MusicBrainzTagInfo {
    public final String album;
    public final String artist;
    public final String title;
    public final String year;
    public final String artistId;
    public final String trackId;

    public MusicBrainzTagInfo(Tag tag) {
        this.album = MusicBrainzUtil.tagSupportsFieldKey(tag, FieldKey.ALBUM) ? tag.getFirst(FieldKey.ALBUM) : null;
        this.artist = MusicBrainzUtil.tagSupportsFieldKey(tag, FieldKey.ARTIST) ? tag.getFirst(FieldKey.ARTIST) : null;
        this.title = MusicBrainzUtil.tagSupportsFieldKey(tag, FieldKey.TITLE) ? tag.getFirst(FieldKey.TITLE) : null;
        this.year = MusicBrainzUtil.tagSupportsFieldKey(tag, FieldKey.YEAR) ? tag.getFirst(FieldKey.YEAR) : null;
        this.artistId = MusicBrainzUtil.tagSupportsFieldKey(tag, FieldKey.MUSICBRAINZ_ARTISTID) ? tag.getFirst(FieldKey.MUSICBRAINZ_ARTISTID) : null;
        this.trackId = MusicBrainzUtil.tagSupportsFieldKey(tag, FieldKey.MUSICBRAINZ_TRACK_ID) ? tag.getFirst(FieldKey.MUSICBRAINZ_TRACK_ID) : null;
    }

    public boolean hasInfo() {
        return StringUtils.isNotBlank(this.album) || StringUtils.isNotBlank(this.artist) || StringUtils.isNotBlank(this.title) || StringUtils.isNotBlank(this.year) || StringUtils.isNotBlank(this.artistId) || StringUtils.isNotBlank(this.trackId);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotBlank(this.artist)) {
            result.append(this.artist);
        }
        if (StringUtils.isNotBlank(this.artistId)) {
            if (result.length() > 0) {
                result.append(" (").append(this.artistId).append(')');
            } else {
                result.append(this.artistId);
            }
        }
        if (result.length() > 0 && (StringUtils.isNotBlank(this.title) || StringUtils.isNotBlank(this.album) || StringUtils.isNotBlank(this.trackId))) {
            result.append(" - ");
        }
        if (StringUtils.isNotBlank(this.album)) {
            result.append(this.album);
            if (StringUtils.isNotBlank(this.title) || StringUtils.isNotBlank(this.trackId)) {
                result.append(": ");
            }
        }
        if (StringUtils.isNotBlank(this.title)) {
            result.append(this.title);
            if (StringUtils.isNotBlank(this.trackId)) {
                result.append(" (").append(this.trackId).append(')');
            }
        } else if (StringUtils.isNotBlank(this.trackId)) {
            result.append(this.trackId);
        }
        if (StringUtils.isNotBlank(this.year)) {
            if (result.length() > 0) {
                result.append(" (").append(this.year).append(')');
            } else {
                result.append(this.year);
            }
        }
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.album == null ? 0 : this.album.hashCode());
        result = 31 * result + (this.artist == null ? 0 : this.artist.hashCode());
        result = 31 * result + (this.artistId == null ? 0 : this.artistId.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.trackId == null ? 0 : this.trackId.hashCode());
        result = 31 * result + (this.year == null ? 0 : this.year.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MusicBrainzTagInfo)) {
            return false;
        }
        MusicBrainzTagInfo other = (MusicBrainzTagInfo)obj;
        if (this.album == null ? other.album != null : !this.album.equals(other.album)) {
            return false;
        }
        if (this.artist == null ? other.artist != null : !this.artist.equals(other.artist)) {
            return false;
        }
        if (this.artistId == null ? other.artistId != null : !this.artistId.equals(other.artistId)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.trackId == null ? other.trackId != null : !this.trackId.equals(other.trackId)) {
            return false;
        }
        return !(this.year == null ? other.year != null : !this.year.equals(other.year));
    }
}

