/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import java.io.IOException;
import java.util.ArrayList;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFMpegVideo;
import net.pms.encoders.StandardEngineId;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.media.MediaInfo;
import net.pms.platform.PlatformUtils;
import net.pms.store.StoreItem;
import net.pms.util.PlayerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeDl
extends FFMpegVideo {
    private static final Logger LOGGER = LoggerFactory.getLogger(YoutubeDl.class);
    public static final EngineId ID = StandardEngineId.YOUTUBE_DL;
    public static final String KEY_FFMPEG_WEB_EXECUTABLE_TYPE = "ffmpeg_web_executable_type";
    public static final String NAME = "youtube-dl";

    YoutubeDl() {
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_FFMPEG_WEB_EXECUTABLE_TYPE;
    }

    @Override
    public int purpose() {
        return 2;
    }

    @Override
    public boolean isTimeSeekable() {
        return false;
    }

    @Override
    public synchronized ProcessWrapper launchTranscode(StoreItem resource, MediaInfo media, OutputParams params) throws IOException {
        params.setMinBufferSize(params.getMinFileSize());
        params.setSecondReadMinSize(100000);
        UmsConfiguration configuration = params.getMediaRenderer().getUmsConfiguration();
        String filename = resource.getFileName();
        YoutubeDl.setAudioAndSubs(resource, params);
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(configuration.getYoutubeDlPath());
        if (params.getTimeSeek() > 0.0) {
            cmdList.add("-ss");
            cmdList.add("" + (int)params.getTimeSeek());
        }
        cmdList.add("--verbose");
        cmdList.add("--hls-use-mpegts");
        IPipeProcess pipe = null;
        boolean directPipe = Platform.isWindows();
        if (directPipe) {
            cmdList.add("-o");
            cmdList.add("-");
            params.setInputPipes(new IPipeProcess[2]);
        } else {
            String fifoName = String.format("youtubedl_%d_%d", Thread.currentThread().getId(), System.currentTimeMillis());
            params.getInputPipes()[0] = pipe = PlatformUtils.INSTANCE.getPipeProcess(fifoName, new String[0]);
            cmdList.add("-o");
            cmdList.add(pipe.getInputPipe());
        }
        cmdList.add(filename);
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        if (!directPipe) {
            ProcessWrapper mkfifoProcess = pipe.getPipeProcess();
            pw.attachProcess(mkfifoProcess);
            mkfifoProcess.runInSameThread();
            pipe.deleteLater();
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for named pipe to be created", e);
            Thread.currentThread().interrupt();
        }
        pw.runInNewThread();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for transcode to start", e);
            Thread.currentThread().interrupt();
        }
        return pw;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        return PlayerUtil.isWebVideo(item);
    }
}

