/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.Messages;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineId;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.Format;
import net.pms.io.IPipeProcess;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SimpleProcessWrapper;
import net.pms.media.MediaInfo;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.FileUtil;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.UMSUtils;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VLCVideo
extends Engine {
    private static final Logger LOGGER = LoggerFactory.getLogger(VLCVideo.class);
    public static final EngineId ID = StandardEngineId.VLC_VIDEO;
    public static final String KEY_VLC_PATH = "vlc_path";
    public static final String KEY_VLC_EXECUTABLE_TYPE = "vlc_executable_type";
    public static final String NAME = "VLC Video";

    VLCVideo() {
        super(CONFIGURATION.getVLCPaths());
    }

    @Override
    public int purpose() {
        return 0;
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getConfigurablePathKey() {
        return KEY_VLC_PATH;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_VLC_EXECUTABLE_TYPE;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public boolean isGPUAccelerationReady() {
        return true;
    }

    @Override
    public boolean isAviSynthEngine() {
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String getMimeType() {
        return "video/transcode";
    }

    protected CodecConfig genConfig(Renderer renderer, EncodingFormat encodingFormat) {
        boolean isXboxOneWebVideo;
        CodecConfig codecConfig = new CodecConfig();
        boolean bl = isXboxOneWebVideo = renderer.isXboxOne() && this.purpose() == 2;
        if (encodingFormat.isTranscodeToWMV() && !renderer.isXbox360() || isXboxOneWebVideo) {
            codecConfig.videoCodec = "wmv2";
            codecConfig.audioCodec = "wma";
            codecConfig.container = "asf";
        } else {
            if (encodingFormat.isTranscodeToH264() || encodingFormat.isTranscodeToH265()) {
                codecConfig.videoCodec = "h264";
                codecConfig.videoRemux = true;
            } else {
                codecConfig.videoCodec = "mp2v";
            }
            codecConfig.audioCodec = encodingFormat.isTranscodeToAC3() ? "a52" : "mp4a";
            codecConfig.container = encodingFormat.isTranscodeToMPEGTS() ? "ts" : "ps";
        }
        LOGGER.trace("Using " + codecConfig.videoCodec + ", " + codecConfig.audioCodec + ", " + codecConfig.container);
        if (renderer.getUmsConfiguration().isVlcAudioSyncEnabled()) {
            codecConfig.extraTrans.put("audio-sync", "");
        }
        return codecConfig;
    }

    protected Map<String, Object> getEncodingArgs(UmsConfiguration configuration, CodecConfig codecConfig, EncodingFormat encodingFormat, OutputParams params) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("vcodec", codecConfig.videoCodec);
        args.put("acodec", codecConfig.audioCodec);
        if (!codecConfig.videoRemux) {
            args.put("vb", "4096");
        }
        if (codecConfig.audioCodec.equals("mp4a")) {
            args.put("ab", Math.min(configuration.getAudioBitrate(), 320));
        } else {
            args.put("ab", configuration.getAudioBitrate());
        }
        args.put("scale", "1.0");
        boolean isXboxOneWebVideo = params.getMediaRenderer().isXboxOne() && this.purpose() == 2;
        int channels = 2;
        if (!isXboxOneWebVideo && params.getAid() != null && params.getAid().getNumberOfChannels() > 2 && configuration.getAudioChannelCount() == 6 && !encodingFormat.isTranscodeToAC3()) {
            channels = 6;
        }
        args.put("channels", channels);
        args.put("samplerate", "48000");
        args.put("strict-rc", null);
        args.put("threads", "" + configuration.getNumberOfCpuCores());
        args.put("soverlay", null);
        args.putAll(codecConfig.extraTrans);
        return args;
    }

    private static int[] getVideoBitrateConfig(String bitrate) {
        int[] bitrates = new int[2];
        if (bitrate.contains("(") && bitrate.contains(")")) {
            bitrates[1] = Integer.parseInt(bitrate.substring(bitrate.indexOf(40) + 1, bitrate.indexOf(41)));
        }
        if (bitrate.contains("(")) {
            bitrate = bitrate.substring(0, bitrate.indexOf(40)).trim();
        }
        if (StringUtils.isBlank(bitrate)) {
            bitrate = "0";
        }
        bitrates[0] = (int)Double.parseDouble(bitrate);
        return bitrates;
    }

    private List<String> getVideoBitrateOptions(UmsConfiguration configuration, MediaInfo media, EncodingFormat encodingFormat, OutputParams params) {
        boolean isXboxOneWebVideo;
        ArrayList<String> videoBitrateOptions = new ArrayList<String>();
        int[] defaultMaxBitrates = VLCVideo.getVideoBitrateConfig(configuration.getMaximumBitrate());
        int[] rendererMaxBitrates = new int[2];
        boolean bl = isXboxOneWebVideo = params.getMediaRenderer().isXboxOne() && this.purpose() == 2;
        if (params.getMediaRenderer().getMaxVideoBitrate() > 0) {
            rendererMaxBitrates = VLCVideo.getVideoBitrateConfig(Integer.toString(params.getMediaRenderer().getMaxVideoBitrate()));
        }
        if (rendererMaxBitrates[0] > 0 && rendererMaxBitrates[0] < defaultMaxBitrates[0]) {
            LOGGER.trace("Using video bitrate limit from {} configuration ({} Mb/s) because it is lower than the general configuration bitrate limit ({} Mb/s)", params.getMediaRenderer().getRendererName(), rendererMaxBitrates[0], defaultMaxBitrates[0]);
            defaultMaxBitrates = rendererMaxBitrates;
        }
        if (params.getMediaRenderer().getCBRVideoBitrate() == 0 && params.getTimeEnd() == 0.0) {
            defaultMaxBitrates[0] = 1000 * defaultMaxBitrates[0];
            if (params.getMediaRenderer().isHalveBitrate() && !configuration.isAutomaticMaximumBitrate()) {
                defaultMaxBitrates[0] = defaultMaxBitrates[0] / 2;
            }
            int bufSize = 1835;
            boolean bitrateLevel41Limited = false;
            if (!isXboxOneWebVideo && (encodingFormat.isTranscodeToH264() || encodingFormat.isTranscodeToH265())) {
                if (params.getMediaRenderer().getH264LevelLimit() < 4.2 && defaultMaxBitrates[0] > 31250) {
                    defaultMaxBitrates[0] = 31250;
                    bitrateLevel41Limited = true;
                }
                bufSize = defaultMaxBitrates[0];
            } else {
                if (media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().isHDVideo()) {
                    bufSize = defaultMaxBitrates[0] / 3;
                }
                if (bufSize > 7000) {
                    bufSize = 7000;
                }
                if (defaultMaxBitrates[1] > 0) {
                    bufSize = defaultMaxBitrates[1];
                }
                if (params.getMediaRenderer().isDefaultVBVSize() && rendererMaxBitrates[1] == 0) {
                    bufSize = 1835;
                }
            }
            if (!bitrateLevel41Limited) {
                defaultMaxBitrates[0] = encodingFormat.isTranscodeToAAC() ? defaultMaxBitrates[0] - Math.min(configuration.getAudioBitrate(), 320) : defaultMaxBitrates[0] - configuration.getAudioBitrate();
                defaultMaxBitrates[0] = defaultMaxBitrates[0] / 1000 * 1000;
            }
            videoBitrateOptions.add("--sout-x264-vbv-bufsize");
            videoBitrateOptions.add(String.valueOf(bufSize));
            videoBitrateOptions.add("--sout-x264-vbv-maxrate");
            videoBitrateOptions.add(String.valueOf(defaultMaxBitrates[0]));
        }
        if (isXboxOneWebVideo || !encodingFormat.isTranscodeToH264() && !encodingFormat.isTranscodeToH265()) {
            String mpeg2Options = configuration.getMPEG2MainSettingsFFmpeg();
            String mpeg2OptionsRenderer = params.getMediaRenderer().getCustomFFmpegMPEG2Options();
            if (StringUtils.isNotBlank(mpeg2OptionsRenderer)) {
                mpeg2Options = mpeg2OptionsRenderer;
            } else if (configuration.isAutomaticMaximumBitrate()) {
                mpeg2Options = params.getMediaRenderer().getAutomaticVideoQuality();
            }
            if (mpeg2Options.contains("Automatic")) {
                mpeg2Options = mpeg2Options.contains("Wireless") ? (media.getWidth() > 1280 ? "--sout-x264-keyint 25 --sout-avcodec-qmin 2 --sout-avcodec-qmax 7" : (media.getWidth() > 720 ? "--sout-x264-keyint 25 --sout-avcodec-qmin 2 --sout-avcodec-qmax 5" : "--sout-x264-keyint 25 --sout-avcodec-qmin 2 --sout-avcodec-qmax 3")) : "--sout-x264-keyint 5 --sout-avcodec-qscale 1 --sout-avcodec-qmin 2 --sout-avcodec-qmax 3";
            }
            if (params.getMediaRenderer().isPS3()) {
                mpeg2Options = "--sout-x264-keyint 25 --sout-avcodec-qscale 1 --sout-avcodec-qmin 2 --sout-avcodec-qmax 3";
            }
            String[] customOptions = StringUtils.split(mpeg2Options);
            videoBitrateOptions.addAll(new ArrayList<String>(Arrays.asList(customOptions)));
        } else {
            String x264CRF = configuration.getx264ConstantRateFactor();
            if (configuration.isAutomaticMaximumBitrate()) {
                x264CRF = params.getMediaRenderer().getAutomaticVideoQuality();
            }
            if (x264CRF.contains("/*")) {
                x264CRF = x264CRF.substring(x264CRF.indexOf("/*"));
            }
            if (x264CRF.contains("Automatic")) {
                x264CRF = "16";
                if (media.getWidth() > 720 && !encodingFormat.isTranscodeToH265()) {
                    x264CRF = "19";
                }
            }
            videoBitrateOptions.add("--sout-x264-crf");
            videoBitrateOptions.add(x264CRF);
        }
        return videoBitrateOptions;
    }

    @Override
    public ProcessWrapper launchTranscode(StoreItem item, MediaInfo media, OutputParams params) throws IOException {
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        String filename = item.getFileName();
        EncodingFormat encodingFormat = item.getTranscodingSettings().getEncodingFormat();
        boolean isWindows = Platform.isWindows();
        VLCVideo.setAudioAndSubs(item, params);
        CodecConfig config = this.genConfig(renderer, encodingFormat);
        IPipeProcess tsPipe = PlatformUtils.INSTANCE.getPipeProcess("VLC" + System.currentTimeMillis() + "." + config.container, new String[0]);
        ProcessWrapper pipeProcess = tsPipe.getPipeProcess();
        pipeProcess.runInNewThread();
        tsPipe.deleteLater();
        params.getInputPipes()[0] = tsPipe;
        params.setMinBufferSize(params.getMinFileSize());
        params.setSecondReadMinSize(100000);
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(this.getExecutable());
        cmdList.add("-I");
        cmdList.add("dummy");
        if (PlatformUtils.INSTANCE.getVlcVersion() != null) {
            Version requiredVersion = new Version("2.1.4");
            if (PlatformUtils.INSTANCE.getVlcVersion().compareTo(requiredVersion) > 0) {
                if (!configuration.isGPUAcceleration()) {
                    cmdList.add("--avcodec-hw=disabled");
                    LOGGER.trace("Disabled VLC's hardware acceleration.");
                }
            } else if (!configuration.isGPUAcceleration()) {
                LOGGER.debug("Version {} of VLC is too low to handle the way we disable hardware acceleration.", (Object)PlatformUtils.INSTANCE.getVlcVersion());
            }
        }
        if (configuration.isVlcExperimentalCodecs()) {
            cmdList.add("--sout-avcodec-strict=-2");
        }
        if (isWindows) {
            cmdList.add("--dummy-quiet");
        }
        cmdList.add(filename);
        String disableSuffix = "track=-1";
        if (params.getAid() != null) {
            if (params.getAid().getLang() == null || params.getAid().getLang().equals("und")) {
                cmdList.add("--audio-track=" + params.getAid().getId());
            } else if (StringUtils.isBlank(params.getAid().getLang()) || "und".equals(params.getAid().getLang()) || "loc".equals(params.getAid().getLang())) {
                cmdList.add("--audio-track=-1");
            } else {
                cmdList.add("--audio-language=" + params.getAid().getLang());
            }
        } else {
            cmdList.add("--audio-track=-1");
        }
        if (params.getSid() != null) {
            if (params.getSid().isExternal()) {
                if (params.getSid().getExternalFile() == null) {
                    cmdList.add("--sub-" + disableSuffix);
                    LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)params.getSid().getName());
                } else if (!renderer.streamSubsForTranscodedVideo() || !renderer.isExternalSubtitlesFormatSupported(params.getSid(), item)) {
                    String externalSubtitlesFileName;
                    if (params.getSid().isExternalFileUtf16()) {
                        try {
                            File convertedSubtitles = new File(CONFIGURATION.getTempFolder(), "utf8_" + params.getSid().getName());
                            FileUtil.convertFileFromUtf16ToUtf8(params.getSid().getExternalFile(), convertedSubtitles);
                            externalSubtitlesFileName = ProcessUtil.getSystemPathName(convertedSubtitles.getAbsolutePath());
                        }
                        catch (IOException e) {
                            LOGGER.debug("Error converting file from UTF-16 to UTF-8", e);
                            externalSubtitlesFileName = ProcessUtil.getSystemPathName(params.getSid().getExternalFile());
                        }
                    } else {
                        externalSubtitlesFileName = ProcessUtil.getSystemPathName(params.getSid().getExternalFile());
                    }
                    if (externalSubtitlesFileName != null) {
                        cmdList.add("--sub-file");
                        cmdList.add(externalSubtitlesFileName);
                    }
                }
            } else if (params.getSid().getLang() != null && !params.getSid().getLang().equals("und")) {
                cmdList.add("--sub-track=" + params.getSid().getId());
            } else {
                cmdList.add("--sub-" + disableSuffix);
            }
        } else {
            cmdList.add("--sub-" + disableSuffix);
        }
        if (config.videoRemux) {
            cmdList.add("--sout-x264-preset");
            cmdList.add("superfast");
            cmdList.addAll(this.getVideoBitrateOptions(configuration, media, encodingFormat, params));
        }
        if (params.getTimeSeek() != 0.0) {
            cmdList.add("--start-time");
            cmdList.add(String.valueOf(params.getTimeSeek()));
        }
        String separator = "";
        StringBuilder encodingArgsBuilder = new StringBuilder();
        for (Map.Entry<String, Object> curEntry : this.getEncodingArgs(configuration, config, encodingFormat, params).entrySet()) {
            encodingArgsBuilder.append(separator);
            encodingArgsBuilder.append(curEntry.getKey());
            if (curEntry.getValue() != null) {
                encodingArgsBuilder.append('=');
                encodingArgsBuilder.append(curEntry.getValue());
            }
            separator = ",";
        }
        String transcodeSpec = String.format("#transcode{%s}:standard{access=file,mux=%s,dst='%s%s'}", encodingArgsBuilder.toString(), config.container, isWindows ? "\\\\" : "", tsPipe.getInputPipe());
        cmdList.add("--sout");
        cmdList.add(transcodeSpec);
        cmdList.add("vlc://quit");
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.attachProcess(pipeProcess);
        UMSUtils.sleep(150);
        pw.runInNewThread();
        return pw;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        return PlayerUtil.isVideo(item, Format.Identifier.MKV) || PlayerUtil.isVideo(item, Format.Identifier.MPG) || PlayerUtil.isVideo(item, Format.Identifier.OGG);
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isVideoFormat() && !encodingFormat.isTranscodeToHLS();
    }

    @Override
    public boolean excludeFormat(Format extension) {
        return false;
    }

    @Override
    @Nullable
    public ExecutableInfo testExecutable(@Nonnull ExecutableInfo executableInfo) {
        if (Boolean.FALSE.equals((executableInfo = this.testExecutableFile(executableInfo)).getAvailable())) {
            return executableInfo;
        }
        ExecutableInfo.ExecutableInfoBuilder result = executableInfo.modify();
        if (Platform.isWindows()) {
            if (executableInfo.getPath().isAbsolute() && executableInfo.getPath().equals(PlatformUtils.INSTANCE.getVlcPath())) {
                result.version(PlatformUtils.INSTANCE.getVlcVersion());
            }
            result.available(Boolean.TRUE);
        } else {
            String arg = "--version";
            try {
                ListProcessWrapperResult output = SimpleProcessWrapper.runProcessListOutput(30000L, 1000L, executableInfo.getPath().toString(), "--version");
                if (output.getError() != null) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + output.getError().getMessage());
                    result.available(Boolean.FALSE);
                    LOGGER.debug("\"{} {}\" failed with error: {}", executableInfo.getPath(), "--version", output.getError().getMessage());
                    return result.build();
                }
                if (output.getExitCode() == 0) {
                    Pattern pattern;
                    Matcher matcher;
                    if (!output.getOutput().isEmpty() && (matcher = (pattern = Pattern.compile("VLC version\\s+[^\\(]*\\(([^\\)]*)", 2)).matcher((CharSequence)output.getOutput().get(0))).find() && StringUtils.isNotBlank(matcher.group(1))) {
                        result.version(new Version(matcher.group(1)));
                    }
                    result.available(Boolean.TRUE);
                } else {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineNotAvailableExitCode"), this, output.getExitCode()));
                    result.available(Boolean.FALSE);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        Version version = result.version();
        if (version != null) {
            Version requiredVersion = new Version("2.0.2");
            if (version.compareTo(requiredVersion) <= 0) {
                result.errorType(ExecutableErrorType.GENERAL);
                result.errorText(String.format(Messages.getString("OnlyVersionXAboveSupported"), requiredVersion, this));
                result.available(Boolean.FALSE);
                LOGGER.warn(String.format(Messages.getRootString("OnlyVersionXAboveSupported"), requiredVersion, this));
            }
        } else if (result.available() != null && result.available().booleanValue()) {
            LOGGER.warn("Could not parse VLC version, the version might be too low (< 2.0.2)");
        }
        return result.build();
    }

    @Override
    protected boolean isSpecificTest() {
        return false;
    }

    protected static class CodecConfig {
        String videoCodec;
        String audioCodec;
        String container;
        HashMap<String, Object> extraTrans = new HashMap();
        boolean videoRemux;

        protected CodecConfig() {
        }
    }
}

