/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.pms.encoders.OptionsHashMap;
import net.pms.util.ProcessUtil;

public class FFmpegOptions
extends OptionsHashMap {
    private static final long serialVersionUID = -1283795835781170081L;
    public static final List<String> GLOBALS = List.of("-loglevel", "-v", "-report", "-max_alloc", "-y", "-n", "-stats", "-bits_per_raw_sample", "-croptop", "-cropbottom", "-cropleft", "-cropright", "-padtop", "-padbottom", "-padleft", "-padright", "-padcolor", "-vol", "-cpuflags", "-benchmark", "-benchmark_all", "-progress", "-stdin", "-timelimit", "-dump", "-hex", "-vsync", "-async", "-adrift_threshold", "-copyts", "-copytb", "-dts_delta_threshold", "-dts_error_threshold", "-xerror", "-filter_complex", "-debug_ts", "-intra", "-vdt", "-sameq", "-same_quant", "-deinterlace", "-psnr", "-vstats", "-vstats_file", "-dc", "-qphist", "-vc", "-tvstd", "-isync");
    public static final List<String> INPUT_FILE_OPTIONS = List.of("-seekable", "-chunked_post", "-headers", "-content_type", "-user-agent", "-multiple_requests", "-post_data", "-timeout", "-mime_type", "-cookies", "-rtmp_app", "-rtmp_playpath", "-srtp_out_suite", "-srtp_out_params", "-srtp_in_suite", "-srtp_in_params", "-listen", "-timeout", "-listen_timeout", "-buffer_size", "-localport", "-localaddr", "-pkt_size", "-reuse", "-ttl", "-connect", "-fifo_size", "-overrun_nonfatal", "-timeout", "-key", "-iv", "-truncate", "-playlist", "-angle", "-chapter", "-itsoffset", "-dump_attachment", "-guess_layout_max", "-re", "-loop_input", "-muxdelay", "-muxpreload");

    public void transferGlobals(List<String> list) {
        this.transferAny((List)GLOBALS, (List)list);
    }

    public void transferInputFileOptions(List<String> list) {
        Object headers;
        if (this.containsKey("-headers") && !((String)(headers = (String)this.get("-headers"))).contains("\r\n")) {
            headers = ((String)headers).replace("User-Agent: ", "\r\nUser-Agent: ").replace("Cookie: ", "\r\nCookie: ").replace("Referer: ", "\r\nReferer: ").replace("Accept: ", "\r\nAccept: ").replace("Range: ", "\r\nRange: ").replace("Connection: ", "\r\nConnection: ").replace("Content-Length: ", "\r\nContent-Length: ").replace("Content-Type: ", "\r\nContent-Type: ").trim() + "\r\n";
            this.put("-headers", headers);
        }
        this.transferAny((List)INPUT_FILE_OPTIONS, (List)list);
    }

    @Nonnull
    public static List<String> getSupportedProtocols(@Nonnull Path executable) {
        ArrayList<String> result = new ArrayList<String>();
        String output = ProcessUtil.run(executable.toString(), "-protocols");
        boolean add = false;
        boolean old = false;
        for (String line : output.split("\\s*\n\\s*")) {
            if (line.equals("Input:")) {
                add = true;
                continue;
            }
            if (line.equals("Output:")) break;
            if (add) {
                result.add(line);
                continue;
            }
            if (line.startsWith("I.. = Input")) {
                old = true;
                continue;
            }
            if (!old || !line.startsWith("I")) continue;
            result.add(line.split("\\s+")[1]);
        }
        if (result.contains("mmsh")) {
            result.add("mms");
        }
        return result;
    }
}

