/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProtocolInfoAttributeName
extends Serializable {
    public static final ProtocolInfoAttributeName NONE = new GenericProtocolInfoAttributeName("");
    public static final ProtocolInfoAttributeName WILDCARD = new GenericProtocolInfoAttributeName("*");
    public static final ProtocolInfoAttributeNameFactory FACTORY = new ProtocolInfoAttributeNameFactory();

    public String getName();

    public static class GenericProtocolInfoAttributeName
    implements ProtocolInfoAttributeName {
        private static final long serialVersionUID = 1L;
        protected final String name;

        protected GenericProtocolInfoAttributeName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ProtocolInfoAttributeNameFactory {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolInfoAttributeNameFactory.class);
        private final ReentrantReadWriteLock instanceCacheLock = new ReentrantReadWriteLock();
        private final Set<ProtocolInfoAttributeName> instanceCache = new HashSet<ProtocolInfoAttributeName>();

        protected ProtocolInfoAttributeNameFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProtocolInfoAttributeName getAttributeName(String name) {
            if (StringUtils.isBlank(name)) {
                return NONE;
            }
            if ("*".equals(name = name.trim().toUpperCase(Locale.ROOT))) {
                return WILDCARD;
            }
            for (KnownProtocolInfoAttributeName knownAttribute : KnownProtocolInfoAttributeName.values()) {
                if (!name.equals(knownAttribute.getName())) continue;
                return knownAttribute;
            }
            this.instanceCacheLock.readLock().lock();
            try {
                for (ProtocolInfoAttributeName cachedAttribute : this.instanceCache) {
                    if (!name.equals(cachedAttribute.getName())) continue;
                    ProtocolInfoAttributeName protocolInfoAttributeName = cachedAttribute;
                    return protocolInfoAttributeName;
                }
            }
            finally {
                this.instanceCacheLock.readLock().unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProtocolInfoAttributeName createAttributeName(String name) {
            ProtocolInfoAttributeName instance = this.getAttributeName(name);
            if (instance != null) {
                return instance;
            }
            name = name.trim().toUpperCase(Locale.ROOT);
            this.instanceCacheLock.writeLock().lock();
            try {
                for (ProtocolInfoAttributeName cachedAttribute : this.instanceCache) {
                    if (!name.equals(cachedAttribute.getName())) continue;
                    ProtocolInfoAttributeName protocolInfoAttributeName = cachedAttribute;
                    return protocolInfoAttributeName;
                }
                instance = new GenericProtocolInfoAttributeName(name);
                this.instanceCache.add(instance);
                LOGGER.trace("ProtocolInfoAttributeNameFactory added unknown attribute name \"{}\"", (Object)name);
                ProtocolInfoAttributeName protocolInfoAttributeName = instance;
                return protocolInfoAttributeName;
            }
            finally {
                this.instanceCacheLock.writeLock().unlock();
            }
        }
    }

    public static enum KnownProtocolInfoAttributeName implements ProtocolInfoAttributeName
    {
        DLNA_ORG_PN("DLNA.ORG_PN"),
        ARIB_OR_JP_PN("ARIB.OR.JP_PN"),
        DTV_MVP_PN("DTV_MVP_PN"),
        PANASONIC_COM_PN("PANASONIC.COM_PN"),
        MICROSOFT_COM_PN("MICROSOFT.COM_PN"),
        SHARP_COM_PN("SHARP.COM_PN"),
        SONY_COM_PN("SONY.COM_PN"),
        DLNA_ORG_OP("DLNA.ORG_OP"),
        DLNA_ORG_PS("DLNA.ORG_PS"),
        DLNA_ORG_CI("DLNA.ORG_CI"),
        DLNA_ORG_FLAGS("DLNA.ORG_FLAGS"),
        DLNA_ORG_MAXSP("DLNA.ORG_MAXSP");

        private final String name;

        private KnownProtocolInfoAttributeName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

