/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import net.pms.dlna.protocolinfo.DLNAOrgProfileName;
import net.pms.dlna.protocolinfo.DeviceProtocolInfo;
import net.pms.dlna.protocolinfo.DeviceProtocolInfoSource;
import net.pms.dlna.protocolinfo.MimeType;
import net.pms.dlna.protocolinfo.PanasonicComProfileName;
import net.pms.dlna.protocolinfo.ProtocolInfo;
import net.pms.renderers.Renderer;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.support.model.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanasonicDmpProfiles
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PanasonicDmpProfiles.class);
    public static final DeviceProtocolInfoSource<PanasonicDmpProfiles> PANASONIC_DMP = new PanasonicDmpProfileType();
    protected volatile boolean populated;
    protected final DeviceProtocolInfo deviceProtocolInfo;

    public PanasonicDmpProfiles(DeviceProtocolInfo deviceProtocolInfo) {
        if (deviceProtocolInfo == null) {
            throw new IllegalArgumentException("deviceProtocolInfo cannot be null");
        }
        this.deviceProtocolInfo = deviceProtocolInfo;
    }

    public PanasonicDmpProfiles(DeviceProtocolInfo deviceProtocolInfo, String dmpProfilesString) {
        if (deviceProtocolInfo == null) {
            throw new IllegalArgumentException("deviceProtocolInfo cannot be null");
        }
        this.deviceProtocolInfo = deviceProtocolInfo;
        this.add(dmpProfilesString);
    }

    public boolean isPopulated() {
        return this.populated;
    }

    private boolean add(String dmpProfilesString) {
        if (StringUtils.isBlank(dmpProfilesString)) {
            return false;
        }
        dmpProfilesString = dmpProfilesString.replaceFirst("\\s*X-PANASONIC-DMP-Profile:\\s*", "").trim();
        String[] elements = dmpProfilesString.trim().split("\\s+");
        TreeSet<ProtocolInfo> protocolInfoSet = new TreeSet<ProtocolInfo>();
        for (String element : elements) {
            try {
                ProtocolInfo protocolInfo = PanasonicDmpProfiles.dmpProfileToProtocolInfo(element);
                if (protocolInfo == null) continue;
                protocolInfoSet.add(protocolInfo);
            }
            catch (ParseException e) {
                LOGGER.warn("Unable to parse protocolInfo from \"{}\", this profile will not be registered: {}", (Object)element, (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        boolean result = false;
        if (!protocolInfoSet.isEmpty()) {
            result = this.deviceProtocolInfo.addAll(PANASONIC_DMP, protocolInfoSet);
        }
        this.populated |= result;
        return result;
    }

    public int size() {
        return this.deviceProtocolInfo.size(PANASONIC_DMP);
    }

    public boolean isEmpty() {
        return this.deviceProtocolInfo.isEmpty(PANASONIC_DMP);
    }

    public boolean contains(ProtocolInfo protocolInfo) {
        return this.deviceProtocolInfo.contains(PANASONIC_DMP, protocolInfo);
    }

    public ProtocolInfo[] toArray() {
        return this.deviceProtocolInfo.toArray(PANASONIC_DMP);
    }

    public boolean containsAll(Collection<ProtocolInfo> collection) {
        return this.deviceProtocolInfo.containsAll(PANASONIC_DMP, collection);
    }

    public void clear() {
        this.deviceProtocolInfo.clear(PANASONIC_DMP);
        this.populated = false;
    }

    public boolean add(ProtocolInfo protocolInfo) {
        if (this.deviceProtocolInfo.add(PANASONIC_DMP, protocolInfo)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<? extends ProtocolInfo> collection) {
        if (this.deviceProtocolInfo.addAll(PANASONIC_DMP, collection)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean remove(ProtocolInfo protocolInfo) {
        return this.deviceProtocolInfo.remove(PANASONIC_DMP, protocolInfo);
    }

    public boolean removeAll(Collection<ProtocolInfo> collection) {
        if (this.deviceProtocolInfo.removeAll(PANASONIC_DMP, collection)) {
            if (this.deviceProtocolInfo.isEmpty(PANASONIC_DMP)) {
                this.populated = false;
            }
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection<ProtocolInfo> collection) {
        if (this.deviceProtocolInfo.removeAll(collection)) {
            if (this.deviceProtocolInfo.isEmpty()) {
                this.populated = false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.deviceProtocolInfo.toString(PANASONIC_DMP, false);
    }

    public String toString(boolean debug) {
        return this.deviceProtocolInfo.toString(PANASONIC_DMP, debug);
    }

    public static void parsePanasonicDmpProfiles(String dmpProfilesString, Renderer renderer) {
        if (renderer == null) {
            return;
        }
        if (renderer.deviceProtocolInfo == null) {
            throw new IllegalStateException("Panasonic DMP profiles cannot be parsed before the renderer's deviceProtocolInfo is instantiated");
        }
        boolean added = false;
        if (renderer.panasonicDmpProfiles == null) {
            renderer.panasonicDmpProfiles = new PanasonicDmpProfiles(renderer.deviceProtocolInfo, dmpProfilesString);
            added = true;
        } else if (!renderer.panasonicDmpProfiles.isPopulated()) {
            added = renderer.panasonicDmpProfiles.add(dmpProfilesString);
        }
        if (added && LOGGER.isTraceEnabled() && !renderer.panasonicDmpProfiles.isEmpty()) {
            LOGGER.trace("Received X-PANASONIC-DMP-Profiles from \"{}\":\n\n{}", (Object)renderer.getConfName(), (Object)renderer.panasonicDmpProfiles);
        }
    }

    public static ProtocolInfo dmpProfileToProtocolInfo(String dmpProfile) throws ParseException {
        if (StringUtils.isBlank(dmpProfile)) {
            return null;
        }
        Object attribute = DLNAOrgProfileName.FACTORY.getProfileName(dmpProfile = dmpProfile.trim());
        if (attribute != null) {
            MimeType mimeType;
            if (attribute.getValue().startsWith("JPEG")) {
                mimeType = new MimeType("image", "jpeg");
            } else if (attribute.getValue().startsWith("PNG")) {
                mimeType = new MimeType("image", "png");
            } else if (attribute.getValue().startsWith("GIF")) {
                mimeType = new MimeType("image", "gif");
            } else if (attribute.getValue().startsWith("AC3")) {
                mimeType = new MimeType("audio", "vnd.dolby.dd-raw");
            } else if (attribute.getValue().startsWith("AMR")) {
                mimeType = new MimeType("audio", "3gpp");
            } else if (attribute.getValue().startsWith("LPCM")) {
                mimeType = new MimeType("audio", "L16");
            } else if (attribute.getValue().startsWith("MP2")) {
                mimeType = new MimeType("audio", "mpeg");
            } else if (attribute.getValue().startsWith("MP3")) {
                mimeType = new MimeType("audio", "mpeg");
            } else if (attribute.getValue().startsWith("AAC")) {
                mimeType = new MimeType("audio", "mp4");
            } else if (attribute.getValue().startsWith("WMA")) {
                mimeType = new MimeType("audio", "x-ms-wma");
            } else if (attribute.getValue().startsWith("MPEG4")) {
                mimeType = new MimeType("video", "mp4");
            } else if (attribute.getValue().startsWith("MPEG")) {
                mimeType = new MimeType("video", "mpeg");
            } else if (attribute.getValue().startsWith("WMV")) {
                mimeType = new MimeType("video", "x-ms-wmv");
            } else if (attribute.getValue().startsWith("VC1")) {
                mimeType = new MimeType("video", "mpeg");
            } else {
                throw new ParseException("Can't infer mime-type for \"" + String.valueOf(attribute) + "\"");
            }
            return new ProtocolInfo(Protocol.HTTP_GET, "*", mimeType, Collections.singletonMap(attribute.getName(), attribute));
        }
        attribute = PanasonicComProfileName.FACTORY.getProfileName(dmpProfile);
        if (attribute != null) {
            if (attribute instanceof PanasonicComProfileName.KnownPanasonicComProfileName) {
                MimeType mimeType;
                PanasonicComProfileName.KnownPanasonicComProfileName knownPanasonicComProfileName = (PanasonicComProfileName.KnownPanasonicComProfileName)attribute;
                switch (knownPanasonicComProfileName) {
                    case MPO_3D: {
                        mimeType = new MimeType("image", "mpo");
                        break;
                    }
                    case PV_DIVX_DIV3: 
                    case PV_DIVX_DIV4: 
                    case PV_DIVX_DIVX: 
                    case PV_DIVX_DX50: {
                        mimeType = new MimeType("video", "divx");
                        break;
                    }
                    case PV_DRM_DIVX_DIV3: 
                    case PV_DRM_DIVX_DIV4: 
                    case PV_DRM_DIVX_DIVX: 
                    case PV_DRM_DIVX_DX50: {
                        return null;
                    }
                    default: {
                        throw new ParseException("Unimplemented PANASONIC.COM_PN profile \"" + String.valueOf(attribute) + "\"");
                    }
                }
                return new ProtocolInfo(Protocol.HTTP_GET, "*", mimeType, Collections.singletonMap(attribute.getName(), attribute));
            }
            throw new ParseException("Can't infer mime-type for \"" + String.valueOf(attribute) + "\"");
        }
        LOGGER.debug("Warning: Unable to parse X-PANASONIC-DMP-Profile \"{}\"", (Object)dmpProfile);
        return null;
    }

    public static class PanasonicDmpProfileType
    extends DeviceProtocolInfoSource<PanasonicDmpProfiles> {
        private static final long serialVersionUID = 1L;

        protected PanasonicDmpProfileType() {
        }

        @Override
        public Class<PanasonicDmpProfiles> getClazz() {
            return PanasonicDmpProfiles.class;
        }

        @Override
        public String getType() {
            return "X-PANASONIC-DMP-Profile";
        }
    }
}

