/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.drew.metadata.Metadata;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import net.pms.dlna.DLNAImage;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAProfileException;
import net.pms.image.Image;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAThumbnail
extends DLNAImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(DLNAImage.class);
    private static final long serialVersionUID = 1L;

    public DLNAThumbnail(Image image, DLNAImageProfile profile, boolean copy) throws DLNAProfileException {
        super(image, profile, copy);
    }

    public DLNAThumbnail(byte[] bytes, ImageInfo imageInfo, DLNAImageProfile profile, boolean copy) throws DLNAProfileException {
        super(bytes, imageInfo, profile, copy);
    }

    public DLNAThumbnail(byte[] bytes, int width, int height, ImageFormat format, ColorModel colorModel, Metadata metadata, DLNAImageProfile profile, boolean copy) throws DLNAProfileException, ParseException {
        super(bytes, width, height, format, colorModel, metadata, profile, copy);
    }

    public DLNAThumbnail(byte[] bytes, ImageFormat format, BufferedImage bufferedImage, Metadata metadata, DLNAImageProfile profile, boolean copy) throws DLNAProfileException, ParseException {
        super(bytes, format, bufferedImage, metadata, profile, copy);
    }

    public static DLNAThumbnail toThumbnail(Image inputImage) throws IOException {
        return DLNAThumbnail.toThumbnail(inputImage, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static DLNAThumbnail toThumbnail(InputStream inputStream) throws IOException {
        return DLNAThumbnail.toThumbnail(inputStream, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static DLNAThumbnail toThumbnail(byte[] inputByteArray) throws IOException {
        return DLNAThumbnail.toThumbnail(inputByteArray, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static DLNAThumbnail toThumbnail(Image inputImage, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        if (inputImage == null) {
            return null;
        }
        return (DLNAThumbnail)ImagesUtil.transcodeImage(inputImage, outputProfile, true, padToSize, null);
    }

    public static DLNAThumbnail toThumbnail(InputStream inputStream, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return (DLNAThumbnail)ImagesUtil.transcodeImage(inputStream, outputProfile, true, padToSize, null);
    }

    public static DLNAThumbnail toThumbnail(byte[] inputByteArray, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        if (inputByteArray == null) {
            return null;
        }
        return (DLNAThumbnail)ImagesUtil.transcodeImage(inputByteArray, outputProfile, true, padToSize, null);
    }

    public static DLNAThumbnail toThumbnail(Image inputImage, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        if (inputImage == null) {
            return null;
        }
        return (DLNAThumbnail)ImagesUtil.transcodeImage(inputImage, width, height, scaleType, outputFormat, true, true, padToSize, null);
    }

    public static DLNAThumbnail toThumbnail(InputStream inputStream, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return (DLNAThumbnail)ImagesUtil.transcodeImage(inputStream, width, height, scaleType, outputFormat, true, true, padToSize, null);
    }

    public static DLNAThumbnail toThumbnail(byte[] inputByteArray, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        return (DLNAThumbnail)ImagesUtil.transcodeImage(inputByteArray, width, height, scaleType, outputFormat, true, true, padToSize, null);
    }

    public DLNAThumbnail transcode(DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        return (DLNAThumbnail)ImagesUtil.transcodeImage(this, outputProfile, true, padToSize, null);
    }

    @Override
    public DLNAThumbnail copy() {
        try {
            return new DLNAThumbnail(this.bytes, this.imageInfo, this.profile, true);
        }
        catch (DLNAProfileException e) {
            LOGGER.error("Impossible situation in DLNAImage.copy(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }
}

