/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.pms.dlna.DLNAImage;
import net.pms.dlna.DLNAImageProfile;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;

public class DLNAImageInputStream
extends ByteArrayInputStream {
    protected final ImageInfo imageInfo;
    protected final DLNAImageProfile profile;

    protected DLNAImageInputStream(DLNAImage image) {
        super(image.getBytes(false));
        this.imageInfo = image.getImageInfo();
        this.profile = image.getDLNAImageProfile();
    }

    public static DLNAImageInputStream toImageInputStream(byte[] inputByteArray) throws IOException {
        DLNAImage image = DLNAImage.toDLNAImage(inputByteArray);
        return image != null ? new DLNAImageInputStream(image) : null;
    }

    public static DLNAImageInputStream toImageInputStream(InputStream inputStream) throws IOException {
        DLNAImage image = DLNAImage.toDLNAImage(inputStream);
        return image != null ? new DLNAImageInputStream(image) : null;
    }

    public static DLNAImageInputStream toImageInputStream(byte[] inputByteArray, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        DLNAImage image = DLNAImage.toDLNAImage(inputByteArray, outputProfile, padToSize);
        return image != null ? new DLNAImageInputStream(image) : null;
    }

    public static DLNAImageInputStream toImageInputStream(InputStream inputStream, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        DLNAImage image = DLNAImage.toDLNAImage(inputStream, outputProfile, padToSize);
        return image != null ? new DLNAImageInputStream(image) : null;
    }

    public static DLNAImageInputStream toImageInputStream(byte[] inputByteArray, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        DLNAImage image = DLNAImage.toDLNAImage(inputByteArray, width, height, scaleType, outputFormat, padToSize);
        return image != null ? new DLNAImageInputStream(image) : null;
    }

    public static DLNAImageInputStream toImageInputStream(InputStream inputStream, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        DLNAImage image = DLNAImage.toDLNAImage(inputStream, width, height, scaleType, outputFormat, padToSize);
        return image != null ? new DLNAImageInputStream(image) : null;
    }

    public static DLNAImageInputStream toImageInputStream(DLNAImage image) {
        return image != null ? new DLNAImageInputStream(image) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(90);
        sb.append("DLNAImageInputStream: Format = ").append((Object)this.imageInfo.getFormat()).append(", Width = ").append(this.imageInfo.getWidth()).append(", Height = ").append(this.imageInfo.getHeight()).append(", Size = ").append(this.buf != null ? this.buf.length : 0);
        return sb.toString();
    }
}

