/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.SQLException;
import net.pms.database.Database;
import net.pms.database.UserTableGroups;
import net.pms.database.UserTableTablesVersions;
import net.pms.database.UserTableUsers;
import net.pms.swing.Splash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDatabase
extends Database {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDatabase.class);
    public static final String DATABASE_NAME = "USERS";
    private static UserDatabase instance = null;
    private static boolean tablesChecked = false;

    public UserDatabase() {
        super(DATABASE_NAME);
    }

    @Override
    void onOpening(boolean force) {
        try {
            this.checkTables(force);
        }
        catch (SQLException se) {
            LOGGER.error("Error checking tables: " + se.getMessage());
            LOGGER.trace("", se);
            this.status = Database.DatabaseStatus.CLOSED;
        }
    }

    @Override
    void onOpeningFail(boolean force) {
    }

    public final synchronized void checkTables(boolean force) throws SQLException {
        if (tablesChecked && !force) {
            LOGGER.debug("Database tables have already been checked, aborting check");
        } else {
            LOGGER.debug("Starting check of database tables");
            try (Connection connection = this.getConnection();){
                Splash.setStatusMessage("UpgradingUserDb");
                UserTableTablesVersions.checkTable(connection);
                UserTableGroups.checkTable(connection);
                UserTableUsers.checkTable(connection);
            }
            tablesChecked = true;
        }
    }

    public static synchronized UserDatabase get() {
        if (instance == null) {
            instance = new UserDatabase();
        }
        return instance;
    }

    public static synchronized void init() {
        UserDatabase.get().init(false);
    }

    public static synchronized void initForce() {
        UserDatabase.get().init(true);
    }

    public static boolean isInstantiated() {
        return instance != null;
    }

    public static boolean isAvailable() {
        return UserDatabase.isInstantiated() && instance.isOpened();
    }

    public static Connection getConnectionIfAvailable() {
        if (UserDatabase.isAvailable()) {
            try {
                return instance.getConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.close();
        }
    }

    public static synchronized void createDatabaseReportIfNeeded() {
        if (instance != null && instance.isEmbedded()) {
            instance.createDatabaseReport();
        }
    }
}

