/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.MediaInfo;
import net.pms.media.video.MediaVideo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableVideotracks
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideotracks.class);
    protected static final String TABLE_NAME = "VIDEOTRACKS";
    private static final int TABLE_VERSION = 1;
    private static final String COL_ID = "ID";
    protected static final String COL_FILEID = "FILEID";
    private static final String COL_LANG = "LANG";
    private static final String COL_STREAMID = "STREAMID";
    private static final String COL_DEFAULT_FLAG = "DEFAULT_FLAG";
    private static final String COL_FORCED_FLAG = "FORCED_FLAG";
    private static final String COL_OPTIONALID = "OPTIONALID";
    private static final String COL_WIDTH = "WIDTH";
    private static final String COL_HEIGHT = "HEIGHT";
    private static final String COL_DISPLAYASPECTRATIO = "DISPLAYASPECTRATIO";
    private static final String COL_ODISPLAYASPECTRATIO = "ODISPLAYASPECTRATIO";
    private static final String COL_CODEC = "CODEC";
    private static final String COL_FRAMERATE = "FRAMERATE";
    private static final String COL_FORMATPROFILE = "FORMATPROFILE";
    private static final String COL_FORMATLEVEL = "FORMATLEVEL";
    private static final String COL_FORMATTIER = "FORMATTIER";
    private static final String COL_MATRIXCOEFFICIENTS = "MATRIXCOEFFICIENTS";
    private static final String COL_MUXINGMODE = "MUXINGMODE";
    private static final String COL_BITDEPTH = "BITDEPTH";
    private static final String COL_REFRAMES = "REFRAMES";
    private static final String COL_HDRFORMAT = "HDRFORMAT";
    private static final String COL_HDRFORMATCOMPATIBILITY = "HDRFORMATCOMPATIBILITY";
    private static final String COL_PIXELASPECTRATIO = "PIXELASPECTRATIO";
    private static final String COL_SCANTYPE = "SCANTYPE";
    private static final String COL_SCANORDER = "SCANORDER";
    private static final String COL_MULTIVIEW_LAYOUT = "MULTIVIEW_LAYOUT";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_DURATION = "DURATION";
    private static final String COL_BITRATE = "BITRATE";
    private static final String TABLE_COL_ID = "VIDEOTRACKS.ID";
    private static final String TABLE_COL_FILEID = "VIDEOTRACKS.FILEID";
    private static final String TABLE_COL_WIDTH = "VIDEOTRACKS.WIDTH";
    private static final String TABLE_COL_HEIGHT = "VIDEOTRACKS.HEIGHT";
    private static final String SQL_GET_ALL_BY_FILEID = "SELECT * FROM VIDEOTRACKS WHERE VIDEOTRACKS.FILEID = ?";
    private static final String SQL_GET_ALL_BY_FILEID_ID = "SELECT * FROM VIDEOTRACKS WHERE VIDEOTRACKS.FILEID = ? AND VIDEOTRACKS.ID = ?";
    private static final String SQL_DELETE_BY_FILEID_ID_GREATER_OR_EQUAL = "DELETE FROM VIDEOTRACKS WHERE VIDEOTRACKS.FILEID = ? AND VIDEOTRACKS.ID >= ?";
    public static final String SQL_GET_FILEID_BY_VIDEO4K = "SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 3700 OR VIDEOTRACKS.HEIGHT > 2000";
    public static final String SQL_GET_FILEID_BY_VIDEOHD = "SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 864 OR VIDEOTRACKS.HEIGHT > 576";
    public static final String SQL_GET_FILEID_BY_VIDEOSD = "SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH < 865 AND VIDEOTRACKS.HEIGHT < 577";
    public static final String SQL_GET_FILEID_BY_IS3D = "SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE MULTIVIEW_LAYOUT != ''";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideotracks.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 1) {
                MediaTableVideotracks.upgradeTable(connection, version);
            } else if (version > 1) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableVideotracks.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
        }
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 1);
        int version = currentVersion;
        if (version < 1) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                default: 
            }
            throw new IllegalStateException(MediaTableVideotracks.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 1));
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideotracks.execute(connection, "CREATE TABLE VIDEOTRACKS (ID INTEGER NOT NULL, FILEID BIGINT NOT NULL, LANG VARCHAR, STREAMID INTEGER, OPTIONALID BIGINT, DEFAULT_FLAG BOOLEAN DEFAULT FALSE, FORCED_FLAG BOOLEAN DEFAULT FALSE, TITLE VARCHAR, WIDTH INTEGER, HEIGHT INTEGER, CODEC VARCHAR, FORMATPROFILE VARCHAR, FORMATLEVEL VARCHAR, FORMATTIER VARCHAR, DURATION DOUBLE PRECISION, BITRATE INTEGER, BITDEPTH INTEGER, FRAMERATE DOUBLE PRECISION, MATRIXCOEFFICIENTS VARCHAR, MUXINGMODE VARCHAR, HDRFORMAT VARCHAR, HDRFORMATCOMPATIBILITY VARCHAR, PIXELASPECTRATIO DOUBLE PRECISION, MULTIVIEW_LAYOUT VARCHAR, REFRAMES TINYINT, DISPLAYASPECTRATIO VARCHAR, ODISPLAYASPECTRATIO VARCHAR, SCANTYPE VARCHAR, SCANORDER VARCHAR, CONSTRAINT VIDEOTRACKS_PK PRIMARY KEY(FILEID, ID), CONSTRAINT VIDEOTRACKS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES FILES(ID) ON DELETE CASCADE)", "CREATE INDEX IF NOT EXISTS VIDEOTRACKS_WIDTH_HEIGHT_IDX ON VIDEOTRACKS(WIDTH, HEIGHT)", "CREATE INDEX IF NOT EXISTS VIDEOTRACKS_MULTIVIEW_LAYOUT_IDX ON VIDEOTRACKS(MULTIVIEW_LAYOUT)");
    }

    protected static void insertOrUpdateVideoTracks(Connection connection, long fileId, MediaInfo media) throws SQLException {
        if (connection == null || fileId < 0L || media == null || !media.hasVideoTrack()) {
            return;
        }
        int trackCount = media.getVideoTrackCount();
        try (PreparedStatement updateStatment = connection.prepareStatement(SQL_DELETE_BY_FILEID_ID_GREATER_OR_EQUAL);){
            updateStatment.setLong(1, fileId);
            updateStatment.setInt(2, trackCount);
            updateStatment.executeUpdate();
        }
        if (trackCount == 0) {
            return;
        }
        try (PreparedStatement updateStatement = connection.prepareStatement(SQL_GET_ALL_BY_FILEID_ID, 1003, 1008);){
            for (MediaVideo videoTrack : media.getVideoTracks()) {
                updateStatement.clearParameters();
                updateStatement.setLong(1, fileId);
                updateStatement.setInt(2, videoTrack.getId());
                ResultSet result = updateStatement.executeQuery();
                try {
                    boolean isCreatingNewRecord;
                    boolean bl = isCreatingNewRecord = !result.next();
                    if (isCreatingNewRecord) {
                        result.moveToInsertRow();
                        result.updateLong(COL_FILEID, fileId);
                        result.updateInt(COL_ID, videoTrack.getId());
                    }
                    MediaTableVideotracks.updateVideoTrack(result, videoTrack);
                    if (isCreatingNewRecord) {
                        result.insertRow();
                        continue;
                    }
                    result.updateRow();
                }
                finally {
                    if (result == null) continue;
                    result.close();
                }
            }
        }
    }

    private static void updateVideoTrack(ResultSet result, MediaVideo videoTrack) throws SQLException {
        result.updateString(COL_LANG, StringUtils.left(videoTrack.getLang(), 3));
        MediaTableVideotracks.updateInteger(result, COL_STREAMID, videoTrack.getStreamOrder());
        MediaTableVideotracks.updateLong(result, COL_OPTIONALID, videoTrack.getOptionalId());
        result.updateBoolean(COL_DEFAULT_FLAG, videoTrack.isDefault());
        result.updateBoolean(COL_FORCED_FLAG, videoTrack.isForced());
        result.updateInt(COL_WIDTH, videoTrack.getWidth());
        result.updateInt(COL_HEIGHT, videoTrack.getHeight());
        MediaTableVideotracks.updateDouble(result, COL_DURATION, videoTrack.getDuration());
        result.updateString(COL_DISPLAYASPECTRATIO, videoTrack.getDisplayAspectRatio());
        result.updateString(COL_ODISPLAYASPECTRATIO, videoTrack.getOriginalDisplayAspectRatio());
        MediaTableVideotracks.updateDouble(result, COL_PIXELASPECTRATIO, videoTrack.getPixelAspectRatio());
        result.updateString(COL_CODEC, videoTrack.getCodec());
        result.updateString(COL_FORMATPROFILE, videoTrack.getFormatProfile());
        result.updateString(COL_FORMATLEVEL, videoTrack.getFormatLevel());
        result.updateString(COL_FORMATTIER, videoTrack.getFormatTier());
        MediaTableVideotracks.updateDouble(result, COL_FRAMERATE, videoTrack.getFrameRate());
        result.updateInt(COL_BITRATE, videoTrack.getBitRate());
        result.updateInt(COL_BITDEPTH, videoTrack.getBitDepth());
        result.updateString(COL_MATRIXCOEFFICIENTS, videoTrack.getMatrixCoefficients());
        result.updateString(COL_MUXINGMODE, videoTrack.getMuxingMode());
        result.updateByte(COL_REFRAMES, videoTrack.getReferenceFrameCount());
        result.updateString(COL_HDRFORMAT, videoTrack.getHDRFormat());
        result.updateString(COL_HDRFORMATCOMPATIBILITY, videoTrack.getHDRFormatCompatibility());
        MediaVideo.ScanType scanType = videoTrack.getScanType();
        result.updateString(COL_SCANTYPE, scanType != null ? scanType.toString() : null);
        MediaVideo.ScanOrder scanOrder = videoTrack.getScanOrder();
        result.updateString(COL_SCANORDER, scanOrder != null ? scanOrder.toString() : null);
        result.updateString(COL_MULTIVIEW_LAYOUT, videoTrack.getMultiViewLayout());
        result.updateString(COL_TITLE, videoTrack.getTitle());
    }

    protected static List<MediaVideo> getVideoTracks(Connection connection, long fileId) {
        ArrayList<MediaVideo> result = new ArrayList<MediaVideo>();
        if (connection == null || fileId < 0L) {
            return result;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_BY_FILEID);){
            stmt.setLong(1, fileId);
            try (ResultSet resultset = stmt.executeQuery();){
                while (resultset.next()) {
                    MediaVideo videoTrack = MediaTableVideotracks.getVideoTrack(resultset);
                    LOGGER.trace("Adding video from the database: {}", (Object)videoTrack.toString());
                    result.add(videoTrack);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEOTRACKS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    private static MediaVideo getVideoTrack(ResultSet resultset) throws SQLException {
        MediaVideo result = new MediaVideo();
        result.setId(resultset.getInt(COL_ID));
        result.setLang(resultset.getString(COL_LANG));
        result.setStreamOrder(MediaTableVideotracks.toInteger(resultset, COL_STREAMID));
        result.setOptionalId(MediaTableVideotracks.toLong(resultset, COL_OPTIONALID));
        result.setDefault(resultset.getBoolean(COL_DEFAULT_FLAG));
        result.setForced(resultset.getBoolean(COL_FORCED_FLAG));
        result.setWidth(resultset.getInt(COL_WIDTH));
        result.setHeight(resultset.getInt(COL_HEIGHT));
        result.setDisplayAspectRatio(resultset.getString(COL_DISPLAYASPECTRATIO));
        result.setOriginalDisplayAspectRatio(resultset.getString(COL_ODISPLAYASPECTRATIO));
        result.setCodec(resultset.getString(COL_CODEC));
        result.setFormatProfile(resultset.getString(COL_FORMATPROFILE));
        result.setFormatLevel(resultset.getString(COL_FORMATLEVEL));
        result.setFormatTier(resultset.getString(COL_FORMATTIER));
        result.setFrameRate(MediaTableVideotracks.toDouble(resultset, COL_FRAMERATE));
        result.setMatrixCoefficients(resultset.getString(COL_MATRIXCOEFFICIENTS));
        result.setMuxingMode(resultset.getString(COL_MUXINGMODE));
        result.setBitDepth(resultset.getInt(COL_BITDEPTH));
        result.setReferenceFrameCount(resultset.getByte(COL_REFRAMES));
        result.setHDRFormat(resultset.getString(COL_HDRFORMAT));
        result.setHDRFormatCompatibility(resultset.getString(COL_HDRFORMATCOMPATIBILITY));
        result.setPixelAspectRatio(MediaTableVideotracks.toDouble(resultset, COL_PIXELASPECTRATIO));
        result.setScanType(resultset.getString(COL_SCANTYPE));
        result.setScanOrder(resultset.getString(COL_SCANORDER));
        result.setMultiViewLayout(resultset.getString(COL_MULTIVIEW_LAYOUT));
        result.setTitle(resultset.getString(COL_TITLE));
        result.setDuration(MediaTableVideotracks.toDouble(resultset, COL_DURATION));
        result.setBitRate(resultset.getInt(COL_BITRATE));
        return result;
    }
}

