/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import com.google.gson.JsonArray;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.video.metadata.ApiStringArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableVideoMetadataDirectors
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideoMetadataDirectors.class);
    public static final String TABLE_NAME = "VIDEO_METADATA_DIRECTORS";
    private static final int TABLE_VERSION = 3;
    private static final String COL_ID = "ID";
    private static final String COL_FILEID = "FILEID";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_DIRECTOR = "DIRECTOR";
    public static final String TABLE_COL_FILEID = "VIDEO_METADATA_DIRECTORS.FILEID";
    private static final String TABLE_COL_TVSERIESID = "VIDEO_METADATA_DIRECTORS.TVSERIESID";
    public static final String TABLE_COL_DIRECTOR = "VIDEO_METADATA_DIRECTORS.DIRECTOR";
    private static final String SQL_GET_DIRECTOR_FILEID = "SELECT VIDEO_METADATA_DIRECTORS.DIRECTOR FROM VIDEO_METADATA_DIRECTORS WHERE VIDEO_METADATA_DIRECTORS.FILEID = ?";
    private static final String SQL_GET_DIRECTOR_TVSERIESID = "SELECT VIDEO_METADATA_DIRECTORS.DIRECTOR FROM VIDEO_METADATA_DIRECTORS WHERE VIDEO_METADATA_DIRECTORS.TVSERIESID = ?";
    private static final String SQL_GET_ALL_FILEID = "SELECT * FROM VIDEO_METADATA_DIRECTORS WHERE VIDEO_METADATA_DIRECTORS.FILEID = ?";
    private static final String SQL_GET_ALL_TVSERIESID = "SELECT * FROM VIDEO_METADATA_DIRECTORS WHERE VIDEO_METADATA_DIRECTORS.TVSERIESID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideoMetadataDirectors.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    MediaTableVideoMetadataDirectors.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableVideoMetadataDirectors.dropTable(connection, TABLE_NAME);
                MediaTableVideoMetadataDirectors.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            MediaTableVideoMetadataDirectors.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        block4: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "DROP INDEX IF EXISTS FILENAME_DIRECTOR_TVSERIESID_IDX");
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_DIRECTORS ADD COLUMN IF NOT EXISTS FILEID INTEGER");
                    if (MediaTableVideoMetadataDirectors.isColumnExist(connection, TABLE_NAME, "FILENAME")) {
                        MediaTableVideoMetadataDirectors.executeUpdate(connection, "UPDATE VIDEO_METADATA_DIRECTORS SET FILEID=(SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = VIDEO_METADATA_DIRECTORS.FILENAME) WHERE VIDEO_METADATA_DIRECTORS.FILENAME != ''");
                        MediaTableVideoMetadataDirectors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_DIRECTORS DROP COLUMN IF EXISTS FILENAME");
                    }
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_DIRECTORS ALTER COLUMN IF EXISTS TVSERIESID DROP DEFAULT");
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "UPDATE VIDEO_METADATA_DIRECTORS SET FILEID = NULL WHERE VIDEO_METADATA_DIRECTORS.FILEID = -1");
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "UPDATE VIDEO_METADATA_DIRECTORS SET TVSERIESID = NULL WHERE VIDEO_METADATA_DIRECTORS.TVSERIESID = -1");
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_DIRECTORS ADD CONSTRAINT VIDEO_METADATA_DIRECTORS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE");
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_DIRECTORS ADD CONSTRAINT VIDEO_METADATA_DIRECTORS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE");
                    continue block4;
                }
                case 2: {
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_DIRECTORS ALTER COLUMN IF EXISTS FILEID BIGINT");
                    MediaTableVideoMetadataDirectors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_DIRECTORS ALTER COLUMN IF EXISTS TVSERIESID BIGINT");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException(MediaTableVideoMetadataDirectors.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideoMetadataDirectors.execute(connection, "CREATE TABLE VIDEO_METADATA_DIRECTORS(ID IDENTITY PRIMARY KEY, TVSERIESID BIGINT, FILEID BIGINT, DIRECTOR VARCHAR(1024) NOT NULL, CONSTRAINT VIDEO_METADATA_DIRECTORS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE, CONSTRAINT VIDEO_METADATA_DIRECTORS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE)");
    }

    public static void set(Connection connection, Long fileId, ApiStringArray directors, Long tvSeriesID) {
        long id;
        String tableColumn;
        String sqlSelect;
        if (directors == null) {
            return;
        }
        if (tvSeriesID != null) {
            sqlSelect = SQL_GET_ALL_TVSERIESID;
            tableColumn = COL_TVSERIESID;
            id = tvSeriesID;
        } else if (fileId != null) {
            sqlSelect = SQL_GET_ALL_FILEID;
            tableColumn = COL_FILEID;
            id = fileId;
        } else {
            return;
        }
        ArrayList<String> newDirectors = new ArrayList<String>(directors);
        try (PreparedStatement ps = connection.prepareStatement(sqlSelect, 1003, 1008);){
            ps.setLong(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String director = rs.getString(COL_DIRECTOR);
                    if (newDirectors.contains(director)) {
                        LOGGER.trace("Record \"{}\" already exists {} {} {}", director, tableColumn, id);
                        newDirectors.remove(director);
                        continue;
                    }
                    LOGGER.trace("Removing record \"{}\" for {} {}", director, tableColumn, id);
                    rs.deleteRow();
                }
                for (String actor : newDirectors) {
                    rs.moveToInsertRow();
                    rs.updateLong(tableColumn, id);
                    rs.updateString(COL_DIRECTOR, actor);
                    rs.insertRow();
                    LOGGER.trace("Set new entry \"{}\" successfully in VIDEO_METADATA_DIRECTORS with {} {}", actor, tableColumn, id);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, fileId, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static ApiStringArray getDirectorsForFile(Connection connection, long fileId) {
        ApiStringArray result = new ApiStringArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_DIRECTOR_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_DIRECTORS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForFile(Connection connection, long fileId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_DIRECTOR_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_DIRECTORS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static ApiStringArray getDirectorsForTvSeries(Connection connection, long tvSerieId) {
        ApiStringArray result = new ApiStringArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_DIRECTOR_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_DIRECTORS for TV serie ID \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForTvSeries(Connection connection, long tvSerieId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_DIRECTOR_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_DIRECTORS for \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }
}

