/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.external.umsapi.APIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableFailedLookups
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableFailedLookups.class);
    protected static final String TABLE_NAME = "FAILED_LOOKUPS";
    private static final int TABLE_VERSION = 3;
    private static final String COL_ID = "ID";
    private static final String COL_LASTATTEMPT = "LASTATTEMPT";
    private static final String COL_FAILUREDETAILS = "FAILUREDETAILS";
    private static final String COL_FILENAME = "FILENAME";
    private static final String COL_VERSION = "VERSION";
    private static final String TABLE_COL_LASTATTEMPT = "FAILED_LOOKUPS.LASTATTEMPT";
    private static final String TABLE_COL_FAILUREDETAILS = "FAILED_LOOKUPS.FAILUREDETAILS";
    private static final String TABLE_COL_FILENAME = "FAILED_LOOKUPS.FILENAME";
    private static final String TABLE_COL_VERSION = "FAILED_LOOKUPS.VERSION";
    private static final String SQL_GET_LASTATTEMPT = "SELECT FAILED_LOOKUPS.LASTATTEMPT FROM FAILED_LOOKUPS WHERE FAILED_LOOKUPS.FILENAME = ? LIMIT 1";
    private static final String SQL_GET_LASTATTEMPT_VERSION = "SELECT FAILED_LOOKUPS.LASTATTEMPT FROM FAILED_LOOKUPS WHERE FAILED_LOOKUPS.FILENAME = ? AND FAILED_LOOKUPS.VERSION = ? LIMIT 1";
    private static final String SQL_GET_FILENAME = "SELECT FAILED_LOOKUPS.FILENAME, FAILED_LOOKUPS.FAILUREDETAILS, FAILED_LOOKUPS.VERSION FROM FAILED_LOOKUPS WHERE FAILED_LOOKUPS.FILENAME = ? LIMIT 1";
    private static final String SQL_DELETE_FILENAME = "DELETE FROM FAILED_LOOKUPS WHERE FAILED_LOOKUPS.FILENAME = ?";
    private static final String SQL_DELETE_FILENAME_LIKE = "DELETE FROM FAILED_LOOKUPS WHERE FAILED_LOOKUPS.FILENAME LIKE STRINGENCODE(?) || '%'";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableFailedLookups.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    MediaTableFailedLookups.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableFailedLookups.dropTable(connection, TABLE_NAME);
                MediaTableFailedLookups.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            MediaTableFailedLookups.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        block13: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    try (Statement statement = connection.createStatement();){
                        if (MediaTableFailedLookups.isColumnExist(connection, TABLE_NAME, COL_VERSION)) continue block13;
                        statement.execute("ALTER TABLE FAILED_LOOKUPS ADD VERSION VARCHAR");
                        statement.execute("CREATE INDEX IF NOT EXISTS FILENAME_VERSION ON FAILED_LOOKUPS (FILENAME, VERSION)");
                        continue block13;
                    }
                    catch (SQLException e) {
                        LOGGER.error("Failed upgrading database \"{}\" table {} for {}", "medias", TABLE_NAME, e.getMessage());
                        LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
                        throw new SQLException(e);
                    }
                }
                case 2: {
                    MediaTableFailedLookups.executeUpdate(connection, "ALTER INDEX IF EXISTS FAILED_FILENAME_IDX RENAME TO FAILED_LOOKUPS_FILENAME_IDX");
                    MediaTableFailedLookups.executeUpdate(connection, "ALTER INDEX IF EXISTS FILENAME_VERSION RENAME TO FAILED_LOOKUPS_FILENAME_VERSION_IDX");
                    continue block13;
                }
                default: {
                    throw new IllegalStateException(MediaTableFailedLookups.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableFailedLookups.execute(connection, "CREATE TABLE FAILED_LOOKUPS(ID IDENTITY PRIMARY KEY, FILENAME VARCHAR(1024) NOT NULL, FAILUREDETAILS VARCHAR(20000) NOT NULL, VERSION VARCHAR(1024) NOT NULL, LASTATTEMPT TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP)", "CREATE UNIQUE INDEX FAILED_LOOKUPS_FILENAME_IDX ON FAILED_LOOKUPS(FILENAME)", "CREATE INDEX IF NOT EXISTS FAILED_LOOKUPS_FILENAME_VERSION_IDX ON FAILED_LOOKUPS (FILENAME, VERSION)");
    }

    /*
     * Exception decompiling
     */
    public static boolean hasLookupFailedRecently(Connection connection, String fullPathToFile, boolean isVideo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void set(Connection connection, String fullPathToFile, String failureDetails, boolean isVideo) {
        String latestVersion = isVideo ? APIUtils.getApiDataVideoVersion() : APIUtils.getApiDataSeriesVersion();
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_FILENAME, 1005, 1008);){
            statement.setString(1, fullPathToFile);
            LOGGER.trace("Searching for file/series in FAILED_LOOKUPS with \"{}\" before update", (Object)statement);
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    MediaTableFailedLookups.updateString(result, COL_FAILUREDETAILS, failureDetails, 20000);
                    MediaTableFailedLookups.updateString(result, COL_VERSION, latestVersion, 1024);
                    result.updateRow();
                } else {
                    result.moveToInsertRow();
                    MediaTableFailedLookups.updateString(result, COL_FILENAME, fullPathToFile, 1024);
                    MediaTableFailedLookups.updateString(result, COL_FAILUREDETAILS, failureDetails, 20000);
                    MediaTableFailedLookups.updateString(result, COL_VERSION, latestVersion, 1024);
                    result.insertRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, fullPathToFile, e.getMessage());
            LOGGER.trace("", e);
        }
        catch (Exception e) {
            LOGGER.trace("", e);
        }
    }

    public static void remove(Connection connection, String filename, boolean useLike) {
        try {
            String sql = useLike ? SQL_DELETE_FILENAME_LIKE : SQL_DELETE_FILENAME;
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, filename);
                int rows = statement.executeUpdate();
                LOGGER.trace("Removed entries {} in FAILED_LOOKUPS for filename \"{}\"", (Object)rows, (Object)filename);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "removing entries", TABLE_NAME, filename, e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

