/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHelper.class);
    private static final String ESCAPE_CHARACTER = "\\";
    protected static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    protected static final String LOG_CREATING_TABLE = "Creating database \"{}\" table: \"{}\"";
    protected static final String LOG_UPGRADING_TABLE = "Upgrading database \"{}\" table \"{}\" from version {} to {}";
    protected static final String LOG_UPGRADED_TABLE = "Updated database \"{}\" table \"{}\" from version {} to {}";
    protected static final String LOG_UPGRADING_TABLE_FAILED = "Failed upgrading database \"{}\" table {} for {}";
    protected static final String LOG_UPGRADING_TABLE_MISSING = "Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}";
    protected static final String LOG_TABLE_NEWER_VERSION = "Database \"{}\" table \"{}\" is from a newer version of UMS.";
    protected static final String LOG_TABLE_NEWER_VERSION_DELETEDB = "Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS";
    protected static final String LOG_TABLE_UNKNOWN_VERSION_RECREATE = "Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table";
    protected static final String LOG_CONNECTION_GET_ERROR = "Database \"{}\" error while getting connection: {}";
    protected static final String LOG_ERROR_WHILE_IN = "Database \"{}\" error while {} in \"{}\": {}";
    protected static final String LOG_ERROR_WHILE_VAR_IN = "Database \"{}\" error while {} \"{}\" in \"{}\": {}";
    protected static final String LOG_ERROR_WHILE_VAR_FOR_IN = "Database \"{}\" error while {} \"{}\" for \"{}\" in \"{}\": {}";
    protected static final String LOG_ERROR_WHILE_IN_FOR = "Database \"{}\" error while {} in \"{}\" for \"{}\": {}";
    protected static final String LOG_ERROR_WHILE_VAR_IN_FOR = "Database \"{}\" error while {} \"{}\" in \"{}\" for \"{}\": {}";
    protected static final int SIZE_1024 = 1024;
    protected static final int SIZE_MAX = 255;
    protected static final int SIZE_LANG = 3;
    protected static final String BIGINT = " BIGINT";
    protected static final String BLOB = " BLOB";
    protected static final String BOOLEAN = " BOOLEAN";
    protected static final String CLOB = " CLOB";
    protected static final String DATE = " DATE";
    protected static final String DOUBLE_PRECISION = " DOUBLE PRECISION";
    protected static final String IDENTITY = " IDENTITY";
    protected static final String INTEGER = " INTEGER";
    protected static final String OTHER = " OTHER";
    protected static final String NUMERIC = " NUMERIC";
    protected static final String TIMESTAMP = " TIMESTAMP";
    protected static final String TINYINT = " TINYINT";
    protected static final String TIMESTAMP_WITH_TIME_ZONE = " TIMESTAMP WITH TIME ZONE";
    protected static final String UUID_TYPE = " UUID";
    protected static final String VARCHAR = " VARCHAR";
    protected static final String VARCHAR_SIZE_MAX = " VARCHAR(255)";
    protected static final String VARCHAR_SIZE_LANG = " VARCHAR(3)";
    protected static final String VARCHAR_3 = " VARCHAR(3)";
    protected static final String VARCHAR_5 = " VARCHAR(5)";
    protected static final String VARCHAR_16 = " VARCHAR(16)";
    protected static final String VARCHAR_20 = " VARCHAR(20)";
    protected static final String VARCHAR_32 = " VARCHAR(32)";
    protected static final String VARCHAR_36 = " VARCHAR(36)";
    protected static final String VARCHAR_50 = " VARCHAR(50)";
    protected static final String VARCHAR_255 = " VARCHAR(255)";
    protected static final String VARCHAR_1000 = " VARCHAR(1000)";
    protected static final String VARCHAR_1024 = " VARCHAR(1024)";
    protected static final String VARCHAR_20000 = " VARCHAR(20000)";
    protected static final String AUTO_INCREMENT = " AUTO_INCREMENT";
    protected static final String CONSTRAINT_SEPARATOR = "_";
    protected static final String PRIMARY_KEY = " PRIMARY KEY";
    protected static final String FOREIGN_KEY = " FOREIGN KEY";
    protected static final String DEFAULT = " DEFAULT ";
    protected static final String DEFAULT_0 = " DEFAULT 0";
    protected static final String DEFAULT_0D = " DEFAULT 0.0";
    protected static final String COMMA = ", ";
    protected static final String IDX_MARKER = "_IDX";
    protected static final String FK_MARKER = "_FK";
    protected static final String PK_MARKER = "_PK";
    protected static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    protected static final String FALSE = "FALSE";
    protected static final String NULL = "NULL";
    protected static final String TRUE = "TRUE";
    protected static final String EMPTY_STRING = "''";
    protected static final String PARAMETER = "?";
    protected static final String STRINGENCODE_PARAMETER = "STRINGENCODE(?)";
    protected static final String LIKE_STARTING_WITH_PARAMETER = "STRINGENCODE(?) || '%'";
    protected static final String LIKE_ENDING_WITH_PARAMETER = "'%' || STRINGENCODE(?)";
    protected static final String LIKE_CONTAIN_PARAMETER = "'%' || STRINGENCODE(?) || '%'";
    protected static final String CREATE = "CREATE ";
    protected static final String INSERT_INTO = "INSERT INTO ";
    protected static final String MERGE_INTO = "MERGE INTO ";
    protected static final String SELECT = "SELECT ";
    protected static final String UPDATE = "UPDATE ";
    protected static final String WITH = "WITH ";
    protected static final String ADD = " ADD ";
    protected static final String DROP = " DROP ";
    protected static final String ALTER = "ALTER ";
    protected static final String AND = " AND ";
    protected static final String AS = " AS ";
    protected static final String ASC = " ASC";
    protected static final String COLUMN = "COLUMN ";
    protected static final String CONSTRAINT = "CONSTRAINT ";
    protected static final String DELETE_FROM = "DELETE FROM ";
    protected static final String DESC = " DESC";
    protected static final String EQUAL = " = ";
    protected static final String EQUAL_0 = " = 0";
    protected static final String EXISTS = "EXISTS ";
    protected static final String FROM = " FROM ";
    protected static final String GREATER_OR_EQUAL_THAN = " >= ";
    protected static final String GREATER_THAN = " > ";
    protected static final String IF = "IF ";
    protected static final String IN = " IN ";
    protected static final String IS = " IS ";
    protected static final String INDEX = "INDEX ";
    protected static final String JOIN = " JOIN ";
    protected static final String LESS_OR_EQUAL_THAN = " <= ";
    protected static final String NOT = "NOT ";
    protected static final String NOT_IN = " NOT IN ";
    protected static final String NOT_EQUAL = " != ";
    protected static final String LEFT_JOIN = " LEFT JOIN ";
    protected static final String LIMIT = " LIMIT ";
    protected static final String LIMIT_1 = " LIMIT 1";
    protected static final String LIKE = " LIKE ";
    protected static final String ON = " ON ";
    protected static final String ON_DELETE_CASCADE = " ON DELETE CASCADE";
    protected static final String OR = " OR ";
    protected static final String ORDER_BY = " ORDER BY ";
    protected static final String REFERENCES = " REFERENCES ";
    protected static final String RENAME = " RENAME ";
    protected static final String SET = " SET ";
    protected static final String TABLE = "TABLE ";
    protected static final String UNIQUE = "UNIQUE ";
    protected static final String VALUES = " VALUES ";
    protected static final String WHERE = " WHERE ";
    protected static final String ALTER_COLUMN = " ALTER COLUMN ";
    protected static final String ALTER_INDEX = "ALTER INDEX ";
    protected static final String ALTER_TABLE = "ALTER TABLE ";
    protected static final String CREATE_TABLE = "CREATE TABLE ";
    protected static final String CREATE_INDEX = "CREATE INDEX ";
    protected static final String CREATE_UNIQUE_INDEX = "CREATE UNIQUE INDEX ";
    protected static final String DROP_INDEX = "DROP INDEX ";
    protected static final String DROP_TABLE = "DROP TABLE ";
    protected static final String IF_EXISTS = "IF EXISTS ";
    protected static final String IF_NOT_EXISTS = "IF NOT EXISTS ";
    protected static final String IS_NOT_NULL = " IS NOT NULL";
    protected static final String IS_NOT_TRUE = " IS NOT TRUE";
    protected static final String IS_NULL = " IS NULL";
    protected static final String IS_TRUE = " IS TRUE";
    protected static final String NOT_NULL = " NOT NULL";
    protected static final String RENAME_TO = " RENAME TO ";
    protected static final String SELECT_ALL = "SELECT *";
    protected static final String UNIQUE_NOT_NULL = " UNIQUE NOT NULL";

    protected DatabaseHelper() {
    }

    protected static final boolean tableExists(Connection connection, String tableName, String tableSchema) throws SQLException {
        LOGGER.trace("Checking if database table \"{}\" in schema \"{}\" exists", (Object)tableName, (Object)tableSchema);
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?");){
            boolean bl;
            block16: {
                ResultSet result;
                block14: {
                    boolean bl2;
                    block15: {
                        statement.setString(1, tableSchema);
                        statement.setString(2, tableName);
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block14;
                            LOGGER.trace("Database table \"{}\" found", (Object)tableName);
                            bl2 = true;
                            if (result == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return bl2;
                }
                LOGGER.trace("Database table \"{}\" not found", (Object)tableName);
                bl = false;
                if (result == null) break block16;
                result.close();
            }
            return bl;
        }
    }

    protected static final boolean tableExists(Connection connection, String tableName) throws SQLException {
        return DatabaseHelper.tableExists(connection, tableName, "PUBLIC");
    }

    protected static final void dropTable(Connection connection, String tableName) throws SQLException {
        LOGGER.debug("Dropping database table if it exists \"{}\"", (Object)tableName);
        try (Statement statement = connection.createStatement();){
            statement.execute("DROP TABLE IF EXISTS " + tableName);
        }
    }

    protected static final void dropTableAndConstraint(Connection connection, String tableName) {
        LOGGER.debug("Dropping database table if it exists \"{}\"", (Object)tableName);
        try {
            if (DatabaseHelper.tableExists(connection, tableName)) {
                DatabaseHelper.dropReferentialsConstraint(connection, tableName);
                DatabaseHelper.executeUpdate(connection, "DROP TABLE IF EXISTS " + tableName + " CASCADE");
            }
        }
        catch (SQLException e) {
            LOGGER.error("error during dropping table\"" + tableName + "\":" + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final boolean dropReferentialsConstraint(Connection connection, String tableName) {
        LOGGER.debug("Dropping table \"{}\" constraints if it exists", (Object)tableName);
        boolean hasConstraint = false;
        try {
            String sql;
            try (ResultSet rs = connection.getMetaData().getTables(null, "INFORMATION_SCHEMA", "TABLE_CONSTRAINTS", null);){
                sql = rs.next() ? "SELECT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = '" + tableName + "' AND CONSTRAINT_TYPE = 'FOREIGN KEY' OR CONSTRAINT_TYPE = 'REFERENTIAL'" : "SELECT CONSTRAINT_NAME  FROM INFORMATION_SCHEMA.CONSTRAINTS WHERE TABLE_NAME = '" + tableName + "' AND CONSTRAINT_TYPE = 'REFERENTIAL'";
            }
            try (PreparedStatement stmt = connection.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    hasConstraint = true;
                    Statement statement = connection.createStatement();
                    try {
                        statement.execute(ALTER_TABLE + tableName + " DROP CONSTRAINT IF EXISTS " + rs.getString("CONSTRAINT_NAME"));
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                return hasConstraint;
            }
        }
        catch (SQLException e) {
            hasConstraint = true;
            LOGGER.error("error during dropping table\"" + tableName + "\" constraints:" + e.getMessage(), e);
        }
        return hasConstraint;
    }

    protected static final void dropCascadeConstraint(Connection connection, String tableName) {
        LOGGER.debug("Dropping table \"{}\" constraints if it exists", (Object)tableName);
        try {
            ResultSet rs = connection.getMetaData().getTables(null, "INFORMATION_SCHEMA", "TABLE_CONSTRAINTS", null);
            if (!rs.next()) {
                return;
            }
            String sql = "SELECT DISTINCT TC.CONSTRAINT_NAME, TC.TABLE_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS AS RC ON TC.CONSTRAINT_NAME = CCU.CONSTRAINT_NAME INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS CCU ON RC.CONSTRAINT_NAME = CCU.CONSTRAINT_NAME WHERE CCU.TABLE_NAME = '" + tableName + "'";
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Statement statement = connection.createStatement();
                    try {
                        statement.execute("ALTER TABLE IF EXISTS " + rs.getString("TABLE_NAME") + " DROP CONSTRAINT IF EXISTS " + rs.getString("CONSTRAINT_NAME"));
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("error during dropping table\"" + tableName + "\" constraints:" + e.getMessage(), e);
        }
    }

    protected static final void ensureCascadeConstraint(Connection connection, String table, String column, String refTable, String refColumn) {
        try {
            if (DatabaseHelper.isTableExist(connection, table)) {
                DatabaseHelper.executeUpdate(connection, DELETE_FROM + table + WHERE + column + " NOT IN (SELECT " + refTable + "." + refColumn + FROM + refTable + ")");
                DatabaseHelper.executeUpdate(connection, ALTER_TABLE + table + " ADD CONSTRAINT IF NOT EXISTS " + table + CONSTRAINT_SEPARATOR + column + "_FK FOREIGN KEY(" + column + ") REFERENCES " + refTable + "(" + refColumn + ") ON DELETE CASCADE");
            }
        }
        catch (SQLException e) {
            LOGGER.error("error during ensuring cascade exists on table\"" + table + "\":" + e.getMessage(), e);
        }
    }

    protected static final void dropUniqueConstraint(Connection connection, String table, String column) {
        LOGGER.debug("Dropping table \"{}.{}\" unique constraint if it exists", (Object)table, (Object)column);
        String sql = "SELECT INDEX_NAME FROM INFORMATION_SCHEMA.INDEX_COLUMNS WHERE TABLE_NAME = '" + table + "' AND COLUMN_NAME = '" + column + "' AND IS_UNIQUE IS TRUE";
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                Statement statement = connection.createStatement();
                try {
                    String indexName = rs.getString("INDEX_NAME");
                    LOGGER.trace("removing index \"{}\"", (Object)indexName);
                    statement.execute("ALTER TABLE IF EXISTS " + table + " DROP CONSTRAINT IF EXISTS " + indexName);
                    statement.execute("DROP INDEX IF EXISTS " + indexName);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("error during dropping table \"{}.{}\" unique constraints: {}", table, column, e.getMessage(), e);
        }
    }

    public static final String sqlNullIfBlank(String s, boolean quote, boolean like) {
        if (s == null || s.trim().isEmpty()) {
            return IS_NULL;
        }
        if (like) {
            return LIKE + DatabaseHelper.sqlQuote(s);
        }
        if (quote) {
            return EQUAL + DatabaseHelper.sqlQuote(s);
        }
        return EQUAL + s;
    }

    public static final String sqlQuote(String s) {
        return s == null ? null : "'" + s.replace("'", EMPTY_STRING) + "'";
    }

    public static List<HashMap<String, Object>> convertResultSetToList(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                row.put(md.getColumnName(i), rs.getObject(i));
            }
            list.add(row);
        }
        return list;
    }

    public static Set<String> convertResultSetToHashSet(ResultSet rs) throws SQLException {
        HashSet<String> list = new HashSet<String>();
        while (rs.next()) {
            list.add(rs.getString(1));
        }
        return list;
    }

    public static Map<String, Object> convertSingleResultSetToList(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        HashMap<String, Object> row = new HashMap<String, Object>(columns);
        for (int i = 1; i <= columns; ++i) {
            row.put(md.getColumnName(i), rs.getObject(i));
        }
        return row;
    }

    protected static boolean isColumnExist(Connection connection, String table, String column) throws SQLException {
        ResultSet result = connection.getMetaData().getColumns(null, null, table, column);
        if (result.first()) {
            LOGGER.trace("Column \"{}\" found in table \"{}\"", (Object)column, (Object)table);
            return true;
        }
        LOGGER.trace("Column \"{}\" not found in table \"{}\"", (Object)column, (Object)table);
        return false;
    }

    protected static boolean isTableExist(Connection connection, String table) throws SQLException {
        ResultSet result = connection.getMetaData().getTables(null, null, table, null);
        if (result.first()) {
            LOGGER.trace("Table \"{}\" found in db", (Object)table);
            return true;
        }
        LOGGER.trace("Table \"{}\" not found in db", (Object)table);
        return false;
    }

    protected static void executeUpdate(Connection conn, String sql) throws SQLException {
        if (conn != null) {
            try (Statement stmt = conn.createStatement();){
                LOGGER.trace("Execute Update with SQL \"{}\"", (Object)sql);
                stmt.executeUpdate(sql);
            }
        }
    }

    protected static void executeUpdate(Statement stmt, String sql) throws SQLException {
        stmt.executeUpdate(sql);
    }

    protected static void execute(Connection conn, String ... sqls) throws SQLException {
        if (conn != null) {
            try (Statement stmt = conn.createStatement();){
                for (String sql : sqls) {
                    stmt.execute(sql);
                }
            }
        }
    }

    protected static Double toDouble(ResultSet rs, String column) throws SQLException {
        Object obj = rs.getObject(column);
        if (obj instanceof Double) {
            Double value = (Double)obj;
            return value;
        }
        return null;
    }

    protected static Integer toInteger(ResultSet rs, String column) throws SQLException {
        Object obj = rs.getObject(column);
        if (obj instanceof Integer) {
            Integer value = (Integer)obj;
            return value;
        }
        return null;
    }

    protected static LocalDate getLocalDate(ResultSet rs, String column) throws SQLException {
        Object obj = rs.getObject(column);
        if (obj instanceof Date) {
            Date value = (Date)obj;
            return value.toLocalDate();
        }
        return null;
    }

    protected static Long toLong(ResultSet rs, String column) throws SQLException {
        Object obj = rs.getObject(column);
        if (obj instanceof Long) {
            Long value = (Long)obj;
            return value;
        }
        return null;
    }

    protected static void updateBytes(ResultSet rs, String columnLabel, byte[] value) throws SQLException {
        if (value != null) {
            rs.updateBytes(columnLabel, value);
        } else {
            rs.updateNull(columnLabel);
        }
    }

    protected static void updateDouble(ResultSet result, String column, Double value) throws SQLException {
        if (value != null) {
            result.updateDouble(column, (double)value);
        } else {
            result.updateNull(column);
        }
    }

    protected static void updateInteger(ResultSet result, String column, Integer value) throws SQLException {
        if (value != null) {
            result.updateInt(column, (int)value);
        } else {
            result.updateNull(column);
        }
    }

    protected static void updateLong(ResultSet result, String column, Long value) throws SQLException {
        if (value != null) {
            result.updateLong(column, (long)value);
        } else {
            result.updateNull(column);
        }
    }

    protected static void updateObject(ResultSet rs, String columnLabel, Object value) throws SQLException {
        if (value != null) {
            rs.updateObject(columnLabel, value);
        } else {
            rs.updateNull(columnLabel);
        }
    }

    protected static void updateString(ResultSet rs, String columnLabel, String value, int size) throws SQLException {
        if (value != null) {
            rs.updateString(columnLabel, StringUtils.left(StringUtils.trimToEmpty(value), size));
        } else {
            rs.updateNull(columnLabel);
        }
    }

    protected static void updateDate(ResultSet rs, String columnLabel, LocalDate value) throws SQLException {
        if (value != null) {
            rs.updateDate(columnLabel, Date.valueOf(value));
        } else {
            rs.updateNull(columnLabel);
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("error during closing:" + e.getMessage(), e);
        }
    }

    public static void close(Statement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("error during closing:" + e.getMessage(), e);
        }
    }

    public static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("error during closing:" + e.getMessage(), e);
        }
    }

    protected static String getMessage(String pattern, Object ... arguments) {
        int i = 0;
        while (pattern.contains("{}")) {
            pattern = pattern.replaceFirst(Pattern.quote("{}"), "{" + i++ + "}");
        }
        return MessageFormat.format(pattern, arguments);
    }
}

