/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.sharedcontent;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.pms.configuration.sharedcontent.ApertureContent;
import net.pms.configuration.sharedcontent.FeedAudioContent;
import net.pms.configuration.sharedcontent.FeedImageContent;
import net.pms.configuration.sharedcontent.FeedVideoContent;
import net.pms.configuration.sharedcontent.FolderContent;
import net.pms.configuration.sharedcontent.IPhotoContent;
import net.pms.configuration.sharedcontent.ITunesContent;
import net.pms.configuration.sharedcontent.SharedContent;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.configuration.sharedcontent.StreamAudioContent;
import net.pms.configuration.sharedcontent.StreamVideoContent;
import net.pms.configuration.sharedcontent.VirtualFolderContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedContentTypeAdapter
implements JsonSerializer<SharedContent>,
JsonDeserializer<SharedContent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedContentConfiguration.class);

    @Override
    public JsonElement serialize(SharedContent src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = context.serialize(src).getAsJsonObject();
        result.addProperty("type", src.getType());
        return result;
    }

    @Override
    public SharedContent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject sharedContent;
        if (json.isJsonObject() && (sharedContent = json.getAsJsonObject()).has("type") && sharedContent.get("type").isJsonPrimitive()) {
            String type = sharedContent.remove("type").getAsString();
            try {
                return switch (type) {
                    case "Folder" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)FolderContent.class));
                    case "VirtualFolder" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)VirtualFolderContent.class));
                    case "FeedAudio" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)FeedAudioContent.class));
                    case "FeedImage" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)FeedImageContent.class));
                    case "FeedVideo" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)FeedVideoContent.class));
                    case "StreamAudio" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)StreamAudioContent.class));
                    case "StreamVideo" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)StreamVideoContent.class));
                    case "iTunes" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)ITunesContent.class));
                    case "Aperture" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)ApertureContent.class));
                    case "iPhoto" -> (SharedContent)context.deserialize(sharedContent, (Type)((Object)IPhotoContent.class));
                    default -> null;
                };
            }
            catch (JsonParseException e) {
                LOGGER.warn("Exception parsing: {}", (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }
}

