/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.pms.configuration.UmsConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiConfiguration
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiConfiguration.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String ERROR_CONF_FILE = "Error in gui configuration file : ";
    private String graphicsDevice;
    private Rectangle screenBounds;
    private Insets screenInsets;
    private Rectangle windowBounds;
    private int windowState;
    private transient boolean dirty;
    private transient Path path;

    public String getGraphicsDevice() {
        return this.graphicsDevice;
    }

    public void setGraphicsDevice(String graphicsDevice) {
        if (this.graphicsDevice == null ? graphicsDevice != null : !this.graphicsDevice.equals(graphicsDevice)) {
            this.graphicsDevice = graphicsDevice;
            this.dirty = true;
        }
    }

    public Rectangle getScreenBounds() {
        return this.screenBounds;
    }

    public void setScreenBounds(Rectangle screenBounds) {
        if (this.screenBounds == null ? screenBounds != null : !this.screenBounds.equals(screenBounds)) {
            this.screenBounds = screenBounds.getBounds();
            this.dirty = true;
        }
    }

    public Insets getScreenInsets() {
        return this.screenInsets;
    }

    public void setScreenInsets(Insets screenInsets) {
        if (this.screenInsets == null ? screenInsets != null : !this.screenInsets.equals(screenInsets)) {
            this.screenInsets = (Insets)screenInsets.clone();
            this.dirty = true;
        }
    }

    public Rectangle getWindowBounds() {
        return this.windowBounds;
    }

    public void setWindowBounds(Rectangle windowBounds) {
        if (this.windowBounds == null ? windowBounds != null : !this.windowBounds.equals(windowBounds)) {
            this.windowBounds = windowBounds.getBounds();
            this.dirty = true;
        }
    }

    public int getWindowState() {
        return this.windowState;
    }

    public void setWindowState(int windowState) {
        if (this.windowState != windowState) {
            this.windowState = windowState;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save() {
        if (this.dirty && this.path != null) {
            this.dirty = false;
            try {
                LOGGER.debug("Writing window configuration file: " + String.valueOf(this.path));
                Files.writeString(this.path, (CharSequence)GSON.toJson(this), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.debug("An error occurred while writing the window configuration file: {}", e);
            }
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (StringUtils.isBlank(this.graphicsDevice) || this.screenBounds == null) {
            LOGGER.debug("No stored graphics device, using the default");
            return null;
        }
        for (GraphicsDevice graphicsDeviceItem : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (!this.graphicsDevice.equals(graphicsDeviceItem.getIDstring())) continue;
            for (GraphicsConfiguration graphicsConfiguration : graphicsDeviceItem.getConfigurations()) {
                if (!this.screenBounds.equals(graphicsConfiguration.getBounds())) continue;
                return graphicsConfiguration;
            }
        }
        LOGGER.debug("No matching graphics configuration found, using the default");
        return null;
    }

    public static GuiConfiguration getConfiguration() {
        GuiConfiguration conf = null;
        Path path = null;
        try {
            path = Paths.get(UmsConfiguration.getProfileDirectory(), new String[0]).resolve("GUI.conf");
            if (Files.exists(path, new LinkOption[0])) {
                LOGGER.info("Getting gui configuration file : " + String.valueOf(path));
                String json = Files.readString(path, StandardCharsets.UTF_8);
                conf = GSON.fromJson(json, GuiConfiguration.class);
            }
        }
        catch (IOException ex) {
            LOGGER.info(ERROR_CONF_FILE + ex.getMessage());
            LOGGER.debug(null, ex);
        }
        catch (InvalidPathException ex) {
            LOGGER.info("Error in gui configuration file : invalid path");
            LOGGER.debug(null, ex);
        }
        catch (JsonSyntaxException ex) {
            LOGGER.info("Error in gui configuration file : json is malformed");
            LOGGER.debug(null, ex);
        }
        if (conf == null) {
            conf = new GuiConfiguration();
        }
        conf.path = path;
        conf.save();
        return conf;
    }
}

