/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationReader.class);
    private final Map<String, Object> logMap = new HashMap<String, Object>();
    private final Configuration configuration;
    private boolean logOverrides;
    private Configuration dConf;
    private String dTag;

    ConfigurationReader(Configuration configuration) {
        this(configuration, false);
    }

    ConfigurationReader(Configuration configuration, boolean logOverrides) {
        this.configuration = configuration;
        this.logOverrides = logOverrides;
        this.dConf = configuration instanceof CompositeConfiguration ? ((CompositeConfiguration)configuration).getConfiguration(0) : null;
        File f = this.dConf != null ? ((PropertiesConfiguration)this.dConf).getFile() : null;
        this.dTag = f != null ? "[" + f.getName() + "] " : null;
    }

    private String quote(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return String.format("\"%s\"", s.replace("\"", "\\\""));
        }
        return String.valueOf(value);
    }

    private <T> void log(String key, T value, T def) {
        Object oldValue;
        boolean initialised = false;
        if (!this.logOverrides) {
            return;
        }
        if (!this.logMap.containsKey(key)) {
            this.logMap.put(key, def);
            initialised = true;
        }
        if (ObjectUtils.notEqual(oldValue = this.logMap.get(key), value)) {
            String src;
            this.logMap.put(key, value);
            String string = src = this.dConf != null && value != null && value.equals(this.dConf.getProperty(key)) ? this.dTag : "";
            if (initialised) {
                LOGGER.debug("{}Reading {}: {} (default: {})", src, key, this.quote(value), this.quote(oldValue));
            } else {
                LOGGER.debug("{}Reading {}: {} (previous: {}, default: {})", src, key, this.quote(value), this.quote(oldValue), this.quote(def));
            }
        }
    }

    int getInt(String key, int def) {
        int value;
        try {
            value = this.configuration.getInt(key, def);
        }
        catch (ConversionException e) {
            value = def;
        }
        this.log(key, value, def);
        return value;
    }

    long getLong(String key, long def) {
        long value;
        try {
            value = this.configuration.getLong(key, def);
        }
        catch (ConversionException e) {
            value = def;
        }
        this.log(key, value, def);
        return value;
    }

    double getDouble(String key, double def) {
        double value;
        try {
            value = this.configuration.getDouble(key, def);
        }
        catch (ConversionException e) {
            value = def;
        }
        this.log(key, value, def);
        return value;
    }

    boolean getBoolean(String key, boolean def) {
        boolean value;
        try {
            value = this.configuration.getBoolean(key, def);
        }
        catch (ConversionException e) {
            value = def;
        }
        this.log(key, value, def);
        return value;
    }

    String getString(String key, String def) {
        return this.getNonBlankConfigurationString(key, def);
    }

    List<String> getStringList(String key, String def) {
        return Arrays.asList(this.getString(key, def != null ? def : "").split("\\s*,\\s*"));
    }

    Object getCustomProperty(String property) {
        Object value = this.configuration.getProperty(property);
        this.log(property, value, null);
        return value;
    }

    String getNonBlankConfigurationString(String key, String def) {
        String s = this.configuration.getString(key);
        String value = StringUtils.isNotBlank(s) ? s.trim() : (def != null ? def.trim() : null);
        this.log(key, value, def);
        return value;
    }

    String getPossiblyBlankConfigurationString(String key, String def) {
        String s = this.configuration.getString(key, def);
        String value = s != null ? s.trim() : s;
        this.log(key, value, def);
        return value;
    }

    public boolean getLogOverrides() {
        return this.logOverrides;
    }

    public void setLogOverrides(boolean logOverrides) {
        this.logOverrides = logOverrides;
    }
}

