/*
 * Decompiled with CFR 0.152.
 */
package net.pms;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.sun.jna.Platform;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import net.pms.Messages;
import net.pms.configuration.Build;
import net.pms.configuration.GuiConfiguration;
import net.pms.configuration.PostUpgrade;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.UserDatabase;
import net.pms.encoders.EngineFactory;
import net.pms.external.umsapi.APIUtils;
import net.pms.external.update.AutoUpdater;
import net.pms.gui.EConnectionState;
import net.pms.gui.GuiManager;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.ThreadedProcessWrapper;
import net.pms.logging.CacheLogger;
import net.pms.logging.LoggingConfig;
import net.pms.network.NetworkDeviceFilter;
import net.pms.network.configuration.NetworkConfiguration;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.webguiserver.WebGuiServer;
import net.pms.network.webguiserver.WebSocketDispatcher;
import net.pms.network.webplayerserver.WebPlayerServer;
import net.pms.platform.PlatformUtils;
import net.pms.platform.windows.WindowsNamedPipe;
import net.pms.platform.windows.WindowsUtils;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import net.pms.renderers.RendererFilter;
import net.pms.renderers.RendererUser;
import net.pms.service.Services;
import net.pms.store.MediaInfoStore;
import net.pms.store.MediaScanner;
import net.pms.store.MediaStatusStore;
import net.pms.store.ThumbnailStore;
import net.pms.store.container.CodeEnter;
import net.pms.swing.LanguageSelection;
import net.pms.swing.ProfileChooser;
import net.pms.swing.Splash;
import net.pms.swing.SwingUtil;
import net.pms.swing.SysTray;
import net.pms.swing.Wizard;
import net.pms.swing.gui.JavaGui;
import net.pms.util.CodeDb;
import net.pms.util.CredMgr;
import net.pms.util.DbgPacker;
import net.pms.util.FileUtil;
import net.pms.util.Languages;
import net.pms.util.LogSystemInformationMode;
import net.pms.util.ProcessUtil;
import net.pms.util.PropertiesUtil;
import net.pms.util.SystemErrWrapper;
import net.pms.util.SystemInformation;
import net.pms.util.TaskRunner;
import net.pms.util.TempFileMgr;
import net.pms.util.UMSUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMS {
    private static final String SCROLLBARS = "scrollbars";
    private static final String NATIVELOOK_ARG = "nativelook";
    private static final String CONSOLE_ARG = "console";
    private static final String HEADLESS_ARG = "headless";
    private static final String NOCONSOLE_ARG = "noconsole";
    private static final String PROFILES = "profiles";
    private static final String PROFILE = "^(?i)profile(?::|=)([^\"*<>?]+)$";
    private static final String TRACE = "trace";
    private static final String DBLOG = "dblog";
    private static final String DBTRACE = "dbtrace";
    private static final Logger LOGGER = LoggerFactory.getLogger(PMS.class);
    private static final ReadWriteLock LOCALE_LOCK = new ReentrantReadWriteLock();
    private static final ReadWriteLock HEADLESS_LOCK = new ReentrantReadWriteLock();
    public static final String NAME = PropertiesUtil.getProjectProperties().get("project.name");
    public static final String CROWDIN_LINK = "https://crowdin.com/project/universalmediaserver";
    private static PMS instance = null;
    private static Locale locale = null;
    private static UmsConfiguration umsConfiguration;
    private static int traceMode;
    private static boolean logDB;
    private static Boolean headless;
    private static AutoUpdater autoUpdater;
    private final List<Renderer> foundRenderers = Collections.synchronizedList(new ArrayList());
    private DbgPacker dbgPacker;
    private boolean ready = false;
    private MediaServer mediaServer;
    private WebGuiServer webGuiServer;
    private WebPlayerServer webPlayerServer;
    private CodeDb codes;
    private CodeEnter masterCode;
    private CredMgr credMgr;
    private TempFileMgr tfm;

    private PMS() {
    }

    private boolean init() throws Exception {
        LogSystemInformationMode logSystemInfo = umsConfiguration.getLogSystemInformation();
        if (logSystemInfo == LogSystemInformationMode.ALWAYS || logSystemInfo == LogSystemInformationMode.TRACE_ONLY && LOGGER.isTraceEnabled()) {
            new SystemInformation().start();
        }
        if (!(PMS.isHeadless() || PMS.isRunningTests() || umsConfiguration.getLanguageRawString() != null && Languages.isValid(umsConfiguration.getLanguageRawString()))) {
            LanguageSelection languageDialog = new LanguageSelection(null, PMS.getLocale(), false);
            languageDialog.show();
            if (languageDialog.isAborted()) {
                return false;
            }
        }
        GuiConfiguration guiConfiguration = null;
        if (!PMS.isHeadless()) {
            guiConfiguration = GuiConfiguration.getConfiguration();
            Splash.create(umsConfiguration, guiConfiguration);
            Splash.setStatusMessage("Loading");
        }
        this.displayBanner();
        Splash.setStatusMessage("StartingNetwork");
        NetworkConfiguration.start();
        Splash.setStatusMessage("InitMediaDb");
        MediaDatabase.init();
        Splash.setStatusMessage("InitUserDb");
        UserDatabase.init();
        PostUpgrade.proceed();
        Splash.setStatusMessage("InitFilters");
        NetworkDeviceFilter.reset();
        RendererFilter.reset();
        RendererUser.reset();
        Splash.setStatusMessage("InitMediaScanner");
        MediaScanner.init();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("");
            LOGGER.trace("Registered ImageIO reader classes:");
            Iterator<ImageReaderSpi> readerIterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
            while (readerIterator.hasNext()) {
                ImageReaderSpi reader = readerIterator.next();
                LOGGER.trace("Reader class: {}", (Object)reader.getPluginClassName());
            }
            LOGGER.trace("");
            LOGGER.trace("Registered ImageIO writer classes:");
            Iterator<ImageWriterSpi> writerIterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, true);
            while (writerIterator.hasNext()) {
                ImageWriterSpi writer = writerIterator.next();
                LOGGER.trace("Writer class: {}", (Object)writer.getPluginClassName());
            }
            LOGGER.trace("");
        }
        if (umsConfiguration.isRunWizard() && !PMS.isHeadless() && !PMS.isRunningTests()) {
            Splash.showSplash(false);
            Wizard.run(umsConfiguration);
            Splash.showSplash(true);
        }
        if (!PMS.isHeadless() && !PMS.isRunningTests() && umsConfiguration.showInfoAboutVideoAutomaticSetting()) {
            if (!umsConfiguration.isAutomaticMaximumBitrate()) {
                boolean useAutomaticMaximumBitrate = SwingUtil.askYesNoMessage(Messages.getGuiString("WeImprovedAutomaticVideoQuality"), Messages.getGuiString("ImprovedFeature"), true);
                umsConfiguration.setAutomaticMaximumBitrate(useAutomaticMaximumBitrate);
            }
            umsConfiguration.setShowInfoAboutVideoAutomaticSetting(false);
        }
        GuiManager.setMediaScanStatus(false);
        if (!PMS.isHeadless()) {
            Splash.setStatusMessage("StartingGui");
            GuiManager.addGui(new JavaGui(umsConfiguration, guiConfiguration));
            Splash.setStatusMessage("InitSystray");
            SysTray.addSystemTray();
        } else {
            LOGGER.info("Graphics environment not available or headless mode is forced");
            LOGGER.info("Switching to console mode");
        }
        Splash.disposeSplash();
        umsConfiguration.addConfigurationListener(event -> {
            if (!event.isBeforeUpdate()) {
                if (UmsConfiguration.NEED_MEDIA_SERVER_RELOAD_FLAGS.contains(event.getPropertyName())) {
                    GuiManager.setReloadable(true);
                } else if (UmsConfiguration.NEED_RENDERERS_RELOAD_FLAGS.contains(event.getPropertyName())) {
                    GuiManager.setReloadable(true);
                } else if (UmsConfiguration.NEED_WEB_GUI_SERVER_RELOAD_FLAGS.contains(event.getPropertyName())) {
                    GuiManager.setReloadable(true);
                } else if (UmsConfiguration.NEED_WEB_PLAYER_SERVER_RELOAD_FLAGS.contains(event.getPropertyName())) {
                    this.resetWebPlayerServer();
                } else if (UmsConfiguration.LANGUAGE_CHANGED.contains(event.getPropertyName())) {
                    this.resetLanguage();
                } else if (UmsConfiguration.NEED_RENDERERS_MEDIA_STORE_RELOAD_FLAGS.contains(event.getPropertyName())) {
                    this.resetRenderersMediaStore();
                }
                GuiManager.setConfigurationChanged(event.getPropertyName());
            }
        });
        this.resetWebGuiServer();
        this.resetWebPlayerServer();
        this.credMgr = new CredMgr(umsConfiguration.getCredFile());
        this.codes = new CodeDb();
        this.masterCode = null;
        RendererConfigurations.loadRendererConfigurations();
        if (!umsConfiguration.isDisableSubtitles()) {
            LOGGER.info("Checking the fontconfig cache in the background, this can take two minutes or so.");
            ThreadedProcessWrapper.runProcessNullOutput(5L, TimeUnit.MINUTES, 2000L, umsConfiguration.getMPlayerPath(), "dummy");
            if ((!PlatformUtils.isWindows() || PlatformUtils.is64Bit()) && umsConfiguration.getFFmpegPath() != null) {
                ThreadedProcessWrapper.runProcessNullOutput(5L, TimeUnit.MINUTES, 2000L, umsConfiguration.getFFmpegPath(), "-y", "-f", "lavfi", "-i", "nullsrc=s=720x480:d=1:r=1", "-vf", "ass=DummyInput.ass", "-target", "ntsc-dvd", "-");
            }
        }
        if (!PMS.isRunningTests()) {
            UMSUtils.checkGPUDecodingAccelerationMethodsForFFmpeg(umsConfiguration);
        }
        GuiManager.setConnectionState(EConnectionState.SEARCHING);
        if (PlatformUtils.INSTANCE.isAviSynthAvailable() && PlatformUtils.INSTANCE.getAvsPluginsDir() != null) {
            LOGGER.debug("AviSynth plugins directory: " + PlatformUtils.INSTANCE.getAvsPluginsDir().getAbsolutePath());
            File vsFilterDLL = new File(PlatformUtils.INSTANCE.getAvsPluginsDir(), "VSFilter.dll");
            if (vsFilterDLL.exists()) {
                LOGGER.debug("VSFilter / DirectVobSub was found in the AviSynth plugins directory.");
            } else {
                File vsFilterDLL2 = new File(PlatformUtils.INSTANCE.getKLiteFiltersDir(), "vsfilter.dll");
                if (vsFilterDLL2.exists()) {
                    LOGGER.debug("VSFilter / DirectVobSub was found in the K-Lite Codec Pack filters directory.");
                } else {
                    LOGGER.info("VSFilter / DirectVobSub was not found. This can cause problems when trying to play subtitled videos with AviSynth.");
                }
            }
        }
        if (PlatformUtils.INSTANCE.isKerioFirewall()) {
            LOGGER.info("Detected Kerio firewall");
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("org.jaudiotagger.level=OFF".getBytes(StandardCharsets.US_ASCII)));
        System.setErr(new PrintStream((OutputStream)new SystemErrWrapper(), true, StandardCharsets.UTF_8.name()));
        EngineFactory.initialize();
        GuiManager.addEngines();
        MediaServer.start();
        new Thread("Connection Checker"){

            @Override
            public void run() {
                UMSUtils.sleep(7000);
                if (PMS.this.foundRenderers.isEmpty()) {
                    GuiManager.setConnectionState(EConnectionState.DISCONNECTED);
                } else {
                    GuiManager.setConnectionState(EConnectionState.CONNECTED);
                }
            }
        }.start();
        if (this.webPlayerServer != null && this.webPlayerServer.getServer() != null) {
            GuiManager.enableWebUiButton();
            LOGGER.info("Web player is available at: " + this.webPlayerServer.getUrl());
        }
        if (umsConfiguration.getExternalNetwork() && umsConfiguration.isUseInfoFromUmsAPI()) {
            APIUtils.setApiMetadataVersions();
            APIUtils.setApiImageBaseURL();
        }
        GuiManager.serverReady();
        this.ready = true;
        if (!PMS.isHeadless() && umsConfiguration.isWebGuiOnStart() && !PMS.isRunningTests()) {
            new Thread("Web GUI browser"){

                @Override
                public void run() {
                    while (!UserDatabase.isAvailable()) {
                        UMSUtils.sleep(100);
                    }
                    LOGGER.info("Launching the graphical interface on a browser");
                    if (!PlatformUtils.INSTANCE.browseURI(PMS.this.webGuiServer.getUrl())) {
                        LOGGER.error("An error occurred while trying to launch the default web browser");
                    }
                }
            }.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread("UMS Shutdown"){

            @Override
            public void run() {
                PMS.shutdown();
            }
        });
        umsConfiguration.setAutoSave();
        if (umsConfiguration.isScanSharedFoldersOnStartup()) {
            MediaScanner.startMediaScan();
        }
        return true;
    }

    private void displayBanner() throws IOException {
        LOGGER.debug("");
        LOGGER.info("Starting {} {}", (Object)NAME, (Object)PMS.getVersion());
        LOGGER.info("Based on PS3 Media Server by shagrath, copyright 2008-2014");
        LOGGER.info("https://www.universalmediaserver.com");
        LOGGER.info("");
        String commitId = PropertiesUtil.getProjectProperties().get("git.commit.id");
        LOGGER.info("Build: {} ({})", (Object)commitId.substring(0, 9), (Object)PropertiesUtil.getProjectProperties().get("git.commit.time"));
        if (PlatformUtils.isMac() && !PlatformUtils.getOSVersion().isGreaterThanOrEqualTo("10.6.0")) {
            LOGGER.warn("-----------------------------------------------------------------");
            LOGGER.warn("WARNING!");
            LOGGER.warn("UMS ships with external binaries compiled for Mac OS X 10.6 or");
            LOGGER.warn("higher. You are running an older version of Mac OS X which means");
            LOGGER.warn("that these binaries used for example for transcoding may not work!");
            LOGGER.warn("To solve this, replace the binaries found in the \"osx\"");
            LOGGER.warn("subfolder with versions compiled for your version of OS X.");
            LOGGER.warn("-----------------------------------------------------------------");
            LOGGER.warn("");
        }
        String cwd = new File("").getAbsolutePath();
        LOGGER.info("Working directory: {}", (Object)cwd);
        LOGGER.info("Temporary directory: {}", (Object)umsConfiguration.getTempFolder());
        File javaTmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!FileUtil.getFilePermissions(javaTmpdir).isWritable()) {
            LOGGER.error("The Java temp directory \"{}\" is not writable by UMS", (Object)javaTmpdir.getAbsolutePath());
            LOGGER.error("Please make sure the directory is writable for user \"{}\"", (Object)System.getProperty("user.name"));
            throw new IOException("Cannot write to Java temp directory: " + javaTmpdir.getAbsolutePath());
        }
        LOGGER.info("Logging configuration file: {}", (Object)LoggingConfig.getConfigFilePath());
        Map<String, String> lfps = LoggingConfig.getLogFilePaths();
        if (lfps != null && !lfps.isEmpty()) {
            if (lfps.size() == 1) {
                Map.Entry<String, String> entry = lfps.entrySet().iterator().next();
                if (entry.getKey().equalsIgnoreCase("default.log")) {
                    LOGGER.info("Logfile: {}", (Object)entry.getValue());
                } else {
                    LOGGER.info("{}: {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            } else {
                LOGGER.info("Logging to multiple files:");
                for (Map.Entry<String, String> entry : lfps.entrySet()) {
                    LOGGER.info("{}: {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        String profilePath = UmsConfiguration.getProfilePath();
        String profileDirectoryPath = UmsConfiguration.getProfileDirectory();
        LOGGER.info("");
        LOGGER.info("Profile directory: {}", (Object)profileDirectoryPath);
        try {
            LOGGER.info("Profile directory permissions: " + String.valueOf(FileUtil.getFilePermissions(profileDirectoryPath)));
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Profile directory not found: {}", (Object)e.getMessage());
        }
        LOGGER.info("Profile configuration file: {}", (Object)profilePath);
        try {
            LOGGER.info("Profile configuration file permissions: " + String.valueOf(FileUtil.getFilePermissions(profilePath)));
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Profile configuration file not found: {}", (Object)e.getMessage());
        }
        LOGGER.info("Profile name: {}", (Object)umsConfiguration.getProfileName());
        LOGGER.info("");
        File dDir = new File(umsConfiguration.getDataDir());
        if (!dDir.exists() && !dDir.mkdirs()) {
            LOGGER.error("Failed to create profile folder \"{}\"", (Object)umsConfiguration.getDataDir());
        }
        this.dbgPacker = new DbgPacker();
        this.tfm = new TempFileMgr();
        this.tfm.schedule();
    }

    public MediaDatabase getMediaDatabase() {
        return MediaDatabase.get();
    }

    public UserDatabase getUserDatabase() {
        return UserDatabase.get();
    }

    public void resetMediaServer() {
        TaskRunner.getInstance().submitNamed("restart", true, () -> {
            WebSocketDispatcher.notifyAll("server-restart", "Server is restarting", "Server status", "red", true);
            MediaServer.stop();
            this.resetRenderers(true);
            LOGGER.trace("Waiting 1 second...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.trace("Caught exception", e);
            }
            MediaServer.start();
            GuiManager.setReloadable(false);
        });
    }

    public void shutdownComputer() {
        TaskRunner.getInstance().submitNamed("shutdown", true, () -> {
            WebSocketDispatcher.notifyAll("computer-shutdown", "Shutting down computer", "Server status", "red", true);
            ProcessUtil.shutDownComputer();
        });
    }

    public void resetRenderers(boolean delete) {
        RendererConfigurations.loadRendererConfigurations();
        if (delete) {
            ConnectedRenderers.deleteAllConnectedRenderers();
        }
    }

    public void resetLanguage() {
        ThumbnailStore.resetLanguage();
        MediaStatusStore.clear();
        MediaInfoStore.clear();
    }

    public void resetRenderersMediaStore() {
        ConnectedRenderers.resetAllRenderers();
    }

    public void resetWebGuiServer() {
        if (this.webGuiServer != null) {
            GuiManager.removeGui(this.webGuiServer);
            this.webGuiServer.stop();
        }
        try {
            this.webGuiServer = WebGuiServer.createServer(umsConfiguration.getWebGuiServerPort());
        }
        catch (BindException b) {
            try {
                LOGGER.info("Unable to bind web interface on port: " + umsConfiguration.getWebGuiServerPort() + ", because: " + b.getMessage());
                LOGGER.info("Falling back to random port.");
                this.webGuiServer = WebGuiServer.createServer(0);
            }
            catch (IOException ex) {
                LOGGER.error("FATAL ERROR: Unable to set the gui server, because: " + ex.getMessage());
                LOGGER.info("Maybe another process is running or the hostname is wrong.");
            }
        }
        catch (IOException ex) {
            LOGGER.error("FATAL ERROR: Unable to set the gui server, because: " + ex.getMessage());
        }
        if (this.webGuiServer != null && this.webGuiServer.getServer() != null) {
            GuiManager.addGui(this.webGuiServer);
            LOGGER.info("GUI is available at: " + this.webGuiServer.getUrl());
        }
    }

    public void resetWebPlayerServer() {
        if (this.webPlayerServer != null) {
            this.webPlayerServer.stop();
        }
        if (umsConfiguration.useWebPlayerServer()) {
            try {
                this.webPlayerServer = WebPlayerServer.createServer(umsConfiguration.getWebPlayerServerPort());
                GuiManager.updateServerStatus();
            }
            catch (BindException b) {
                LOGGER.error("FATAL ERROR: Unable to bind web player on port: " + umsConfiguration.getWebPlayerServerPort() + ", because: " + b.getMessage());
                LOGGER.info("Maybe another process is running or the hostname is wrong.");
            }
            catch (IOException ex) {
                LOGGER.error("FATAL ERROR: Unable to read server port value from configuration");
            }
        }
    }

    public MediaServer getMediaServer() {
        return this.mediaServer;
    }

    public WebGuiServer getGuiServer() {
        return this.webGuiServer;
    }

    public WebPlayerServer getWebPlayerServer() {
        return this.webPlayerServer;
    }

    public List<Renderer> getFoundRenderers() {
        return this.foundRenderers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRendererFound(Renderer renderer) {
        List<Renderer> list = this.foundRenderers;
        synchronized (list) {
            if (!this.foundRenderers.contains(renderer) && !renderer.isFDSSDP()) {
                LOGGER.debug("Adding status button for {}", (Object)renderer.getRendererName());
                this.foundRenderers.add(renderer);
                GuiManager.addRenderer(renderer);
                GuiManager.setConnectionState(EConnectionState.CONNECTED);
            }
        }
    }

    public DbgPacker debugPacker() {
        return this.dbgPacker;
    }

    public void addTempFile(File f) {
        this.tfm.add(f);
    }

    public void addTempFile(File f, int cleanTime) {
        this.tfm.add(f, cleanTime);
    }

    public CodeDb codeDb() {
        return this.codes;
    }

    public void setMasterCode(CodeEnter ce) {
        this.masterCode = ce;
    }

    public boolean masterCodeValid() {
        return this.masterCode != null && this.masterCode.validCode(null);
    }

    public static void main(String[] args) {
        boolean displayProfileChooser = false;
        boolean denyHeadless = false;
        File profilePath = null;
        PMS.configureJNA();
        CacheLogger.startCaching();
        if (System.getProperty(CONSOLE_ARG, "").equalsIgnoreCase(Boolean.toString(true))) {
            PMS.forceHeadless();
        }
        if (System.getProperty(NOCONSOLE_ARG, "").equalsIgnoreCase(Boolean.toString(true))) {
            denyHeadless = true;
        }
        if (args.length > 0) {
            Pattern pattern = Pattern.compile(PROFILE);
            block23: for (String arg : args) {
                switch (arg.trim().toLowerCase(Locale.ROOT)) {
                    case "headless": 
                    case "console": {
                        PMS.forceHeadless();
                        continue block23;
                    }
                    case "nativelook": {
                        System.setProperty(NATIVELOOK_ARG, Boolean.toString(true));
                        continue block23;
                    }
                    case "scrollbars": {
                        System.setProperty(SCROLLBARS, Boolean.toString(true));
                        continue block23;
                    }
                    case "noconsole": {
                        denyHeadless = true;
                        continue block23;
                    }
                    case "profiles": {
                        displayProfileChooser = true;
                        continue block23;
                    }
                    case "trace": {
                        traceMode = 2;
                        continue block23;
                    }
                    case "dblog": 
                    case "dbtrace": {
                        logDB = true;
                        continue block23;
                    }
                    default: {
                        Matcher matcher = pattern.matcher(arg);
                        if (!matcher.find()) continue block23;
                        profilePath = new File(matcher.group(1));
                    }
                }
            }
        }
        if (!SwingUtil.initDefaultToolkit()) {
            PMS.forceHeadless();
        }
        if (PMS.isHeadless() && denyHeadless) {
            System.err.println("Either a graphics environment isn't available or headless mode is forced, but \"noconsole\" is specified. " + NAME + " can't start, exiting.");
            System.exit(1);
        } else if (!PMS.isHeadless()) {
            SwingUtil.initializeLookAndFeel();
        }
        if (profilePath != null) {
            if (!FileUtil.isValidFileName(profilePath.getName())) {
                LOGGER.warn("Invalid file name in profile argument - using default profile");
            } else if (!profilePath.exists()) {
                LOGGER.warn("Specified profile ({}) doesn't exist - using default profile", (Object)profilePath.getAbsolutePath());
            } else {
                LOGGER.debug("Using specified profile: {}", (Object)profilePath.getAbsolutePath());
                System.setProperty("ums.profile.path", profilePath.getAbsolutePath());
            }
        } else if (!PMS.isHeadless() && displayProfileChooser) {
            ProfileChooser.display();
        }
        try {
            boolean isUmsServiceInstalled;
            LOGGER.debug("Loading {} profile: {}", (Object)UmsConfiguration.getProfileType(), (Object)UmsConfiguration.getProfilePath());
            umsConfiguration = new UmsConfiguration();
            assert (umsConfiguration != null);
            if (Platform.isWindows() && (isUmsServiceInstalled = WindowsUtils.isUmsServiceInstalled())) {
                LOGGER.info("The Windows service is installed.");
            }
            if (Build.isUpdatable()) {
                String serverURL = Build.getUpdateServerURL();
                autoUpdater = new AutoUpdater(serverURL, PMS.getVersion(), PMS.getBinariesRevision());
            }
            LoggingConfig.setRootLevel(Level.toLevel(umsConfiguration.getRootLogLevel()));
            LoggingConfig.loadFile();
            if (traceMode == 2) {
                LoggingConfig.setRootLevel(Level.TRACE);
                LOGGER.debug("Forcing debug level to TRACE");
            } else {
                int n = traceMode = LoggingConfig.getRootLevel().toInt() <= 5000 ? 1 : 0;
            }
            if (traceMode != 2 && umsConfiguration.getLoggingUseSyslog()) {
                LoggingConfig.setSyslog();
            }
            if (traceMode != 2 && umsConfiguration.getLoggingBuffered()) {
                LoggingConfig.setBuffered(true);
            } else if (traceMode == 2) {
                LOGGER.debug("Forcing unbuffered verbose logging");
                LoggingConfig.setBuffered(false);
                LoggingConfig.forceVerboseFileEncoder();
            }
            CacheLogger.stopAndFlush();
            Services.create();
            LOGGER.debug(new Date().toString());
            umsConfiguration.initCred();
            if (!PMS.isRunningTests() && umsConfiguration.isRunSingleInstance()) {
                PMS.killOld();
            }
            PMS.createInstance();
        }
        catch (ConfigurationException t) {
            String errorMessage = String.format("Configuration error: %s: %s", t.getClass().getName(), t.getMessage());
            LOGGER.error(errorMessage);
            if (!PMS.isHeadless() && instance != null) {
                GuiManager.showErrorMessage(errorMessage, Messages.getGuiString("ErrorWhileStartingUms"));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Nonnull
    public static PMS get() {
        if (instance == null) {
            PMS.createInstance();
        }
        return instance;
    }

    @Nonnull
    public static PMS getNewInstance() {
        instance = null;
        PMS.createInstance();
        return instance;
    }

    private static synchronized void createInstance() {
        assert (instance == null);
        instance = new PMS();
        try {
            if (instance.init()) {
                LOGGER.info("{} is now available for renderers to find", (Object)NAME);
            } else {
                LOGGER.info("{} initialization was aborted", (Object)NAME);
            }
        }
        catch (Exception e) {
            LOGGER.error("A serious error occurred during {} initialization: {}", (Object)NAME, (Object)e.getMessage());
            LOGGER.debug("", e);
        }
    }

    public static UmsConfiguration getConfiguration() {
        return umsConfiguration;
    }

    public static UmsConfiguration getConfiguration(Renderer renderer) {
        return renderer != null ? renderer.getUmsConfiguration() : umsConfiguration;
    }

    public static UmsConfiguration getConfiguration(OutputParams params) {
        return PMS.getConfiguration(params != null ? params.getMediaRenderer() : null);
    }

    public static void setConfiguration(UmsConfiguration conf) {
        umsConfiguration = conf;
    }

    public static String getVersion() {
        return PropertiesUtil.getProjectProperties().get("project.version");
    }

    public static String getBinariesRevision() {
        return PropertiesUtil.getProjectProperties().get("project.binaries.revision");
    }

    public static void shutdown() {
        try {
            if (PlatformUtils.isWindows()) {
                WindowsNamedPipe.setLoop(false);
            }
            NetworkConfiguration.stop();
            LOGGER.debug("Shutting down the media server");
            MediaServer.stop();
            Thread.sleep(500L);
            LOGGER.debug("Shutting down all active processes");
            Services.stopProcessManager();
            ProcessWrapperImpl.destroyCurrentProcesses();
        }
        catch (InterruptedException e) {
            LOGGER.debug("Interrupted while shutting down..");
            LOGGER.trace("", e);
        }
        Services.destroy();
        LOGGER.info("Stopping {} {}", (Object)PropertiesUtil.getProjectProperties().get("project.name"), (Object)PMS.getVersion());
        ILoggerFactory iLoggerContext = LoggerFactory.getILoggerFactory();
        if (iLoggerContext instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)iLoggerContext;
            loggerContext.stop();
        } else {
            LOGGER.error("Unable to shut down logging gracefully");
            System.err.println("Unable to shut down logging gracefully");
        }
        if (MediaScanner.isMediaScanRunning()) {
            LOGGER.debug("MediaScanner is still running, attempting to stop it");
            MediaScanner.stopMediaScan();
        } else {
            LOGGER.debug("MediaScanner already stopped");
        }
        if (MediaDatabase.isInstantiated()) {
            LOGGER.debug("Shutting down media database");
            MediaDatabase.shutdown();
            MediaDatabase.createDatabaseReportIfNeeded();
        }
        if (UserDatabase.isInstantiated()) {
            LOGGER.debug("Shutting down user database");
            UserDatabase.shutdown();
            UserDatabase.createDatabaseReportIfNeeded();
        }
    }

    public static void quit() {
        System.exit(0);
    }

    public static void killOld() {
        try {
            PMS.killProc();
        }
        catch (SecurityException e) {
            LOGGER.error("Failed to check for already running instance: " + e.getMessage() + (PlatformUtils.isWindows() ? "\nUMS might need to run as an administrator to access the PID file" : ""));
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("PID file not found, cannot check for running process");
        }
        catch (IOException e) {
            LOGGER.error("Error killing old process: " + String.valueOf(e));
        }
        try {
            PMS.dumpPid();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to write PID file: " + e.getMessage() + (PlatformUtils.isWindows() ? "\nUMS might need to run as an administrator to enforce single instance" : ""));
        }
        catch (IOException e) {
            LOGGER.error("Error dumping PID " + String.valueOf(e));
        }
    }

    private static boolean verifyPidName(String pid) throws IOException, IllegalAccessException {
        String line;
        if (!Platform.isWindows()) {
            throw new IllegalAccessException("verifyPidName can only be called from Windows!");
        }
        ProcessBuilder pb = new ProcessBuilder("tasklist", "/FI", "\"PID eq " + pid + "\"", "/V", "/NH", "/FO", "CSV");
        pb.redirectErrorStream(true);
        Process p = pb.start();
        Charset charset = WindowsUtils.getOEMCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
            LOGGER.warn("Couldn't find a supported charset for {}, using default ({})", (Object)WindowsUtils.getOEMCP(), (Object)charset);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), charset));
        try {
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                boolean bl = false;
                in.close();
                return bl;
            }
            line = in.readLine();
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {
                Throwable e;
                e.addSuppressed(throwable);
            }
        }
        if (line == null) {
            return false;
        }
        String[] tmp = line.toLowerCase().replace("\"", "").split(",");
        if (tmp.length < 9) {
            return false;
        }
        boolean ums = tmp[tmp.length - 1].contains("universal media server") || tmp[tmp.length - 2].contains("universal media server");
        return tmp[0].equals("javaw.exe") && ums;
    }

    private static String pidFile() {
        return umsConfiguration.getDataFile("UMS.pid");
    }

    private static void killProc() throws SecurityException, IOException {
        String pid;
        ProcessBuilder pb = null;
        String pidFile = PMS.pidFile();
        if (!FileUtil.getFilePermissions(pidFile).isReadable()) {
            throw new SecurityException("Cannot read " + pidFile);
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pidFile), StandardCharsets.US_ASCII));){
            pid = in.readLine();
        }
        if (pid == null) {
            return;
        }
        if (PlatformUtils.isWindows()) {
            try {
                if (PMS.verifyPidName(pid)) {
                    pb = new ProcessBuilder("taskkill", "/F", "/PID", pid, "/T");
                }
            }
            catch (IllegalAccessException in) {}
        } else if (Platform.isFreeBSD() || Platform.isLinux() || Platform.isOpenBSD() || Platform.isSolaris()) {
            pb = new ProcessBuilder("kill", "-9", pid);
        }
        if (pb == null) {
            return;
        }
        try {
            Process p = pb.start();
            p.waitFor();
        }
        catch (InterruptedException e) {
            LOGGER.trace("Got interrupted while trying to kill process by PID " + String.valueOf(e));
            Thread.currentThread().interrupt();
        }
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    private static void dumpPid() throws IOException {
        try (FileOutputStream out = new FileOutputStream(PMS.pidFile());){
            long pid = PMS.getPID();
            LOGGER.debug("Writing PID: " + pid);
            String data = String.valueOf(pid) + "\r\n";
            out.write(data.getBytes(StandardCharsets.US_ASCII));
            out.flush();
        }
    }

    public static boolean isHeadless() {
        HEADLESS_LOCK.readLock().lock();
        try {
            if (headless == null) {
                headless = SwingUtil.isHeadless();
            }
            boolean bl = headless;
            return bl;
        }
        finally {
            HEADLESS_LOCK.readLock().unlock();
        }
    }

    public static void forceHeadless() {
        HEADLESS_LOCK.writeLock().lock();
        try {
            headless = true;
        }
        finally {
            HEADLESS_LOCK.writeLock().unlock();
        }
    }

    public static Locale getLocale() {
        LOCALE_LOCK.readLock().lock();
        try {
            if (locale != null) {
                Locale locale = PMS.locale;
                return locale;
            }
            Locale locale = Locale.getDefault();
            return locale;
        }
        finally {
            LOCALE_LOCK.readLock().unlock();
        }
    }

    public static void setLocale(Locale aLocale) {
        LOCALE_LOCK.writeLock().lock();
        try {
            locale = (Locale)aLocale.clone();
            Messages.setLocaleBundle(locale);
        }
        finally {
            LOCALE_LOCK.writeLock().unlock();
        }
    }

    public static boolean isReady() {
        return PMS.get().ready;
    }

    public static int getTraceMode() {
        return traceMode;
    }

    public static boolean getLogDB() {
        return logDB;
    }

    public static CredMgr.Credential getCred(String owner) {
        if (instance == null || PMS.instance.credMgr == null) {
            return null;
        }
        return PMS.instance.credMgr.getCred(owner);
    }

    public static CredMgr.Credential getCred(String owner, String tag) {
        return PMS.instance.credMgr.getCred(owner, tag);
    }

    public static String getCredTag(String owner, String username) {
        return PMS.instance.credMgr.getTag(owner, username);
    }

    public static boolean verifyCred(String owner, String tag, String user, String pwd) {
        return PMS.instance.credMgr.verify(owner, tag, user, pwd);
    }

    public static AutoUpdater getAutoUpdater() {
        return autoUpdater;
    }

    public static boolean isRunningTests() {
        return System.getProperty("surefire.real.class.path") != null || System.getenv("CI") != null && System.getenv("CI").equals("true") || System.getenv("RUNNING_TESTS") != null && System.getenv("RUNNING_TESTS").equals("true");
    }

    public static void configureJNA() {
        try {
            if (System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows") && StringUtils.isNotBlank(System.getProperty("os.version")) && Double.parseDouble(System.getProperty("os.version")) < 5.2) {
                String developmentPath = "src\\main\\external-resources\\lib\\winxp";
                if (new File(developmentPath).exists()) {
                    System.setProperty("jna.boot.library.path", developmentPath);
                } else {
                    System.setProperty("jna.boot.library.path", "windows\\winxp");
                }
            } else {
                System.setProperty("jna.nosys", "true");
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            System.setProperty("jna.nosys", "true");
            System.err.println("Could not determine Windows version from " + System.getProperty("os.version") + ". Not applying Windows XP hack");
        }
    }

    static {
        traceMode = 0;
        headless = null;
    }
}

