/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.search;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.collection.CollectionSimpleResultsSchema;
import java.util.HashMap;

public class SearchCollectionEndpoint
extends Endpoint {
    private static final String V3_SEARCH_COLLECTION_ENDPOINT = "/3/search/collection";
    private final String searchQuery;
    private String language;
    private int page;

    public SearchCollectionEndpoint(TMDbClient tmdbClient, String searchQuery) {
        super(tmdbClient);
        this.searchQuery = searchQuery;
    }

    public SearchCollectionEndpoint setLanguage(String language) {
        this.language = language;
        return this;
    }

    public SearchCollectionEndpoint setPage(int page) {
        this.page = page;
        return this;
    }

    public CollectionSimpleResultsSchema getResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("query", this.searchQuery);
        SearchCollectionEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        SearchCollectionEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_SEARCH_COLLECTION_ENDPOINT, CollectionSimpleResultsSchema.class, query);
    }
}

