/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.person;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.change.ChangesIdsSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonResultsSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonSchema;
import java.util.HashMap;

public class PersonEndpoint
extends Endpoint {
    private static final String V3_PERSON_ENDPOINT = "/3/person/";
    private static final String CHANGES_ENDPOINT = "/3/person/changes";
    private static final String LATEST_ENDPOINT = "/3/person/latest";
    private static final String POPULAR_ENDPOINT = "/3/person/popular";
    private String endDate;
    private String language;
    private int page;
    private String startDate;

    public PersonEndpoint(TMDbClient tmdbClient) {
        super(tmdbClient);
    }

    public PersonEndpoint setLanguage(String language) {
        this.language = language;
        return this;
    }

    public PersonEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public PersonEndpoint setStartDate(String value) {
        this.startDate = value;
        return this;
    }

    public PersonEndpoint setEndDate(String value) {
        this.endDate = value;
        return this;
    }

    public ChangesIdsSchema getChanges() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonEndpoint.addQueryString(query, "start_date", this.startDate);
        PersonEndpoint.addQueryString(query, "end_date", this.endDate);
        PersonEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(CHANGES_ENDPOINT, ChangesIdsSchema.class, query);
    }

    public PersonSchema getLatest() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(LATEST_ENDPOINT, PersonSchema.class, query);
    }

    public PersonResultsSchema getPopular() {
        HashMap<String, String> query = new HashMap<String, String>();
        PersonEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        PersonEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(POPULAR_ENDPOINT, PersonResultsSchema.class, query);
    }
}

