/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.movie;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.movie.MovieIdAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.StatusSchema;
import com.universalmediaserver.tmdbapi.schema.account.AccountStatesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.change.ChangesSchema;
import com.universalmediaserver.tmdbapi.schema.credit.MediaCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.image.ImagesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieAlternativeTitlesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieExternalIdsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieKeywordsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieListsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieReleaseDatesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieShortResultsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieTranslationsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieTypedResultsSchema;
import com.universalmediaserver.tmdbapi.schema.reviews.ReviewsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.video.VideosResponseSchema;
import com.universalmediaserver.tmdbapi.schema.watchproviders.WatchProvidersResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MovieIdEndpoint
extends Endpoint {
    private static final String V3_MOVIE_ENDPOINT = "/3/movie/";
    private static final String ACCOUNT_STATES_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.ACCOUNT_STATES);
    private static final String ALTERNATIVE_TITLES_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.ALTERNATIVE_TITLES);
    private static final String CHANGES_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.CHANGES);
    private static final String CREDITS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.CREDITS);
    private static final String EXTERNAL_IDS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.EXTERNAL_IDS);
    private static final String IMAGES_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.IMAGES);
    private static final String KEYWORDS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.KEYWORDS);
    private static final String LISTS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.LISTS);
    private static final String RATING_ENDPOINT = "/rating";
    private static final String RECOMMENDATIONS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.RECOMMENDATIONS);
    private static final String RELEASE_DATES_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.RELEASE_DATES);
    private static final String REVIEWS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.REVIEWS);
    private static final String SIMILAR_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.SIMILAR);
    private static final String TRANSLATIONS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.TRANSLATIONS);
    private static final String VIDEOS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.VIDEOS);
    private static final String WATCH_PROVIDERS_ENDPOINT = "/" + String.valueOf((Object)MovieIdAppendToResponse.WATCH_PROVIDERS);
    private final long movieId;
    private final List<MovieIdAppendToResponse> appendToResponse = new ArrayList<MovieIdAppendToResponse>();
    private final List<String> includeImageLanguage = new ArrayList<String>();
    private final List<String> includeVideoLanguage = new ArrayList<String>();
    private String country;
    private String language;
    private String startDate;
    private String endDate;
    private int page;

    public MovieIdEndpoint(TMDbClient tmdbClient, long movieId) {
        super(tmdbClient);
        this.movieId = movieId;
    }

    public MovieIdEndpoint setCountry(String value) {
        this.country = value;
        return this;
    }

    public MovieIdEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public MovieIdEndpoint setStartDate(String value) {
        this.startDate = value;
        return this;
    }

    public MovieIdEndpoint setEndDate(String value) {
        this.endDate = value;
        return this;
    }

    public MovieIdEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public MovieIdEndpoint appendToResponse(MovieIdAppendToResponse ... appendsToResponse) {
        if (appendsToResponse != null) {
            MovieIdAppendToResponse[] movieIdAppendToResponseArray = appendsToResponse;
            int n = appendsToResponse.length;
            int n2 = 0;
            while (n2 < n) {
                MovieIdAppendToResponse movieIdAppendToResponse = movieIdAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)movieIdAppendToResponse)) {
                    this.appendToResponse.add(movieIdAppendToResponse);
                }
                ++n2;
            }
        }
        return this;
    }

    public MovieIdEndpoint includeImageLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String imageLanguage = stringArray[n2];
                if (!this.includeImageLanguage.contains(imageLanguage)) {
                    this.includeImageLanguage.add(imageLanguage);
                }
                ++n2;
            }
        }
        return this;
    }

    public MovieIdEndpoint includeVideoLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String videoLanguage = stringArray[n2];
                if (!this.includeVideoLanguage.contains(videoLanguage)) {
                    this.includeVideoLanguage.add(videoLanguage);
                }
                ++n2;
            }
        }
        return this;
    }

    public MovieDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieIdEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        MovieIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        MovieIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId, MovieDetailsSchema.class, query);
    }

    public MovieAlternativeTitlesResponseSchema getAlternativeTitles() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "country", this.country);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + ALTERNATIVE_TITLES_ENDPOINT, MovieAlternativeTitlesResponseSchema.class, query);
    }

    public AccountStatesResponseSchema getAccountStates() {
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + ACCOUNT_STATES_ENDPOINT, AccountStatesResponseSchema.class, null);
    }

    public ChangesSchema getChanges() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "start_date", this.startDate);
        MovieIdEndpoint.addQueryString(query, "end_date", this.endDate);
        MovieIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + CHANGES_ENDPOINT, ChangesSchema.class, query);
    }

    public MediaCreditsResponseSchema getCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + CREDITS_ENDPOINT, MediaCreditsResponseSchema.class, query);
    }

    public MovieExternalIdsResponseSchema getExternalIds() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + EXTERNAL_IDS_ENDPOINT, MovieExternalIdsResponseSchema.class, query);
    }

    public ImagesResponseSchema getImages() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + IMAGES_ENDPOINT, ImagesResponseSchema.class, query);
    }

    public MovieKeywordsResponseSchema getKeywords() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + KEYWORDS_ENDPOINT, MovieKeywordsResponseSchema.class, query);
    }

    public MovieListsResponseSchema getLists() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + LISTS_ENDPOINT, MovieListsResponseSchema.class, query);
    }

    public MovieTypedResultsSchema getRecommendations() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + RECOMMENDATIONS_ENDPOINT, MovieTypedResultsSchema.class, query);
    }

    public MovieReleaseDatesResponseSchema getReleaseDates() {
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + RELEASE_DATES_ENDPOINT, MovieReleaseDatesResponseSchema.class, null);
    }

    public ReviewsResponseSchema getReviews() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + REVIEWS_ENDPOINT, ReviewsResponseSchema.class, query);
    }

    public MovieShortResultsSchema getSimilar() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieIdEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + SIMILAR_ENDPOINT, MovieShortResultsSchema.class, query);
    }

    public MovieTranslationsResponseSchema getTranslations() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + TRANSLATIONS_ENDPOINT, MovieTranslationsResponseSchema.class, query);
    }

    public VideosResponseSchema getVideos() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + VIDEOS_ENDPOINT, VideosResponseSchema.class, query);
    }

    public WatchProvidersResponseSchema getWatchProviders() {
        return this.tmdbClient.get(V3_MOVIE_ENDPOINT + this.movieId + WATCH_PROVIDERS_ENDPOINT, WatchProvidersResponseSchema.class, null);
    }

    public StatusSchema deleteRating() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        MovieIdEndpoint.addQueryString(query, "guest_session_id", this.tmdbClient.getGuestSessionId());
        return this.tmdbClient.delete(V3_MOVIE_ENDPOINT + this.movieId + RATING_ENDPOINT, StatusSchema.class, query);
    }

    public StatusSchema postRating(float value) {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieIdEndpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        MovieIdEndpoint.addQueryString(query, "guest_session_id", this.tmdbClient.getGuestSessionId());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", Float.valueOf(value));
        return this.tmdbClient.post(V3_MOVIE_ENDPOINT + this.movieId + RATING_ENDPOINT, StatusSchema.class, query, jsonObject.toString());
    }
}

