/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.movie;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.change.ChangesIdsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieShortDatedResultsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieShortResultsSchema;
import java.util.HashMap;

public class MovieEndpoint
extends Endpoint {
    private static final String V3_MOVIE_ENDPOINT = "/3/movie/";
    private static final String CHANGES_ENDPOINT = "/3/movie/changes";
    private static final String LATEST_ENDPOINT = "/3/movie/latest";
    private static final String NOW_PLAYING_ENDPOINT = "/3/movie/now_playing";
    private static final String POPULAR_ENDPOINT = "/3/movie/popular";
    private static final String TOP_RATED_ENDPOINT = "/3/movie/top_rated";
    private static final String UPCOMING_ENDPOINT = "/3/movie/upcoming";
    private String endDate;
    private String language;
    private int page;
    private String region;
    private String startDate;

    public MovieEndpoint(TMDbClient tmdbClient) {
        super(tmdbClient);
    }

    public MovieEndpoint setLanguage(String language) {
        this.language = language;
        return this;
    }

    public MovieEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public MovieEndpoint setRegion(String value) {
        this.region = value.toUpperCase();
        return this;
    }

    public MovieEndpoint setStartDate(String value) {
        this.startDate = value;
        return this;
    }

    public MovieEndpoint setEndDate(String value) {
        this.endDate = value;
        return this;
    }

    public ChangesIdsSchema getChanges() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieEndpoint.addQueryString(query, "start_date", this.startDate);
        MovieEndpoint.addQueryString(query, "end_date", this.endDate);
        MovieEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(CHANGES_ENDPOINT, ChangesIdsSchema.class, query);
    }

    public MovieSchema getLatest() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(LATEST_ENDPOINT, MovieSchema.class, query);
    }

    public MovieShortDatedResultsSchema getNowPlaying() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieEndpoint.addQueryString(query, "region", this.region);
        MovieEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(NOW_PLAYING_ENDPOINT, MovieShortDatedResultsSchema.class, query);
    }

    public MovieShortResultsSchema getPopular() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieEndpoint.addQueryString(query, "region", this.region);
        MovieEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(POPULAR_ENDPOINT, MovieShortResultsSchema.class, query);
    }

    public MovieShortResultsSchema getTopRated() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieEndpoint.addQueryString(query, "region", this.region);
        MovieEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(TOP_RATED_ENDPOINT, MovieShortResultsSchema.class, query);
    }

    public MovieShortDatedResultsSchema getUpcoming() {
        HashMap<String, String> query = new HashMap<String, String>();
        MovieEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        MovieEndpoint.addQueryString(query, "region", this.region);
        MovieEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(UPCOMING_ENDPOINT, MovieShortDatedResultsSchema.class, query);
    }
}

