/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.genre;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.genre.GenresSchema;
import java.util.HashMap;

public class GenreEndpoint
extends Endpoint {
    private static final String V3_GENRE_ENDPOINT = "/3/genre/";
    private static final String LIST_ENDPOINT = "/3/genre/list";
    private static final String MOVIE_LIST_ENDPOINT = "/3/genre/movie/list";
    private static final String TV_LIST_ENDPOINT = "/3/genre/tv/list";
    private String language;

    public GenreEndpoint(TMDbClient tmdbClient) {
        super(tmdbClient);
    }

    public GenreEndpoint setLanguage(String language) {
        this.language = language;
        return this;
    }

    public GenresSchema getList() {
        HashMap<String, String> query = new HashMap<String, String>();
        GenreEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(LIST_ENDPOINT, GenresSchema.class, query);
    }

    public GenresSchema getMovieList() {
        HashMap<String, String> query = new HashMap<String, String>();
        GenreEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(MOVIE_LIST_ENDPOINT, GenresSchema.class, query);
    }

    public GenresSchema getTvList() {
        HashMap<String, String> query = new HashMap<String, String>();
        GenreEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(TV_LIST_ENDPOINT, GenresSchema.class, query);
    }
}

