/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.coverartarchive.api.endpoint.release_group;

import com.universalmediaserver.coverartarchive.api.CoverArtArchiveClient;
import com.universalmediaserver.coverartarchive.api.endpoint.Endpoint;
import com.universalmediaserver.coverartarchive.api.endpoint.ThumbnailSize;
import com.universalmediaserver.coverartarchive.api.schema.ResultSchema;

public class ReleaseGroupEndpoint
extends Endpoint {
    protected static final String RELEASE_GROUP_ENDPOINT = "release-group/";
    private final String musicBrainzId;

    public ReleaseGroupEndpoint(CoverArtArchiveClient musicBrainzAPIClient, String musicBrainzId) {
        super(musicBrainzAPIClient);
        this.musicBrainzId = musicBrainzId;
    }

    public ResultSchema getDetails() {
        return this.client.get(RELEASE_GROUP_ENDPOINT + this.musicBrainzId, ResultSchema.class, null);
    }

    public String getFrontImageLocation() {
        return this.client.getRedirectLocation(RELEASE_GROUP_ENDPOINT + this.musicBrainzId + "/front");
    }

    public byte[] getFrontImageBytes() {
        return this.client.getJpegBytes(RELEASE_GROUP_ENDPOINT + this.musicBrainzId + "/front");
    }

    public String getFrontImageLocation(ThumbnailSize size) {
        return this.client.getRedirectLocation(RELEASE_GROUP_ENDPOINT + this.musicBrainzId + "/front-" + size);
    }

    public byte[] getFrontImageBytes(ThumbnailSize size) {
        return this.client.getJpegBytes(RELEASE_GROUP_ENDPOINT + this.musicBrainzId + "/front-" + size);
    }
}

