/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.lang.Validate;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;

final class TGAHeader {
    private int colorMapType;
    private int imageType;
    private int colorMapStart;
    private int colorMapSize;
    private int colorMapDepth;
    private int x;
    private int y;
    private int width;
    private int height;
    private int pixelDepth;
    private int attributeBits;
    int origin;
    private int interleave;
    String identification;
    private IndexColorModel colorMap;

    TGAHeader() {
    }

    int getImageType() {
        return this.imageType;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    int getPixelDepth() {
        return this.pixelDepth;
    }

    int getAttributeBits() {
        return this.attributeBits;
    }

    int getOrigin() {
        return this.origin;
    }

    int getInterleave() {
        return this.interleave;
    }

    String getIdentification() {
        return this.identification;
    }

    IndexColorModel getColorMap() {
        return this.colorMap;
    }

    public String toString() {
        return "TGAHeader{colorMapType=" + this.colorMapType + ", imageType=" + this.imageType + ", colorMapStart=" + this.colorMapStart + ", colorMapSize=" + this.colorMapSize + ", colorMapDepth=" + this.colorMapDepth + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", pixelDepth=" + this.pixelDepth + ", attributeBits=" + this.attributeBits + ", origin=" + this.origin + ", interleave=" + this.interleave + (this.identification != null ? ", identification='" + this.identification + '\'' : "") + '}';
    }

    static TGAHeader from(ImageTypeSpecifier imageTypeSpecifier, boolean bl) {
        return TGAHeader.from(imageTypeSpecifier, 0, 0, bl);
    }

    static TGAHeader from(ImageTypeSpecifier imageTypeSpecifier, int n, int n2, boolean bl) {
        Validate.notNull(imageTypeSpecifier, "type");
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        IndexColorModel indexColorModel = colorModel instanceof IndexColorModel ? (IndexColorModel)colorModel : null;
        TGAHeader tGAHeader = new TGAHeader();
        tGAHeader.colorMapType = indexColorModel != null ? 1 : 0;
        tGAHeader.imageType = TGAHeader.getImageType(colorModel, bl);
        tGAHeader.colorMapStart = 0;
        int n3 = tGAHeader.colorMapSize = indexColorModel != null ? indexColorModel.getMapSize() : 0;
        tGAHeader.colorMapDepth = indexColorModel != null ? (indexColorModel.hasAlpha() ? 32 : 24) : 0;
        tGAHeader.x = 0;
        tGAHeader.y = 0;
        tGAHeader.width = n;
        tGAHeader.height = n2;
        tGAHeader.pixelDepth = colorModel.getPixelSize() == 15 ? 16 : colorModel.getPixelSize();
        tGAHeader.origin = 2;
        tGAHeader.attributeBits = colorModel.hasAlpha() ? 8 : 0;
        tGAHeader.identification = null;
        tGAHeader.colorMap = indexColorModel;
        return tGAHeader;
    }

    private static int getImageType(ColorModel colorModel, boolean bl) {
        int n;
        if (colorModel instanceof IndexColorModel) {
            n = 1;
        } else {
            switch (colorModel.getColorSpace().getType()) {
                case 5: {
                    n = 2;
                    break;
                }
                case 6: {
                    n = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported color space for TGA: " + colorModel.getColorSpace());
                }
            }
        }
        return n | (bl ? 8 : 0);
    }

    void write(DataOutput dataOutput) throws IOException {
        byte[] byArray = this.identification != null ? this.identification.getBytes(StandardCharsets.US_ASCII) : new byte[]{};
        dataOutput.writeByte(byArray.length);
        dataOutput.writeByte(this.colorMapType);
        dataOutput.writeByte(this.imageType);
        dataOutput.writeShort(this.colorMapStart);
        dataOutput.writeShort(this.colorMapSize);
        dataOutput.writeByte(this.colorMapDepth);
        dataOutput.writeShort(this.x);
        dataOutput.writeShort(this.y);
        dataOutput.writeShort(this.width);
        dataOutput.writeShort(this.height);
        dataOutput.writeByte(this.pixelDepth);
        dataOutput.writeByte(this.attributeBits | this.origin << 4 | this.interleave << 6);
        dataOutput.write(byArray);
        if (this.colorMap != null) {
            int[] nArray = new int[this.colorMap.getMapSize()];
            this.colorMap.getRGBs(nArray);
            int n = this.colorMap.hasAlpha() ? 4 : 3;
            byte[] byArray2 = new byte[nArray.length * n];
            for (int i = 0; i < nArray.length; ++i) {
                byArray2[i * n] = (byte)(nArray[i] & 0xFF);
                byArray2[i * n + 1] = (byte)(nArray[i] >> 8 & 0xFF);
                byArray2[i * n + 2] = (byte)(nArray[i] >> 16 & 0xFF);
                if (n != 4) continue;
                byArray2[i * n + 3] = (byte)(nArray[i] >>> 24 & 0xFF);
            }
            dataOutput.write(byArray2);
        }
    }

    static TGAHeader read(ImageInputStream imageInputStream) throws IOException {
        TGAHeader tGAHeader = new TGAHeader();
        int n = imageInputStream.readUnsignedByte();
        tGAHeader.colorMapType = imageInputStream.readUnsignedByte();
        tGAHeader.imageType = imageInputStream.readUnsignedByte();
        tGAHeader.colorMapStart = imageInputStream.readUnsignedShort();
        tGAHeader.colorMapSize = imageInputStream.readUnsignedShort();
        tGAHeader.colorMapDepth = imageInputStream.readUnsignedByte();
        tGAHeader.x = imageInputStream.readUnsignedShort();
        tGAHeader.y = imageInputStream.readUnsignedShort();
        tGAHeader.width = imageInputStream.readUnsignedShort();
        tGAHeader.height = imageInputStream.readUnsignedShort();
        tGAHeader.pixelDepth = imageInputStream.readUnsignedByte();
        int n2 = imageInputStream.readUnsignedByte();
        tGAHeader.attributeBits = n2 & 0xF;
        tGAHeader.origin = (n2 & 0x30) >> 4;
        tGAHeader.interleave = (n2 & 0xC0) >> 6;
        if (n > 0) {
            tGAHeader.identification = TGAHeader.readString(imageInputStream, n);
        }
        if (tGAHeader.colorMapType == 1) {
            tGAHeader.colorMap = TGAHeader.readColorMap(imageInputStream, tGAHeader);
        }
        return tGAHeader;
    }

    static String readString(ImageInputStream imageInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        imageInputStream.readFully(byArray);
        return TGAHeader.asZeroTerminatedASCIIString(byArray);
    }

    private static String asZeroTerminatedASCIIString(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            n = i;
            break;
        }
        return new String(byArray, 0, n, StandardCharsets.US_ASCII);
    }

    private static IndexColorModel readColorMap(DataInput dataInput, TGAHeader tGAHeader) throws IOException {
        boolean bl;
        int n = tGAHeader.colorMapSize;
        int n2 = tGAHeader.colorMapDepth;
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n * n3];
        dataInput.readFully(byArray);
        switch (n2) {
            case 16: {
                byte[] byArray2 = byArray;
                byArray = new byte[n * 3];
                for (int i = 0; i < byArray2.length / 2; ++i) {
                    byte by = byArray2[i * 2];
                    byte by2 = byArray2[i * 2 + 1];
                    byArray[i * 3] = (byte)((by2 & 0x7C) >> 2 << 3);
                    byArray[i * 3 + 1] = (byte)(((by2 & 3) << 3 | (by & 0xE0) >> 5) << 3);
                    byArray[i * 3 + 2] = (byte)((by & 0x1F) << 3);
                }
                bl = false;
                break;
            }
            case 24: {
                for (int i = 0; i < byArray.length; i += 3) {
                    byte by = byArray[i];
                    byArray[i] = byArray[i + 2];
                    byArray[i + 2] = by;
                }
                bl = false;
                break;
            }
            case 32: {
                for (int i = 0; i < byArray.length; i += 4) {
                    byte by = byArray[i];
                    byArray[i] = byArray[i + 2];
                    byArray[i + 2] = by;
                }
                bl = true;
                break;
            }
            default: {
                throw new IIOException("Unsupported color map depth: " + tGAHeader.colorMapDepth);
            }
        }
        return new IndexColorModel(tGAHeader.pixelDepth, n, byArray, tGAHeader.colorMapStart, bl);
    }
}

