/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.sgi;

import com.twelvemonkeys.imageio.StandardImageMetadataSupport;
import com.twelvemonkeys.imageio.plugins.sgi.SGIHeader;
import javax.imageio.ImageTypeSpecifier;

final class SGIMetadata
extends StandardImageMetadataSupport {
    public SGIMetadata(ImageTypeSpecifier imageTypeSpecifier, SGIHeader sGIHeader) {
        super(SGIMetadata.builder(imageTypeSpecifier).withSignificantBitsPerSample(SGIMetadata.computeSignificantBits(sGIHeader)).withCompressionTypeName(SGIMetadata.compressionName(sGIHeader)).withOrientation(StandardImageMetadataSupport.ImageOrientation.FlipV).withTextEntry("DocumentName", sGIHeader.getName()));
    }

    private static int computeSignificantBits(SGIHeader sGIHeader) {
        int n = sGIHeader.getMaxValue();
        int n2 = 1;
        while ((n >>>= 1) != 0) {
            ++n2;
        }
        return n2;
    }

    private static String compressionName(SGIHeader sGIHeader) {
        switch (sGIHeader.getCompression()) {
            case 0: {
                return "None";
            }
            case 1: {
                return "RLE";
            }
        }
        return "Uknown";
    }
}

