/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSD;
import com.twelvemonkeys.imageio.plugins.psd.PSDAlphaChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDDisplayInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDEXIF1Data;
import com.twelvemonkeys.imageio.plugins.psd.PSDGridAndGuideInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDIPTCData;
import com.twelvemonkeys.imageio.plugins.psd.PSDPathResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDPixelAspectRatio;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlags;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlagsInformation;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintScale;
import com.twelvemonkeys.imageio.plugins.psd.PSDResolutionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUnicodeAlphaNames;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import com.twelvemonkeys.imageio.plugins.psd.PSDVersionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDXMPData;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.lang.StringUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public class PSDImageResource {
    final short id;
    final String name;
    final long size;

    PSDImageResource(short s, ImageInputStream imageInputStream) throws IOException {
        this.id = s;
        this.name = PSDUtil.readPascalString(imageInputStream);
        int n = this.name.length() + 1;
        if (n % 2 != 0) {
            imageInputStream.readByte();
        }
        this.size = imageInputStream.readUnsignedInt();
        long l = imageInputStream.getStreamPosition();
        this.readData(new SubImageInputStream(imageInputStream, this.size));
        if (imageInputStream.getStreamPosition() != l + this.size) {
            imageInputStream.seek(l + this.size);
        }
        if (this.size % 2L != 0L) {
            imageInputStream.read();
        }
    }

    protected void readData(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.skipBytes(this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", data length: ");
        stringBuilder.append(this.size);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        String string = PSDImageResource.resourceTypeForId(this.id);
        if (string != null) {
            stringBuilder.append("(").append(string).append(")");
        }
        stringBuilder.append("[ID: 0x");
        stringBuilder.append(Integer.toHexString(this.id));
        if (this.name != null && !this.name.trim().isEmpty()) {
            stringBuilder.append(", name: \"");
            stringBuilder.append(this.name);
            stringBuilder.append("\"");
        }
        return stringBuilder;
    }

    static String resourceTypeForId(short s) {
        switch (s) {
            case 1005: 
            case 1006: 
            case 1007: 
            case 1011: 
            case 1028: 
            case 1032: 
            case 1033: 
            case 1036: 
            case 1039: 
            case 1057: 
            case 1058: 
            case 1060: 
            case 1062: 
            case 1064: 
            case 10000: {
                return null;
            }
        }
        if (s >= 2000 && s <= 2998) {
            return "PathInformationResource";
        }
        if (s >= 4000 && s <= 4999) {
            return "PluginResource";
        }
        try {
            for (Field field : PSD.class.getDeclaredFields()) {
                if (!field.getName().startsWith("RES_") || field.getInt(null) != s) continue;
                String string = field.getName().substring(4);
                return StringUtil.lispToCamel(string.replace("_", "-").toLowerCase(), true);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "UnknownResource";
    }

    public static PSDImageResource read(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        switch (n) {
            case 943868237: 
            case 1097287783: 
            case 1145262930: 
            case 1298486113: 
            case 1346917716: {
                break;
            }
            default: {
                throw new IIOException(String.format("Wrong image resource type, expected '8BIM': '%s'", PSDUtil.intToStr(n)));
            }
        }
        short s = imageInputStream.readShort();
        switch (s) {
            case 1005: {
                return new PSDResolutionInfo(s, imageInputStream);
            }
            case 1006: {
                return new PSDAlphaChannelInfo(s, imageInputStream);
            }
            case 1007: {
                return new PSDDisplayInfo(s, imageInputStream);
            }
            case 1011: {
                return new PSDPrintFlags(s, imageInputStream);
            }
            case 1028: {
                return new PSDIPTCData(s, imageInputStream);
            }
            case 1032: {
                return new PSDGridAndGuideInfo(s, imageInputStream);
            }
            case 1033: 
            case 1036: {
                return new PSDThumbnail(s, imageInputStream);
            }
            case 1039: {
                return new ICCProfile(s, imageInputStream);
            }
            case 1045: {
                return new PSDUnicodeAlphaNames(s, imageInputStream);
            }
            case 1057: {
                return new PSDVersionInfo(s, imageInputStream);
            }
            case 1058: {
                return new PSDEXIF1Data(s, imageInputStream);
            }
            case 1060: {
                return new PSDXMPData(s, imageInputStream);
            }
            case 1062: {
                return new PSDPrintScale(s, imageInputStream);
            }
            case 1064: {
                return new PSDPixelAspectRatio(s, imageInputStream);
            }
            case 10000: {
                return new PSDPrintFlagsInformation(s, imageInputStream);
            }
        }
        if (s >= 2000 && s <= 2998) {
            return new PSDPathResource(s, imageInputStream);
        }
        return new PSDImageResource(s, imageInputStream);
    }
}

