/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.util.StringTokenIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

final class Plain8BitDecoder
extends InputStream {
    private final BufferedReader reader;
    private StringTokenIterator currentLine;

    public Plain8BitDecoder(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));
    }

    @Override
    public int read() throws IOException {
        while (this.currentLine == null || !this.currentLine.hasNext()) {
            String string = this.reader.readLine();
            if (string == null) {
                return -1;
            }
            this.currentLine = new StringTokenIterator(string);
        }
        return Integer.parseInt(this.currentLine.next()) & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

