/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.StandardImageMetadataSupport;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import java.nio.ByteOrder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataNode;

final class PNMMetadata
extends StandardImageMetadataSupport {
    private final PNMHeader header;

    PNMMetadata(ImageTypeSpecifier imageTypeSpecifier, PNMHeader pNMHeader) {
        super(PNMMetadata.builder(imageTypeSpecifier).withColorSpaceType(PNMMetadata.colorSpace(pNMHeader)).withBlackIsZero(pNMHeader.getTupleType() != TupleType.BLACKANDWHITE_WHITE_IS_ZERO).withSignificantBitsPerSample(PNMMetadata.significantBits(pNMHeader)).withSampleMSB(pNMHeader.getByteOrder() == ByteOrder.BIG_ENDIAN ? 0 : pNMHeader.getBitsPerSample() - 1).withOrientation(PNMMetadata.orientation(pNMHeader)));
        this.header = pNMHeader;
    }

    private static int significantBits(PNMHeader pNMHeader) {
        if (pNMHeader.getTransferType() == 4) {
            return pNMHeader.getBitsPerSample();
        }
        int n = 0;
        int n2 = pNMHeader.getMaxSample();
        while (n2 > 0) {
            n2 >>>= 1;
            ++n;
        }
        return n;
    }

    private static StandardImageMetadataSupport.ColorSpaceType colorSpace(PNMHeader pNMHeader) {
        switch (pNMHeader.getTupleType()) {
            case BLACKANDWHITE: 
            case BLACKANDWHITE_ALPHA: 
            case BLACKANDWHITE_WHITE_IS_ZERO: 
            case GRAYSCALE: 
            case GRAYSCALE_ALPHA: {
                return StandardImageMetadataSupport.ColorSpaceType.GRAY;
            }
        }
        return null;
    }

    private static StandardImageMetadataSupport.ImageOrientation orientation(PNMHeader pNMHeader) {
        return pNMHeader.getFileType() == 20582 || pNMHeader.getFileType() == 20550 ? StandardImageMetadataSupport.ImageOrientation.FlipH : StandardImageMetadataSupport.ImageOrientation.Normal;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        if (!this.header.getComments().isEmpty()) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
            for (String string : this.header.getComments()) {
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", "comment");
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            return iIOMetadataNode;
        }
        return null;
    }
}

