/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dcx;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.dcx.DCXHeader;
import com.twelvemonkeys.imageio.plugins.pcx.PCXImageReader;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

public final class DCXImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.dcx.debug"));
    private DCXHeader header;
    private int index = -1;
    private PCXImageReader readerDelegate;
    private ProgressDelegator progressDelegator;

    DCXImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
        this.readerDelegate = new PCXImageReader(imageReaderSpi);
        this.progressDelegator = new ProgressDelegator();
        this.installListeners();
    }

    private void installListeners() {
        this.readerDelegate.addIIOReadProgressListener(this.progressDelegator);
        this.readerDelegate.addIIOReadWarningListener(this.progressDelegator);
    }

    @Override
    protected void resetMembers() {
        this.header = null;
        this.index = -1;
        this.readerDelegate.reset();
        this.installListeners();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.readerDelegate.dispose();
        this.readerDelegate = null;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.initIndex(n);
        return this.readerDelegate.getWidth(0);
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.initIndex(n);
        return this.readerDelegate.getHeight(0);
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.initIndex(n);
        return this.readerDelegate.getRawImageType(0);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.initIndex(n);
        return this.readerDelegate.getImageTypes(0);
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.initIndex(n);
        return this.readerDelegate.read(n, imageReadParam);
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.initIndex(n);
        return this.readerDelegate.getImageMetadata(0);
    }

    @Override
    public synchronized void abort() {
        super.abort();
        this.readerDelegate.abort();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        this.readHeader();
        return this.header.getCount();
    }

    private void initIndex(int n) throws IOException {
        this.checkBounds(n);
        if (this.index != n) {
            this.imageInput.seek(this.header.getOffset(n));
            this.index = n;
            this.readerDelegate.setInput(new SubImageInputStream(this.imageInput, Long.MAX_VALUE));
        }
    }

    private void readHeader() throws IOException {
        this.assertInput();
        if (this.header == null) {
            this.imageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            this.header = DCXHeader.read(this.imageInput);
            if (DEBUG) {
                System.err.println("header: " + this.header);
            }
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
        }
        this.imageInput.seek(this.imageInput.getFlushedPosition());
    }

    public static void main(String[] stringArray) throws IOException {
        DCXImageReader dCXImageReader = new DCXImageReader(null);
        for (String string : stringArray) {
            File file = new File(string);
            dCXImageReader.setInput(ImageIO.createImageInputStream(file));
            ImageReadParam imageReadParam = dCXImageReader.getDefaultReadParam();
            imageReadParam.setDestinationType(dCXImageReader.getImageTypes(0).next());
            System.err.println("header: " + dCXImageReader.header);
            BufferedImage bufferedImage = dCXImageReader.read(0, imageReadParam);
            System.err.println("image: " + bufferedImage);
            DCXImageReader.showIt(bufferedImage, file.getName());
            new XMLSerializer(System.out, System.getProperty("file.encoding")).serialize(dCXImageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0"), false);
        }
    }

    private class ProgressDelegator
    extends ProgressListenerBase
    implements IIOReadWarningListener {
        private ProgressDelegator() {
        }

        @Override
        public void imageComplete(ImageReader imageReader) {
            DCXImageReader.this.processImageComplete();
        }

        @Override
        public void imageProgress(ImageReader imageReader, float f) {
            DCXImageReader.this.processImageProgress(f);
        }

        @Override
        public void imageStarted(ImageReader imageReader, int n) {
            DCXImageReader.this.processImageStarted(DCXImageReader.this.index);
        }

        @Override
        public void readAborted(ImageReader imageReader) {
            DCXImageReader.this.processReadAborted();
        }

        @Override
        public void sequenceComplete(ImageReader imageReader) {
            DCXImageReader.this.processSequenceComplete();
        }

        @Override
        public void sequenceStarted(ImageReader imageReader, int n) {
            DCXImageReader.this.processSequenceStarted(DCXImageReader.this.index);
        }

        @Override
        public void warningOccurred(ImageReader imageReader, String string) {
            DCXImageReader.this.processWarningOccurred(string);
        }
    }
}

